/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.AbstractSmapGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.FileInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfoCollector;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineNumberProvider;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SmapStratum;

public class TeamSmapGenerator
extends AbstractSmapGenerator {
    public TeamSmapGenerator(TypeDeclaration type) {
        super(type);
    }

    @Override
    public char[] generate() {
        for (SmapStratum stratum : this._strata) {
            if (!stratum.getStratumName().equals("OTJ")) continue;
            return this.generateOTJSmap(stratum);
        }
        return null;
    }

    private char[] generateOTJSmap(SmapStratum stratum) {
        LineInfoCollector lineInfoCollector = new LineInfoCollector();
        LineNumberProvider provider = this._type.getTeamModel().getLineNumberProvider();
        Set<ReferenceBinding> copySources = provider.getLineInfos().keySet();
        if (copySources.isEmpty()) {
            return null;
        }
        for (ReferenceBinding copySrc : copySources) {
            List<LineInfo> lineInfos = provider.getLineInfosForType(copySrc);
            FileInfo fileInfo = this.getOrCreateFileInfoForType(stratum, copySrc);
            fileInfo.addLineInfo(lineInfos);
            lineInfoCollector.storeLineInfos(lineInfos);
        }
        FileInfo teamFile = this.getOrCreateFileInfoForType(stratum, this._type.binding);
        LineInfo lineInfo = new LineInfo(1, 1);
        lineInfo.setRepeatCount(provider.getSourceEndLineNumber());
        teamFile.addLineInfo(lineInfo);
        LineInfo stepOverLineInfo = new LineInfo(65534, 65534);
        teamFile.addLineInfo(stepOverLineInfo);
        lineInfoCollector.storeLineInfo(stepOverLineInfo);
        LineInfo stepIntoLineInfo = new LineInfo(65533, 65533);
        teamFile.addLineInfo(stepIntoLineInfo);
        lineInfoCollector.storeLineInfo(stepIntoLineInfo);
        return this.getSMAP().toCharArray();
    }
}

