/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;

public class StaticReplaceBindingsAttribute
extends AbstractAttribute {
    private CallinMappingDeclaration[] _mappingDeclarations;
    private Mapping[] _mappings;
    private int _size;

    public StaticReplaceBindingsAttribute(CallinMappingDeclaration[] decls) {
        super(IOTConstants.STATIC_REPLACE_BINDINGS);
        this._size = 0;
        int len = decls.length;
        int i = 0;
        while (i < decls.length) {
            if (decls[i].ignoreFurtherInvestigation) {
                --len;
            }
            ++i;
        }
        this._mappingDeclarations = new CallinMappingDeclaration[len];
        int idx = 0;
        int i2 = 0;
        while (i2 < decls.length) {
            CallinMappingDeclaration decl = decls[i2];
            if (!decl.ignoreFurtherInvestigation) {
                this._mappingDeclarations[idx++] = decl;
            }
            ++i2;
        }
    }

    private void checkTranslateMappings() {
        if (this._mappingDeclarations == null) {
            return;
        }
        int idx = 0;
        if (this._mappings != null) {
            int len1 = this._mappings.length;
            int len2 = this._mappingDeclarations.length;
            this._mappings = new Mapping[len1 + len2];
            System.arraycopy(this._mappings, 0, this._mappings, 0, len1);
            idx = len1;
        } else {
            this._mappings = new Mapping[this._mappingDeclarations.length];
        }
        int i = 0;
        while (i < this._mappingDeclarations.length) {
            this._mappings[idx++] = this.translateMapping(this._mappingDeclarations[i]);
            ++i;
        }
        this._mappingDeclarations = null;
    }

    private Mapping translateMapping(CallinMappingDeclaration decl) {
        SourceTypeBinding roleClass = decl.scope.enclosingSourceType();
        ReferenceBinding baseClass = null;
        if (roleClass != null) {
            baseClass = roleClass.baseclass();
        }
        if (baseClass != null && baseClass.isRoleType()) {
            baseClass = ((RoleTypeBinding)baseClass).getRealClass();
        }
        this._size += 10;
        Mapping currentMapping = new Mapping(decl.roleMethodSpec.resolvedMethod.declaringClass.sourceName(), decl.roleMethodSpec.selector, decl.roleMethodSpec.signature(CompilerOptions.WeavingScheme.OTRE), decl.liftMethod != null ? decl.liftMethod.selector : new char[]{}, decl.liftMethod != null ? decl.liftMethod.signature() : new char[]{});
        MethodSpec[] baseMethods = decl.baseMethodSpecs;
        currentMapping._baseMethods = new BaseMethod[baseMethods.length];
        this._size += 2;
        int j = 0;
        while (j < baseMethods.length) {
            MethodSpec bm = baseMethods[j];
            this._size += 13;
            if (decl.positions != null) {
                this._size += 2 * decl.positions.length;
            }
            currentMapping._baseMethods[j] = new BaseMethod(baseClass != null ? baseClass.attributeName() : new char[]{}, bm.selector, bm.resolvedMethod.signature(), bm.isCallin(), baseClass != null && baseClass.isRole(), bm.isStatic(), decl.positions, bm.getTranslationFlags());
            ++j;
        }
        return currentMapping;
    }

    public StaticReplaceBindingsAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(IOTConstants.STATIC_REPLACE_BINDINGS);
        this._reader = reader;
        this._readOffset = readOffset;
        this._constantPoolOffsets = constantPoolOffsets;
        this._size = 0;
        int numMappings = this.consumeShort();
        this._mappings = new Mapping[numMappings];
        int i = 0;
        while (i < numMappings) {
            this._mappings[i] = this.readMapping();
            ++i;
        }
    }

    @Override
    public void merge(ModelElement model, AbstractAttribute superDeclaringType) {
        int len;
        int lOther;
        int l;
        assert (superDeclaringType instanceof StaticReplaceBindingsAttribute);
        StaticReplaceBindingsAttribute otherSRBA = (StaticReplaceBindingsAttribute)superDeclaringType;
        if (otherSRBA._mappings != null) {
            if (this._mappings != null) {
                l = this._mappings.length;
                lOther = otherSRBA._mappings.length;
                this._mappings = new Mapping[l + lOther];
                System.arraycopy(this._mappings, 0, this._mappings, 0, l);
                System.arraycopy(otherSRBA._mappings, 0, this._mappings, l, lOther);
            } else {
                len = otherSRBA._mappings.length;
                this._mappings = new Mapping[len];
                System.arraycopy(otherSRBA._mappings, 0, this._mappings, 0, len);
            }
            this._size += otherSRBA._size;
        }
        if (otherSRBA._mappingDeclarations != null) {
            if (this._mappingDeclarations != null) {
                l = this._mappingDeclarations.length;
                lOther = otherSRBA._mappingDeclarations.length;
                this._mappingDeclarations = new CallinMappingDeclaration[l + lOther];
                System.arraycopy(this._mappingDeclarations, 0, this._mappingDeclarations, 0, l);
                System.arraycopy(otherSRBA._mappingDeclarations, 0, this._mappingDeclarations, l, lOther);
            } else {
                len = otherSRBA._mappingDeclarations.length;
                this._mappingDeclarations = new CallinMappingDeclaration[len];
                System.arraycopy(otherSRBA._mappingDeclarations, 0, this._mappingDeclarations, 0, len);
            }
        }
    }

    private Mapping readMapping() {
        this._size += 10;
        Mapping map = new Mapping(this.consumeName(), this.consumeName(), this.consumeName(), this.consumeName(), this.consumeName());
        this._size += 2;
        int numBaseMethods = this.consumeShort();
        map._baseMethods = new BaseMethod[numBaseMethods];
        int i = 0;
        while (i < numBaseMethods) {
            map._baseMethods[i] = this.readBaseMethod();
            ++i;
        }
        return map;
    }

    private BaseMethod readBaseMethod() {
        this._size += 13;
        char[] className = this.consumeName();
        char[] methName = this.consumeName();
        char[] signature = this.consumeName();
        int flags = this.consumeByte();
        boolean isCallin = (flags & 1) != 0;
        boolean isRoleMethod = (flags & 2) != 0;
        boolean isStatic = (flags & 4) != 0;
        int[] positions = null;
        int n = this.consumeShort();
        if (n > 0) {
            this._size += 2 * n;
            positions = new int[n];
            int i = 0;
            while (i < positions.length) {
                positions[i] = this.consumeShort();
                ++i;
            }
        }
        int translationFlags = this.consumeInt();
        return new BaseMethod(className, methName, signature, isCallin, isRoleMethod, isStatic, positions, translationFlags);
    }

    @Override
    public void write(ClassFile classFile) {
        this.checkTranslateMappings();
        super.write(classFile);
        this.writeValues(classFile);
        this.writeBack(classFile);
    }

    private void writeValues(ClassFile classFile) {
        if (this._contentsOffset + 8 + this._size >= this._contents.length) {
            this._contents = classFile.getResizedContents(8 + this._size);
        }
        this.writeName(this._name);
        this.writeInt(this._size + 2);
        this.writeUnsignedShort(this._mappings.length);
        int i = 0;
        while (i < this._mappings.length) {
            Mapping map = this._mappings[i];
            this.writeName(map._roleClass);
            this.writeName(map._roleSelector);
            this.writeName(map._roleSignature);
            this.writeName(map._liftMethodName);
            this.writeName(map._liftMethodSignature);
            this.writeBaseMethods(this._mappings[i]._baseMethods);
            ++i;
        }
    }

    private void writeBaseMethods(BaseMethod[] methods) {
        this.writeUnsignedShort(methods.length);
        int i = 0;
        while (i < methods.length) {
            this.writeName(methods[i]._baseclass);
            this.writeName(methods[i]._selector);
            this.writeName(methods[i]._signature);
            int flags = 0;
            if (methods[i]._isCallin) {
                flags |= 1;
            }
            if (methods[i]._isRoleMethod) {
                flags |= 2;
            }
            if (methods[i]._isStatic) {
                flags |= 4;
            }
            this.writeByte((byte)flags);
            int[] positions = methods[i]._positions;
            if (positions == null) {
                this.writeUnsignedShort(0);
            } else {
                this.writeUnsignedShort(positions.length);
                int j = 0;
                while (j < positions.length) {
                    this.writeUnsignedShort(positions[j]);
                    ++j;
                }
            }
            this.writeInt(methods[i]._translationFlags);
            ++i;
        }
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, 0x20000000);
        ((ReferenceBinding)binding).getTeamModel().addAttribute(this);
    }

    @Override
    public void evaluateLateAttribute(ReferenceBinding roleBinding, int state) {
    }

    public String toString() {
        String result;
        block3: {
            block2: {
                result = new String(this._name);
                if (this._mappings == null) break block2;
                int i = 0;
                while (i < this._mappings.length) {
                    result = String.valueOf(result) + "\n" + this._mappings[i];
                    ++i;
                }
                break block3;
            }
            if (this._mappingDeclarations == null) break block3;
            int i = 0;
            while (i < this._mappingDeclarations.length) {
                result = String.valueOf(result) + "\n" + this._mappingDeclarations[i];
                ++i;
            }
        }
        return result;
    }

    private class BaseMethod {
        static final int FLAG_CALLIN = 1;
        static final int FLAG_ROLE_METHOD = 2;
        static final int FLAG_STATIC = 4;
        private static final int ATTRIBUTE_LEN = 13;
        char[] _baseclass;
        char[] _selector;
        char[] _signature;
        boolean _isCallin;
        boolean _isRoleMethod;
        boolean _isStatic;
        int[] _positions;
        int _translationFlags;

        BaseMethod(char[] baseclass, char[] sel, char[] sig, boolean isCallin, boolean isRoleMethod, boolean isStatic, int[] positions, int translations) {
            this._baseclass = baseclass;
            this._selector = sel;
            this._signature = sig;
            this._isCallin = isCallin;
            this._isRoleMethod = isRoleMethod;
            this._isStatic = isStatic;
            this._positions = positions;
            this._translationFlags = translations;
        }

        public String toString() {
            String result = String.valueOf(this._isCallin ? "callin " : "") + (this._isRoleMethod ? "role " : "") + (this._isStatic ? "static " : "") + new String(this._baseclass) + "." + new String(this._selector) + new String(this._signature);
            if (this._positions != null) {
                result = String.valueOf(result) + "(";
                int j = 0;
                while (j < this._positions.length) {
                    result = String.valueOf(result) + this._positions[j] + ",";
                    ++j;
                }
                result = String.valueOf(result) + ")";
            }
            return result;
        }
    }

    private class Mapping {
        char[] _roleClass;
        char[] _roleSelector;
        char[] _roleSignature;
        char[] _liftMethodName;
        char[] _liftMethodSignature;
        BaseMethod[] _baseMethods;

        Mapping(char[] roleClass, char[] selector, char[] signature, char[] liftMethodName, char[] liftMethodSignature) {
            this._roleClass = roleClass;
            this._roleSelector = selector;
            this._roleSignature = signature;
            this._liftMethodName = liftMethodName;
            this._liftMethodSignature = liftMethodSignature;
        }

        public String toString() {
            String result = String.valueOf(new String(this._roleClass)) + "." + new String(this._roleSelector) + new String(this._roleSignature) + " <- ";
            int i = 0;
            while (i < this._baseMethods.length) {
                result = String.valueOf(result) + this._baseMethods[i].toString();
                ++i;
            }
            if (this._liftMethodName.length > 0) {
                result = String.valueOf(result) + "\nlift by: " + new String(this._liftMethodName) + new String(this._liftMethodSignature);
            }
            return result;
        }
    }
}

