/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.IMethodMappingBinding;
import org.eclipse.jdt.core.dom.MethodBindingOperator;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.ParameterMapping;

public abstract class AbstractMethodMappingDeclaration
extends BodyDeclaration {
    protected MethodMappingElement roleMappingElement = null;
    protected MethodBindingOperator bindingOperator = null;
    ASTNode.NodeList parameterMappings = new ASTNode.NodeList(this.internalParameterMappingsProperty());
    private int withKeywordStart;

    AbstractMethodMappingDeclaration(AST ast) {
        super(ast);
    }

    public abstract ChildPropertyDescriptor getRoleElementProperty();

    abstract ChildPropertyDescriptor internalGetBindingOperatorProperty();

    abstract ChildListPropertyDescriptor internalParameterMappingsProperty();

    static final ChildListPropertyDescriptor internalParameterMappingPropertyFactory(Class nodeClass) {
        return new ChildListPropertyDescriptor(nodeClass, "parameterMappings", ParameterMapping.class, true);
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == this.getRoleElementProperty()) {
            if (get) {
                return this.getRoleMappingElement();
            }
            this.setRoleMappingElement((MethodSpec)child);
            return null;
        }
        if (property == this.internalGetBindingOperatorProperty()) {
            if (get) {
                return this.bindingOperator();
            }
            this.setBindingOperator((MethodBindingOperator)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodMappingElement getRoleMappingElement() {
        if (this.roleMappingElement == null) {
            AbstractMethodMappingDeclaration abstractMethodMappingDeclaration = this;
            synchronized (abstractMethodMappingDeclaration) {
                if (this.roleMappingElement == null) {
                    this.preLazyInit();
                    this.roleMappingElement = new MethodSpec(this.ast);
                    this.postLazyInit(this.roleMappingElement, this.getRoleElementProperty());
                }
            }
        }
        return this.roleMappingElement;
    }

    public void setRoleMappingElement(MethodMappingElement roleMappingElement) {
        if (roleMappingElement == null) {
            throw new IllegalArgumentException();
        }
        MethodMappingElement oldChild = roleMappingElement;
        this.preReplaceChild(oldChild, roleMappingElement, this.getRoleElementProperty());
        this.roleMappingElement = roleMappingElement;
        this.postReplaceChild(oldChild, roleMappingElement, this.getRoleElementProperty());
    }

    public void setBindingOperator(MethodBindingOperator bindingOp) {
        ChildPropertyDescriptor propertyDescriptor = this.internalGetBindingOperatorProperty();
        MethodBindingOperator oldOperator = this.bindingOperator;
        this.preReplaceChild(oldOperator, bindingOp, propertyDescriptor);
        this.bindingOperator = bindingOp;
        this.postReplaceChild(oldOperator, bindingOp, propertyDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodBindingOperator bindingOperator() {
        if (this.bindingOperator == null) {
            AbstractMethodMappingDeclaration abstractMethodMappingDeclaration = this;
            synchronized (abstractMethodMappingDeclaration) {
                if (this.bindingOperator == null) {
                    this.preLazyInit();
                    this.bindingOperator = new MethodBindingOperator(this.ast);
                    this.postLazyInit(this.bindingOperator, this.internalGetBindingOperatorProperty());
                }
            }
        }
        return this.bindingOperator;
    }

    public List getParameterMappings() {
        return this.parameterMappings;
    }

    public boolean hasParameterMapping() {
        return !this.parameterMappings.isEmpty();
    }

    public boolean hasSignature() {
        return this.getRoleMappingElement().hasSignature();
    }

    public void removeSignatures() {
        this.removeSignatureFrom(this.getRoleMappingElement());
    }

    void removeSignatureFrom(MethodMappingElement mappingElement) {
        mappingElement.setSignatureFlag(false);
        switch (mappingElement.getNodeType()) {
            case 112: {
                MethodSpec spec = (MethodSpec)mappingElement;
                spec.setReturnType2(null);
                List typeParams = spec.typeParameters();
                while (typeParams.size() > 0) {
                    typeParams.remove(0);
                }
                List params = spec.parameters();
                while (params.size() > 0) {
                    params.remove(0);
                }
                break;
            }
            case 120: {
                FieldAccessSpec fieldSpec = (FieldAccessSpec)mappingElement;
                fieldSpec.setFieldType(null);
            }
        }
    }

    public IMethodMappingBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveMethodMapping(this);
    }

    public void setWithKeywordStart(int withKeywordStart) {
        this.withKeywordStart = withKeywordStart;
    }

    public int getWithKeywordStart() {
        return this.withKeywordStart;
    }
}

