/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IMethodNode;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;

public class MethodSpec
extends MethodMappingElement
implements IMethodNode {
    public static final SimplePropertyDescriptor SIGNATURE_PROPERTY = MethodSpec.internalSignaturePropertyFactory(MethodSpec.class);
    public static final SimplePropertyDescriptor COVARIANT_RETURN_PROPERTY = new SimplePropertyDescriptor(MethodSpec.class, "covariantReturn", Boolean.TYPE, true);
    public static final ChildPropertyDescriptor NAME_PROPERTY = MethodSpec.internalNamePropertyFactory(MethodSpec.class);
    public static final ChildPropertyDescriptor RETURN_TYPE_PROPERTY = new ChildPropertyDescriptor(MethodSpec.class, "returnType", Type.class, true, false);
    public static final ChildPropertyDescriptor RETURN_TYPE2_PROPERTY = new ChildPropertyDescriptor(MethodSpec.class, "returnType2", Type.class, false, false);
    public static final ChildListPropertyDescriptor TYPE_PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(MethodSpec.class, "typeParameters", TypeParameter.class, false);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(MethodSpec.class, "parameters", SingleVariableDeclaration.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_2_0;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_3_0;
    private ASTNode.NodeList parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    private Type returnType = null;
    private ASTNode.NodeList typeParameters = null;
    private boolean _hasCovariantReturn;

    static {
        ArrayList propertyList = new ArrayList(6);
        MethodSpec.createPropertyList(MethodSpec.class, propertyList);
        MethodSpec.addProperty(RETURN_TYPE_PROPERTY, propertyList);
        MethodSpec.addProperty(NAME_PROPERTY, propertyList);
        MethodSpec.addProperty(PARAMETERS_PROPERTY, propertyList);
        MethodSpec.addProperty(SIGNATURE_PROPERTY, propertyList);
        MethodSpec.addProperty(COVARIANT_RETURN_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = MethodSpec.reapPropertyList(propertyList);
        propertyList = new ArrayList(7);
        MethodSpec.createPropertyList(MethodSpec.class, propertyList);
        MethodSpec.addProperty(RETURN_TYPE2_PROPERTY, propertyList);
        MethodSpec.addProperty(TYPE_PARAMETERS_PROPERTY, propertyList);
        MethodSpec.addProperty(NAME_PROPERTY, propertyList);
        MethodSpec.addProperty(PARAMETERS_PROPERTY, propertyList);
        MethodSpec.addProperty(SIGNATURE_PROPERTY, propertyList);
        MethodSpec.addProperty(COVARIANT_RETURN_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = MethodSpec.reapPropertyList(propertyList);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    MethodSpec(AST ast) {
        super(ast);
        if (ast.apiLevel >= 3) {
            this.typeParameters = new ASTNode.NodeList(TYPE_PARAMETERS_PROPERTY);
        }
    }

    public boolean hasCovariantReturn() {
        return this._hasCovariantReturn;
    }

    public void setCovariantReturnFlag(boolean hasCovariantReturn) {
        this.preValueChange(COVARIANT_RETURN_PROPERTY);
        this._hasCovariantReturn = hasCovariantReturn;
        this.postValueChange(COVARIANT_RETURN_PROPERTY);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return MethodSpec.propertyDescriptors(apiLevel);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == SIGNATURE_PROPERTY) {
            if (get) {
                return this.hasSignature();
            }
            this.setSignatureFlag(value);
            return false;
        }
        if (property == COVARIANT_RETURN_PROPERTY) {
            if (get) {
                return this.hasCovariantReturn();
            }
            this.setCovariantReturnFlag(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == RETURN_TYPE_PROPERTY) {
            if (get) {
                return this.getReturnType();
            }
            this.setReturnType((Type)child);
            return null;
        }
        if (property == RETURN_TYPE2_PROPERTY) {
            if (get) {
                return this.getReturnType2();
            }
            this.setReturnType2((Type)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == TYPE_PARAMETERS_PROPERTY) {
            return this.typeParameters();
        }
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        return super.internalGetChildListProperty(property);
    }

    final ChildListPropertyDescriptor internalModifiers2Property() {
        return null;
    }

    @Override
    public SimplePropertyDescriptor signatureProperty() {
        return SIGNATURE_PROPERTY;
    }

    @Override
    ChildPropertyDescriptor internalNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    final int getNodeType0() {
        return 112;
    }

    @Override
    ASTNode clone0(AST target) {
        MethodSpec result = new MethodSpec(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        if (this.ast.apiLevel == 2) {
            result.setReturnType((Type)ASTNode.copySubtree(target, this.getReturnType()));
        }
        if (this.ast.apiLevel >= 3) {
            result.setReturnType2((Type)ASTNode.copySubtree(target, this.getReturnType2()));
            result.typeParameters().addAll(ASTNode.copySubtrees(target, this.typeParameters()));
        }
        result.setName((SimpleName)this.getName().clone(target));
        result.parameters().addAll(ASTNode.copySubtrees(target, this.parameters()));
        result.setSignatureFlag(this.hasSignature());
        result.setCovariantReturnFlag(this.hasCovariantReturn());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel == 2) {
                this.acceptChild(visitor, this.getReturnType());
            } else {
                this.acceptChild(visitor, this.getReturnType2());
            }
            this.acceptChild(visitor, this.getName());
            this.acceptChildren(visitor, this.typeParameters);
            this.acceptChildren(visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    @Override
    public List parameters() {
        return this.parameters;
    }

    @Override
    public List typeParameters() {
        if (this.typeParameters == null) {
            this.unsupportedIn2();
        }
        return this.typeParameters;
    }

    public IMethodBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getReturnType() {
        this.supportedOnlyIn2();
        if (this.returnType == null) {
            MethodSpec methodSpec = this;
            synchronized (methodSpec) {
                if (this.returnType == null) {
                    this.preLazyInit();
                    this.returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    this.postLazyInit(this.returnType, RETURN_TYPE_PROPERTY);
                }
            }
        }
        return this.returnType;
    }

    public void setReturnType(Type type) {
        this.supportedOnlyIn2();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
        this.returnType = type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
    }

    @Override
    public Type getReturnType2() {
        this.unsupportedIn2();
        return this.returnType;
    }

    @Override
    public void setReturnType2(Type type) {
        this.unsupportedIn2();
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
        this.returnType = type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
    }

    @Override
    int memSize() {
        return 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.getName() == null ? 0 : this.getName().treeSize()) + (this.returnType == null ? 0 : this.returnType.treeSize()) + this.parameters.listSize() + this.typeParameters.listSize();
    }
}

