/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeAnchor;

public class ParameterizedType
extends Type {
    int index;
    public static final ChildPropertyDescriptor TYPE_PROPERTY = new ChildPropertyDescriptor(ParameterizedType.class, "type", Type.class, true, true);
    public static final ChildListPropertyDescriptor TYPE_ARGUMENTS_PROPERTY = new ChildListPropertyDescriptor(ParameterizedType.class, "typeArguments", Type.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Type type = null;
    private ASTNode.NodeList typeArguments = new ASTNode.NodeList(TYPE_ARGUMENTS_PROPERTY);

    static {
        ArrayList propertyList = new ArrayList(3);
        ParameterizedType.createPropertyList(ParameterizedType.class, propertyList);
        ParameterizedType.addProperty(TYPE_PROPERTY, propertyList);
        ParameterizedType.addProperty(TYPE_ARGUMENTS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = ParameterizedType.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    ParameterizedType(AST ast) {
        super(ast);
        this.unsupportedIn2();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return ParameterizedType.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == TYPE_PROPERTY) {
            if (get) {
                return this.getType();
            }
            this.setType((Type)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == TYPE_ARGUMENTS_PROPERTY) {
            return this.typeArguments();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 74;
    }

    @Override
    ASTNode clone0(AST target) {
        ParameterizedType result = new ParameterizedType(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setType((Type)this.getType().clone(target));
        result.typeArguments().addAll(ASTNode.copySubtrees(target, this.typeArguments()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getType());
            this.acceptChildren(visitor, this.typeArguments);
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getType() {
        if (this.type == null) {
            ParameterizedType parameterizedType = this;
            synchronized (parameterizedType) {
                if (this.type == null) {
                    this.preLazyInit();
                    this.type = new SimpleType(this.ast);
                    this.postLazyInit(this.type, TYPE_PROPERTY);
                }
            }
        }
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Type oldChild = this.type;
        this.preReplaceChild(oldChild, type, TYPE_PROPERTY);
        this.type = type;
        this.postReplaceChild(oldChild, type, TYPE_PROPERTY);
    }

    public List typeArguments() {
        return this.typeArguments;
    }

    @Override
    int memSize() {
        return 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.type == null ? 0 : this.getType().treeSize()) + this.typeArguments.listSize();
    }

    public boolean isDependentType(boolean onlyRelevant) {
        Name path;
        if (this.typeArguments.listSize() == 0) {
            return false;
        }
        ASTNode arg0 = (ASTNode)this.typeArguments.get(0);
        if (arg0.getNodeType() == 124 && (path = ((TypeAnchor)arg0).getPath()).isSimpleName()) {
            return ((SimpleName)path).getIdentifier().equals("tthis");
        }
        return false;
    }

    public String[] getAnchorPath() {
        Type typeArgument;
        if (this.typeArguments.listSize() > 0 && (typeArgument = (Type)this.typeArguments.get(0)).getNodeType() == 124) {
            return ((TypeAnchor)typeArgument).getPath().getFullyQualifiedName().split(".");
        }
        return new String[0];
    }
}

