/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BytecodeTransformer;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObject;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectMapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectReader;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class TeamMethodGenerator {
    static final char[][] JAVA_LANG_WEAKHASHMAP = new char[][]{"java".toCharArray(), "util".toCharArray(), "WeakHashMap".toCharArray()};
    static final char[][] JAVA_LANG_THREAD = new char[][]{"java".toCharArray(), "lang".toCharArray(), "Thread".toCharArray()};
    static final char[][] JAVA_LANG_THREADLOCAL = new char[][]{"java".toCharArray(), "lang".toCharArray(), "ThreadLocal".toCharArray()};
    MethodDescriptor[] methodDescriptors = new MethodDescriptor[]{new MethodDescriptor("activate", "()V", Type.NONE, Type.NONE, 1), new MethodDescriptor("activate", "(Ljava/lang/Thread;)V", Type.THREAD, Type.NONE, 1), new MethodDescriptor("deactivate", "()V", Type.NONE, Type.NONE, 1), new MethodDescriptor("deactivate", "(Ljava/lang/Thread;)V", Type.THREAD, Type.NONE, 1), new MethodDescriptor("isActive", "()Z", Type.NONE, Type.BOOLEAN, 17), new MethodDescriptor("isActive", "(Ljava/lang/Thread;)Z", Type.THREAD, Type.BOOLEAN, 17), new MethodDescriptor("isExecutingCallin", "()Z", Type.NONE, Type.BOOLEAN, 1), new MethodDescriptor("deactivateForEndedThread", "(Ljava/lang/Thread;)V", Type.THREAD, Type.NONE, 1), new MethodDescriptor("internalIsActiveSpecificallyFor", "(Ljava/lang/Thread;)Z", Type.THREAD, Type.BOOLEAN, 1), new MethodDescriptor("_OT$setExecutingCallin", "(Z)Z", Type.BOOLEAN, Type.BOOLEAN, 1), new MethodDescriptor("_OT$activateForAllThreads", "()V", Type.NONE, Type.NONE, 2), new MethodDescriptor("_OT$saveActivationState", "()I", Type.NONE, Type.INT, 33), new MethodDescriptor("_OT$restoreActivationState", "(I)V", Type.INT, Type.NONE, 1), new MethodDescriptor("doRegistration", "()V", Type.NONE, Type.NONE, 2), new MethodDescriptor("doUnregistration", "()V", Type.NONE, Type.NONE, 2)};
    final MethodDescriptor[] methodDescriptorsDyn = new MethodDescriptor[]{new MethodDescriptor("_OT$callAllBindings", "(Lorg/objectteams/IBoundBase2;[Lorg/objectteams/ITeam;I[II[Ljava/lang/Object;)Ljava/lang/Object;", Type.OTDYNARGS1, Type.OBJECT, 1), new MethodDescriptor("_OT$callNext", "(Lorg/objectteams/IBoundBase2;[Lorg/objectteams/ITeam;I[II[Ljava/lang/Object;[Ljava/lang/Object;I)Ljava/lang/Object;", Type.OTDYNARGS2, Type.OBJECT, 1), new MethodDescriptor("_OT$callReplace", "(Lorg/objectteams/IBoundBase2;[Lorg/objectteams/ITeam;I[II[Ljava/lang/Object;)Ljava/lang/Object;", Type.OTDYNARGS1, Type.OBJECT, 1), new MethodDescriptor("_OT$callBefore", "(Lorg/objectteams/IBoundBase2;II[Ljava/lang/Object;)V", Type.OTDYNARGS3, Type.NONE, 1), new MethodDescriptor("_OT$callAfter", "(Lorg/objectteams/IBoundBase2;II[Ljava/lang/Object;Ljava/lang/Object;)V", Type.OTDYNARGS4, Type.NONE, 1), new MethodDescriptor("_OT$callOrigStatic", "(II[Ljava/lang/Object;)Ljava/lang/Object;", Type.OTDYNARGS5, Type.OBJECT, 1)};
    public byte[] classBytes;
    public int[] constantPoolOffsets;
    public SourceTypeBinding ooTeamBinding;

    public TeamMethodGenerator(CompilerOptions.WeavingScheme weavingScheme) {
        if (weavingScheme == CompilerOptions.WeavingScheme.OTDRE) {
            int l1 = this.methodDescriptors.length;
            int l2 = this.methodDescriptorsDyn.length;
            MethodDescriptor[] all = new MethodDescriptor[l1 + l2];
            System.arraycopy(this.methodDescriptors, 0, all, 0, l1);
            System.arraycopy(this.methodDescriptorsDyn, 0, all, l1, l2);
            this.methodDescriptors = all;
        }
    }

    public void registerTeamMethodWithoutBytes(IBinaryType binaryType, IBinaryMethod method, MethodBinding methodBinding, LookupEnvironment environment) {
        try {
            char[] selector = method.getSelector();
            char[] descriptor = method.getMethodDescriptor();
            File file = new File(String.valueOf(binaryType.getFileName()));
            ClassFileReader reader = ClassFileReader.read(file, true);
            IBinaryMethod[] iBinaryMethodArray = reader.getMethods();
            int n = iBinaryMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryMethod binMethod = iBinaryMethodArray[n2];
                if (CharOperation.equals(selector, binMethod.getSelector()) && CharOperation.equals(descriptor, binMethod.getMethodDescriptor())) {
                    this.registerTeamMethod(binMethod, methodBinding);
                    break;
                }
                ++n2;
            }
        }
        catch (IOException | ClassFormatException exception) {}
    }

    public void registerTeamMethod(IBinaryMethod method, MethodBinding methodBinding) {
        String selector = String.valueOf(method.getSelector());
        String descriptor = String.valueOf(method.getMethodDescriptor());
        this.registerTeamMethod(methodBinding.declaringClass, methodBinding, selector, descriptor, -1);
    }

    public synchronized void maybeRegisterTeamClassBytes(ClassFileReader teamClass, ReferenceBinding teamClassBinding) {
        if (this.classBytes != null) {
            return;
        }
        this.classBytes = teamClass.getBytes();
        this.constantPoolOffsets = teamClass.getConstantPoolOffsets();
        IBinaryMethod[] iBinaryMethodArray = teamClass.getMethods();
        int n = iBinaryMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinaryMethod method = iBinaryMethodArray[n2];
            if (this.classBytes == null && method instanceof MethodInfo) {
                this.classBytes = ((MethodInfo)method).reference;
                this.constantPoolOffsets = ((MethodInfo)method).constantPoolOffsets;
            }
            String selector = String.valueOf(method.getSelector());
            String descriptor = String.valueOf(method.getMethodDescriptor());
            int structOffset = ((MethodInfo)method).getStructOffset();
            this.registerTeamMethod(teamClassBinding, null, selector, descriptor, structOffset);
            ++n2;
        }
    }

    private boolean registerTeamMethod(ReferenceBinding declaringClass, MethodBinding methodBinding, String selector, String descriptor, int structOffset) {
        int s = 0;
        while (s < this.methodDescriptors.length) {
            if (selector.equals(this.methodDescriptors[s].selector) && descriptor.equals(this.methodDescriptors[s].signature)) {
                if (methodBinding != null) {
                    this.methodDescriptors[s].binding = methodBinding;
                }
                this.methodDescriptors[s].declaringClass = declaringClass;
                this.methodDescriptors[s].methodCodeOffset = structOffset;
                return true;
            }
            ++s;
        }
        return false;
    }

    public synchronized void registerOOTeamClass(SourceTypeBinding orgObjectteamsTeamBinding) {
        if (this.classBytes != null) {
            return;
        }
        this.ooTeamBinding = orgObjectteamsTeamBinding;
    }

    public boolean requestBytes() {
        if (this.classBytes != null) {
            return true;
        }
        if (this.ooTeamBinding != null) {
            if (this.isOOTConverted()) {
                return false;
            }
            boolean result = Dependencies.ensureBindingState(this.ooTeamBinding, 25);
            MethodModel model = this.methodDescriptors[0].binding.model;
            this.classBytes = model.getBytes();
            this.constantPoolOffsets = model.getConstantPoolOffsets();
            return result;
        }
        return false;
    }

    boolean isOOTConverted() {
        if (this.ooTeamBinding == null) {
            return false;
        }
        ClassScope scope = this.ooTeamBinding.scope;
        if (scope == null) {
            return false;
        }
        TypeDeclaration typeDecl = scope.referenceContext;
        return typeDecl.isConverted;
    }

    public boolean registerSourceMethodBytes(MethodBinding method) {
        String selector = String.valueOf(method.selector);
        String signature = String.valueOf(method.signature());
        return this.registerTeamMethod(method.declaringClass, method, selector, signature, -1);
    }

    public void addMethodsAndFields(TypeDeclaration teamDecl) {
        AstGenerator gen = new AstGenerator(teamDecl);
        boolean hasBoundRole = false;
        boolean hasCallinBefore = false;
        boolean hasCallinAfter = false;
        boolean hasCallinReplace = false;
        Object[] objectArray = teamDecl.getTeamModel().getRoles(false);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding roleBinding;
            RoleModel role = objectArray[n2];
            if (role.isBound()) {
                hasBoundRole = true;
            }
            if ((roleBinding = role.getBinding()) != null && roleBinding.callinCallouts != null) {
                CallinCalloutBinding[] callinCalloutBindingArray = roleBinding.callinCallouts;
                int n3 = roleBinding.callinCallouts.length;
                int n4 = 0;
                while (n4 < n3) {
                    CallinCalloutBinding mappingBinding = callinCalloutBindingArray[n4];
                    if (mappingBinding.isCallin()) {
                        switch (mappingBinding.callinModifier) {
                            case 144: {
                                hasCallinBefore = true;
                                break;
                            }
                            case 139: {
                                hasCallinAfter = true;
                                break;
                            }
                            case 143: {
                                hasCallinReplace = true;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        objectArray = this.methodDescriptors;
        n = this.methodDescriptors.length;
        n2 = 0;
        while (n2 < n) {
            Object methodDescriptor = objectArray[n2];
            MethodDeclaration newMethod = null;
            if (!this.willBeGenerated((MethodDescriptor)methodDescriptor, teamDecl, hasCallinBefore, hasCallinAfter, hasCallinReplace)) {
                newMethod = (((MethodDescriptor)methodDescriptor).modifiers & 7) == 1 ? new CopiedTeamMethod(teamDecl.compilationResult, (MethodDescriptor)methodDescriptor, gen) : (hasBoundRole ? new CopiedTeamMethod(teamDecl.compilationResult, (MethodDescriptor)methodDescriptor, gen) : gen.method(teamDecl.compilationResult, ((MethodDescriptor)methodDescriptor).modifiers, ((MethodDescriptor)methodDescriptor).makeReturnRef(gen), ((MethodDescriptor)methodDescriptor).selector.toCharArray(), null, new Statement[0]));
                AstEdit.addGeneratedMethod(teamDecl, newMethod);
            }
            ++n2;
        }
        this.addFields(teamDecl, gen);
    }

    boolean willBeGenerated(MethodDescriptor methodDescriptor, TypeDeclaration teamDecl, boolean hasCallinBefore, boolean hasCallinAfter, boolean hasCallinReplace) {
        char[] selector = methodDescriptor.selector.toCharArray();
        if (CharOperation.equals(CallinImplementorDyn.OT_CALL_BEFORE, selector)) {
            return hasCallinBefore;
        }
        if (CharOperation.equals(CallinImplementorDyn.OT_CALL_AFTER, selector)) {
            return hasCallinAfter;
        }
        if (CharOperation.equals(CallinImplementorDyn.OT_CALL_REPLACE, selector) || CharOperation.equals(CallinImplementorDyn.OT_CALL_NEXT, selector)) {
            return hasCallinReplace;
        }
        return false;
    }

    void addFields(TypeDeclaration teamDecl, AstGenerator gen) {
        this.addPrivateField(teamDecl, gen, this.weakHashMapTypeReference(gen), "_OT$activatedThreads".toCharArray(), gen.allocation(this.weakHashMapTypeReference(gen), null));
        this.addPrivateField(teamDecl, gen, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), "_OT$registrationLock".toCharArray(), gen.allocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), null));
        this.addPrivateField(teamDecl, gen, gen.baseTypeReference(TypeConstants.BOOLEAN), "_OT$lazyGlobalActiveFlag".toCharArray(), gen.booleanLiteral(false));
        this.addPrivateField(teamDecl, gen, this.threadLocalOfBooleanReference(gen), "_OT$isExecutingCallin".toCharArray(), gen.allocation(this.threadLocalOfBooleanReference(gen), Expression.NO_EXPRESSIONS));
        this.addPrivateField(teamDecl, gen, gen.baseTypeReference(TypeConstants.INT), "_OT$registrationState".toCharArray(), gen.intLiteral(0));
        this.addPrivateField(teamDecl, gen, gen.baseTypeReference(TypeConstants.BOOLEAN), "_OT$globalActive".toCharArray(), gen.booleanLiteral(false));
        TypeDeclaration anonThreadLocal = gen.anonymousType(teamDecl.compilationResult);
        anonThreadLocal.methods = new MethodDeclaration[]{gen.method(teamDecl.compilationResult, 36, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_INTEGER), "initialValue".toCharArray(), null, new Statement[]{gen.returnStatement(gen.intLiteral(0))})};
        this.addPrivateField(teamDecl, gen, this.threadLocalReference(gen), "_OT$implicitActivationsPerThread".toCharArray(), gen.anonymousAllocation(this.threadLocalReference(gen), null, anonThreadLocal));
    }

    private QualifiedTypeReference threadLocalOfBooleanReference(AstGenerator gen) {
        return gen.parameterizedQualifiedTypeReference(JAVA_LANG_THREADLOCAL, new TypeReference[]{gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_BOOLEAN)});
    }

    void addPrivateField(TypeDeclaration teamDecl, AstGenerator gen, TypeReference type, char[] name, Expression init) {
        FieldDeclaration field = gen.field(2, type, name, init);
        boolean teamHasProblems = teamDecl.ignoreFurtherInvestigation;
        AstEdit.addField(teamDecl, field, !teamHasProblems, false, false);
        if (!teamHasProblems) {
            field.binding.modifiers |= 0x8000000;
        }
    }

    QualifiedTypeReference weakHashMapTypeReference(AstGenerator gen) {
        return gen.parameterizedQualifiedTypeReference(JAVA_LANG_WEAKHASHMAP, new TypeReference[]{gen.qualifiedTypeReference(JAVA_LANG_THREAD), gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_BOOLEAN)});
    }

    QualifiedTypeReference threadLocalReference(AstGenerator gen) {
        return gen.parameterizedQualifiedTypeReference(JAVA_LANG_THREADLOCAL, new TypeReference[]{gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_INTEGER)});
    }

    public static void addFakedTeamRegistrationMethods(ReferenceBinding teamBinding) {
        MethodBinding registrationMethod = new MethodBinding(1, "_OT$registerAtBases".toCharArray(), TypeBinding.VOID, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, teamBinding);
        teamBinding.addMethod(registrationMethod);
        MethodModel.getModel((MethodBinding)registrationMethod)._fakeKind = MethodModel.FakeKind.TEAM_REGISTRATION_METHOD;
        registrationMethod = new MethodBinding(1, "_OT$unregisterFromBases".toCharArray(), TypeBinding.VOID, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, teamBinding);
        teamBinding.addMethod(registrationMethod);
        MethodModel.getModel((MethodBinding)registrationMethod)._fakeKind = MethodModel.FakeKind.TEAM_REGISTRATION_METHOD;
    }

    public class CopiedTeamMethod
    extends MethodDeclaration {
        MethodDescriptor descriptor;

        public CopiedTeamMethod(CompilationResult compilationResult, MethodDescriptor descriptor, AstGenerator gen) {
            super(compilationResult);
            this.selector = descriptor.selector.toCharArray();
            this.descriptor = descriptor;
            this.isCopied = true;
            this.modifiers = descriptor.modifiers;
            this.arguments = descriptor.makeArgs(gen);
            this.returnType = descriptor.makeReturnRef(gen);
        }

        @Override
        public void resolve(ClassScope upperScope) {
        }

        @Override
        public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        }

        @Override
        public void generateCode(ClassScope classScope, ClassFile classFile) {
            int structOffset;
            int[] offsets;
            byte[] bytes;
            if (TeamMethodGenerator.this.isOOTConverted()) {
                return;
            }
            this.binding.copyInheritanceSrc = this.descriptor.binding;
            TeamConstantPoolMapper mapper = new TeamConstantPoolMapper(this.descriptor.binding, this.binding);
            if (this.descriptor.methodCodeOffset == -1) {
                MethodModel srcModel = this.descriptor.binding.model;
                bytes = srcModel.getBytes();
                offsets = srcModel.getConstantPoolOffsets();
                structOffset = srcModel.getStructOffset();
            } else {
                bytes = TeamMethodGenerator.this.classBytes;
                offsets = TeamMethodGenerator.this.constantPoolOffsets;
                structOffset = this.descriptor.methodCodeOffset;
            }
            ConstantPoolObjectReader reader = new ConstantPoolObjectReader(bytes, offsets, this.descriptor.declaringClass.getTeamModel(), this.scope.environment());
            new BytecodeTransformer().doCopyMethodCode(null, this.binding, (SourceTypeBinding)this.binding.declaringClass, this, bytes, offsets, structOffset, reader, mapper, classFile);
        }
    }

    static class MethodDescriptor {
        String selector;
        String signature;
        Type args;
        Type returnType;
        int modifiers;
        int methodCodeOffset;
        ReferenceBinding declaringClass;
        MethodBinding binding;

        MethodDescriptor(String selector, String signature, Type args, Type returnType, int modifiers) {
            this.selector = selector;
            this.signature = signature;
            this.args = args;
            this.returnType = returnType;
            this.modifiers = modifiers;
        }

        Argument[] makeArgs(AstGenerator gen) {
            switch (this.args) {
                case THREAD: {
                    return new Argument[]{gen.argument("thread".toCharArray(), gen.qualifiedTypeReference(JAVA_LANG_THREAD))};
                }
                case BOOLEAN: {
                    return new Argument[]{gen.argument("flag".toCharArray(), gen.baseTypeReference(TypeConstants.BOOLEAN))};
                }
                case INT: {
                    return new Argument[]{gen.argument("flags".toCharArray(), gen.baseTypeReference(TypeConstants.INT))};
                }
                case OTDYNARGS1: {
                    return new Argument[]{gen.argument("base".toCharArray(), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2)), gen.argument("teams".toCharArray(), gen.qualifiedArrayTypeReference(IOTConstants.ORG_OBJECTTEAMS_ITEAM, 1)), gen.argument("idx".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("callinIds".toCharArray(), gen.arrayTypeReference(TypeConstants.INT, 1)), gen.argument("boundMethodId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("args".toCharArray(), gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1))};
                }
                case OTDYNARGS2: {
                    return new Argument[]{gen.argument("base".toCharArray(), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2)), gen.argument("teams".toCharArray(), gen.qualifiedArrayTypeReference(IOTConstants.ORG_OBJECTTEAMS_ITEAM, 1)), gen.argument("idx".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("callinIds".toCharArray(), gen.arrayTypeReference(TypeConstants.INT, 1)), gen.argument("boundMethodId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("args".toCharArray(), gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1)), gen.argument("baseCallArgs".toCharArray(), gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1)), gen.argument("baseCallFlags".toCharArray(), gen.baseTypeReference(TypeConstants.INT))};
                }
                case OTDYNARGS3: {
                    return new Argument[]{gen.argument("base".toCharArray(), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2)), gen.argument("callinId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("boundMethodId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("args".toCharArray(), gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1))};
                }
                case OTDYNARGS4: {
                    return new Argument[]{gen.argument("base".toCharArray(), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE2)), gen.argument("callinId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("boundMethodId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("args".toCharArray(), gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1)), gen.argument("result".toCharArray(), gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT))};
                }
                case OTDYNARGS5: {
                    return new Argument[]{gen.argument("callinId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("boundMethodId".toCharArray(), gen.baseTypeReference(TypeConstants.INT)), gen.argument("args".toCharArray(), gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1))};
                }
            }
            return null;
        }

        TypeReference makeReturnRef(AstGenerator gen) {
            switch (this.returnType) {
                case BOOLEAN: {
                    return gen.baseTypeReference(TypeConstants.BOOLEAN);
                }
                case INT: {
                    return gen.baseTypeReference(TypeConstants.INT);
                }
                case NONE: {
                    return gen.baseTypeReference(TypeConstants.VOID);
                }
                case OBJECT: {
                    return gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT);
                }
            }
            throw new InternalCompilerError("Unexpected return type " + (Object)((Object)this.returnType));
        }
    }

    static class TeamConstantPoolMapper
    extends ConstantPoolObjectMapper {
        ReferenceBinding srcType;
        ReferenceBinding dstType;

        public TeamConstantPoolMapper(MethodBinding srcMethodBinding, MethodBinding dstMethodBinding) {
            super(srcMethodBinding, dstMethodBinding);
            this.srcType = srcMethodBinding.declaringClass;
            this.dstType = dstMethodBinding.declaringClass;
        }

        @Override
        public ConstantPoolObject mapConstantPoolObject(ConstantPoolObject src_cpo, boolean addMarkerArgAllowed) {
            return this.mapConstantPoolObject(src_cpo);
        }

        @Override
        public ConstantPoolObject mapConstantPoolObject(ConstantPoolObject src_cpo) {
            int type = src_cpo.getType();
            TypeBinding clazz = null;
            switch (type) {
                case 10: {
                    clazz = src_cpo.getMethodRef().declaringClass;
                    break;
                }
                case 9: {
                    clazz = src_cpo.getFieldRef().declaringClass;
                    break;
                }
                case 7: {
                    clazz = src_cpo.getClassObject();
                }
            }
            if (TypeBinding.notEquals(clazz, this.srcType)) {
                return src_cpo;
            }
            switch (type) {
                case 9: {
                    return new ConstantPoolObject(9, this.mapField(src_cpo.getFieldRef()));
                }
                case 10: {
                    return new ConstantPoolObject(10, this.mapMethod(src_cpo.getMethodRef()));
                }
                case 7: {
                    return new ConstantPoolObject(7, this.dstType);
                }
            }
            return src_cpo;
        }

        private MethodBinding mapMethod(MethodBinding methodRef) {
            MethodBinding[] methodBindingArray = this.dstType.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding dstBinding = methodBindingArray[n2];
                if (CharOperation.equals(dstBinding.selector, methodRef.selector) && CharOperation.equals(dstBinding.signature(), methodRef.signature())) {
                    return dstBinding;
                }
                ++n2;
            }
            return methodRef;
        }

        private FieldBinding mapField(FieldBinding fieldRef) {
            FieldBinding[] fieldBindingArray = this.dstType.fields();
            int n = fieldBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldBinding dstBinding = fieldBindingArray[n2];
                if (CharOperation.equals(dstBinding.name, fieldRef.name) && TypeBinding.equalsEquals(dstBinding.type, fieldRef.type)) {
                    return dstBinding;
                }
                ++n2;
            }
            return fieldRef;
        }
    }

    static enum Type {
        NONE{

            @Override
            public int length() {
                return 0;
            }
        }
        ,
        THREAD,
        BOOLEAN,
        INT,
        OBJECT,
        OTDYNARGS1{

            @Override
            int length() {
                return 6;
            }
        }
        ,
        OTDYNARGS2{

            @Override
            int length() {
                return 8;
            }
        }
        ,
        OTDYNARGS3{

            @Override
            int length() {
                return 4;
            }
        }
        ,
        OTDYNARGS4{

            @Override
            int length() {
                return 5;
            }
        }
        ,
        OTDYNARGS5{

            @Override
            int length() {
                return 3;
            }
        };


        int length() {
            return 1;
        }
    }
}

