/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.bindingeditor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTNodeCreator;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IMethodSpec;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.BindingEditor;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.Messages;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.RadioButtonComposite;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class BindingConfiguration
extends Composite {
    private static final int DESELECT_DISABLE_BUTTONS = 1;
    private static final int SELECT_BUTTONS = 0;
    private static final String OT_GENERATED_INDICATOR = "_OT$";
    private static final String FAKED_METHOD_NAME = String.valueOf('\'') + Messages.BindingConfiguration_new_method_label;
    private static final Object[] EMPTY_LIST = new Object[0];
    private static final String[] NO_STRINGS = new String[0];
    private static final int OT_CALLOUT = 0x1000000;
    private static final int OT_CALLOUT_OVERRIDE = 0x2000000;
    private IMethod[] _roleMethods;
    private IMember[] _baseMethods;
    private IMethod _fakedMeth;
    final TableViewer _roleMethListViewer;
    final TableViewer _baseMethListViewer;
    final RadioButtonComposite _methMapBtnComp;
    private Button _calloutBtn;
    private Button _calloutOverrideBtn;
    private Button _callinBeforeBtn;
    private Button _callinReplaceBtn;
    private Button _callinAfterBtn;
    private RoleTypeDeclaration _selectedRole;
    private CalloutMappingDeclaration _selectedCalloutDecl;
    private CalloutMappingDeclaration[] _calloutMappings;
    private CallinMappingDeclaration _selectedCallinDecl;
    private CallinMappingDeclaration _callinMapping;
    private BindingEditor _bindingEditor;
    private Button _applyBtn;
    private boolean _newCallout;
    private List _parameterMappings;
    private IType _curTeam;

    public BindingConfiguration(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this._bindingEditor = (BindingEditor)parent.getParent();
        JavaUILabelProvider labelProvider = new JavaUILabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IMethod) {
                    if (((IMethod)element).getElementName().equals(FAKED_METHOD_NAME)) {
                        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif");
                    }
                    if (!((IMethod)element).exists()) {
                        return OTDTUIPlugin.getDefault().getImageRegistry().get("calloutbinding_obj.gif");
                    }
                }
                return super.getImage(element);
            }
        };
        labelProvider.addLabelDecorator((ILabelDecorator)new TreeHierarchyLayoutProblemsDecorator());
        labelProvider.setTextFlags(35L);
        Composite composite = new Composite((Composite)this, 0);
        FormData formData_10 = new FormData();
        formData_10.bottom = new FormAttachment(100, -5);
        formData_10.right = new FormAttachment(100, -5);
        formData_10.top = new FormAttachment(100, -50);
        formData_10.left = new FormAttachment(0, 5);
        composite.setLayoutData((Object)formData_10);
        composite.setLayout((Layout)new FormLayout());
        this._applyBtn = new Button(composite, 0);
        FormData formData_11 = new FormData();
        formData_11.bottom = new FormAttachment(100, -5);
        formData_11.right = new FormAttachment(100, -5);
        this._applyBtn.setLayoutData((Object)formData_11);
        this._applyBtn.setText(Messages.BindingConfiguration_apply_button);
        this._applyBtn.setEnabled(false);
        this.addApplyButtonListener(this._applyBtn);
        this._methMapBtnComp = new RadioButtonComposite(this, 0);
        FormData formData_1 = new FormData();
        formData_1.right = new FormAttachment(60, -5);
        formData_1.bottom = new FormAttachment((Control)composite, 5, 128);
        formData_1.top = new FormAttachment(0, 8);
        formData_1.left = new FormAttachment(40, 5);
        this._methMapBtnComp.setLayoutData(formData_1);
        this._methMapBtnComp.setLayout((Layout)new FormLayout());
        this._calloutBtn = new Button((Composite)this._methMapBtnComp, 2);
        this.addButtonListener(this._calloutBtn);
        FormData formData_3 = new FormData();
        formData_3.right = new FormAttachment(100, -5);
        formData_3.top = new FormAttachment(0, 5);
        formData_3.left = new FormAttachment(0, 5);
        this._calloutBtn.setLayoutData((Object)formData_3);
        this._calloutBtn.setText("->");
        this._calloutOverrideBtn = new Button((Composite)this._methMapBtnComp, 2);
        this.addButtonListener(this._calloutOverrideBtn);
        FormData formData_4 = new FormData();
        formData_4.right = new FormAttachment(100, -5);
        formData_4.top = new FormAttachment((Control)this._calloutBtn, 5, 1024);
        formData_4.left = new FormAttachment(0, 5);
        this._calloutOverrideBtn.setLayoutData((Object)formData_4);
        this._calloutOverrideBtn.setText("=>");
        this._callinBeforeBtn = new Button((Composite)this._methMapBtnComp, 2);
        this.addButtonListener(this._callinBeforeBtn);
        FormData formData_5 = new FormData();
        formData_5.right = new FormAttachment(100, -5);
        formData_5.top = new FormAttachment((Control)this._calloutOverrideBtn, 5, 1024);
        formData_5.left = new FormAttachment(0, 5);
        this._callinBeforeBtn.setLayoutData((Object)formData_5);
        this._callinBeforeBtn.setText("<- before");
        this._callinReplaceBtn = new Button((Composite)this._methMapBtnComp, 2);
        this.addButtonListener(this._callinReplaceBtn);
        FormData formData_6 = new FormData();
        formData_6.right = new FormAttachment(100, -5);
        formData_6.top = new FormAttachment((Control)this._callinBeforeBtn, 5, 1024);
        formData_6.left = new FormAttachment(0, 5);
        this._callinReplaceBtn.setLayoutData((Object)formData_6);
        this._callinReplaceBtn.setText("<- replace");
        this._callinAfterBtn = new Button((Composite)this._methMapBtnComp, 2);
        this.addButtonListener(this._callinAfterBtn);
        FormData formData_7 = new FormData();
        formData_7.right = new FormAttachment(100, -5);
        formData_7.top = new FormAttachment((Control)this._callinReplaceBtn, 5, 1024);
        formData_7.left = new FormAttachment(0, 5);
        this._callinAfterBtn.setLayoutData((Object)formData_7);
        this._callinAfterBtn.setText("<- after");
        Label roleMethLabel = new Label((Composite)this, 0);
        FormData formData = new FormData();
        formData.right = new FormAttachment(0, 210);
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        roleMethLabel.setLayoutData((Object)formData);
        roleMethLabel.setText(Messages.BindingConfiguration_role_methods_label);
        this._roleMethListViewer = new TableViewer((Composite)this, 2816);
        this._roleMethListViewer.setContentProvider((IContentProvider)new RoleMethodContentProvider());
        this._roleMethListViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        Table roleMethList = this._roleMethListViewer.getTable();
        FormData formData_8 = new FormData();
        formData_8.bottom = new FormAttachment((Control)composite, 5, 128);
        formData_8.right = new FormAttachment(40, 0);
        formData_8.top = new FormAttachment((Control)roleMethLabel, 5, 1024);
        formData_8.left = new FormAttachment(0, 5);
        roleMethList.setLayoutData((Object)formData_8);
        this._roleMethListViewer.setSorter(new ViewerSorter());
        this._roleMethListViewer.setInput(new Object());
        this.addRoleListSelectionChangedListener(this._roleMethListViewer);
        Label baseMethLabel = new Label((Composite)this, 0);
        FormData formData_2 = new FormData();
        formData_2.right = new FormAttachment(100, -5);
        formData_2.top = new FormAttachment(0, 5);
        formData_2.left = new FormAttachment((Control)this._methMapBtnComp, 5, 131072);
        baseMethLabel.setLayoutData((Object)formData_2);
        baseMethLabel.setText(Messages.BindingConfiguration_base_methods_label);
        this._baseMethListViewer = new TableViewer((Composite)this, 2818);
        this._baseMethListViewer.setContentProvider((IContentProvider)new BaseMethodContentProvider());
        this._baseMethListViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        Table baseMethList = this._baseMethListViewer.getTable();
        FormData formData_12 = new FormData();
        formData_12.bottom = new FormAttachment((Control)composite, 5, 128);
        formData_12.right = new FormAttachment(100, -5);
        formData_12.top = new FormAttachment((Control)baseMethLabel, 5, 1024);
        formData_12.left = new FormAttachment(60, 0);
        baseMethList.setLayoutData((Object)formData_12);
        this._baseMethListViewer.setSorter(new ViewerSorter());
        this._baseMethListViewer.setInput(new Object());
        this.addBaseListSelectionChangedListener(this._baseMethListViewer);
    }

    private void addRoleListSelectionChangedListener(TableViewer tableViewer) {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (BindingConfiguration.this.validateSelections()) {
                    BindingConfiguration.this._methMapBtnComp.enableAll();
                }
                BindingConfiguration.this.toggleApplyButton();
            }
        };
        tableViewer.addSelectionChangedListener(listener);
    }

    private void addBaseListSelectionChangedListener(final TableViewer tableViewer) {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!BindingConfiguration.this.validateSelections()) {
                    return;
                }
                BindingConfiguration.this._methMapBtnComp.enableAll();
                if (!tableViewer.getSelection().isEmpty() && tableViewer.getTable().getSelection().length > 1) {
                    BindingConfiguration.this.toggleModifierButtons(0x3000000, 1);
                    BindingConfiguration.this._methMapBtnComp.removeSelectionButton(BindingConfiguration.this._calloutBtn);
                    BindingConfiguration.this._methMapBtnComp.removeSelectionButton(BindingConfiguration.this._calloutOverrideBtn);
                }
                BindingConfiguration.this.toggleApplyButton();
            }
        };
        tableViewer.addSelectionChangedListener(listener);
    }

    private boolean validateSelections() {
        IMethod roleMethod;
        block10: {
            block9: {
                StructuredSelection selectedBaseIMembers = (StructuredSelection)this._baseMethListViewer.getSelection();
                for (IMember baseIMember : selectedBaseIMembers) {
                    try {
                        if (!Flags.isAbstract((int)baseIMember.getFlags())) continue;
                        this._methMapBtnComp.deselectAll();
                        this._methMapBtnComp.disableAll();
                        this.toggleApplyButton();
                        return false;
                    }
                    catch (JavaModelException ex) {
                        return false;
                    }
                }
                StructuredSelection selectedRoleIMethod = (StructuredSelection)this._roleMethListViewer.getSelection();
                if (selectedRoleIMethod.isEmpty()) {
                    return true;
                }
                roleMethod = (IMethod)selectedRoleIMethod.getFirstElement();
                try {
                    if (!roleMethod.getElementName().equals(FAKED_METHOD_NAME)) break block9;
                    this.toggleModifierButtons(0x2062000, 1);
                    this.toggleApplyButton();
                    return false;
                }
                catch (JavaModelException ex) {
                    return false;
                }
            }
            if (roleMethod.getElementName().equals(FAKED_METHOD_NAME) || Flags.isCallin((int)roleMethod.getFlags()) || Flags.isAbstract((int)roleMethod.getFlags())) break block10;
            this.toggleModifierButtons(0x1002000, 1);
            this.toggleApplyButton();
            return false;
        }
        if (!roleMethod.getElementName().equals(FAKED_METHOD_NAME) && Flags.isCallin((int)roleMethod.getFlags()) && !Flags.isAbstract((int)roleMethod.getFlags())) {
            this.toggleModifierButtons(0x3060000, 1);
            this.toggleApplyButton();
            return false;
        }
        return true;
    }

    protected void checkSubclass() {
    }

    public IMember[] getBaseMethods(IType baseClass) throws JavaModelException {
        IOTType otType;
        ArrayList<Object> result = new ArrayList<Object>();
        IType[] typeParents = TypeHelper.getSuperTypes((IType)baseClass);
        if (OTModelManager.hasOTElementFor((IType)baseClass) && (otType = OTModelManager.getOTElement((IType)baseClass)).isRole()) {
            IType[] implicitSupers = TypeHelper.getImplicitSuperTypes((IRoleType)((IRoleType)otType));
            int len1 = implicitSupers.length;
            int len2 = typeParents.length;
            IType[] iTypeArray = typeParents;
            typeParents = new IType[len1 + len2 - 1];
            System.arraycopy(iTypeArray, 0, typeParents, len1 - 1, len2);
            System.arraycopy(implicitSupers, 0, typeParents, 0, len1);
        }
        HashSet<String> signatures = new HashSet<String>();
        int i = 0;
        while (i < typeParents.length) {
            if (!typeParents[i].getFullyQualifiedName().equals("java.lang.Object")) {
                IField[] fields = typeParents[i].getFields();
                int fieldIdx = 0;
                while (fieldIdx < fields.length) {
                    IField field = fields[fieldIdx];
                    String signature = String.valueOf(field.getElementName()) + field.getTypeSignature();
                    if (!signatures.contains(signature)) {
                        result.add(field);
                        signatures.add(signature);
                    }
                    ++fieldIdx;
                }
                IMethod[] methods = typeParents[i].getMethods();
                int methIdx = 0;
                while (methIdx < methods.length) {
                    IMethod method = methods[methIdx];
                    String signature = String.valueOf(method.getElementName()) + method.getSignature();
                    if (!method.isConstructor() && !signatures.contains(signature)) {
                        result.add(method);
                        signatures.add(signature);
                    }
                    ++methIdx;
                }
                IOTType otType2 = OTModelManager.getOTElement((IType)typeParents[i]);
                if (otType2 != null && otType2.isRole()) {
                    IMethodMapping[] mappings = ((IRoleType)otType2).getMethodMappings(2);
                    int j = 0;
                    while (j < mappings.length) {
                        IMethodSpec method = mappings[j].getRoleMethodHandle();
                        String signature = String.valueOf(method.getSelector()) + method.getSignature();
                        if (!signatures.contains(signature)) {
                            result.add(SourceMethod.createHandle((JavaElement)((JavaElement)typeParents[i]), (IMethodSpec)method));
                            signatures.add(signature);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    public void setFocusRole(RoleTypeDeclaration focusRole, IType teamType, boolean initial) {
        if (initial) {
            this._selectedCallinDecl = null;
            this._selectedCalloutDecl = null;
            this._parameterMappings = null;
        }
        this._selectedRole = focusRole;
        IJavaProject project = teamType.getCompilationUnit().getJavaProject();
        IType teamClass = null;
        try {
            teamClass = project.findType(teamType.getFullyQualifiedName('.'));
            this._roleMethods = TypeHelper.getAllRoleMethods((IType)teamClass, (String)focusRole.getName().toString());
        }
        catch (JavaModelException ex) {
            this.openErrorDialog(Messages.BindingConfiguration_error_retrieving_role_methods);
        }
        Type baseType = focusRole.getBaseClassType();
        if (baseType != null) {
            try {
                String qualifiedBaseName = null;
                if (baseType instanceof SimpleType) {
                    Name baseName = ((SimpleType)baseType).getName();
                    String string = qualifiedBaseName = baseName instanceof QualifiedName ? baseName.getFullyQualifiedName() : this._bindingEditor._baseClassLookup.get(((SimpleName)baseName).getIdentifier());
                }
                if (qualifiedBaseName == null) {
                    qualifiedBaseName = focusRole.resolveBinding().getBaseClass().getQualifiedName();
                }
                if (qualifiedBaseName != null) {
                    this._baseMethods = this.getBaseMethods(project.findType(qualifiedBaseName));
                } else {
                    OTDTUIPlugin.logException("Failed to resolve focus role - no methods available.", null);
                }
            }
            catch (JavaModelException ex) {
                OTDTUIPlugin.logException(ex.getMessage(), ex);
            }
        }
        this._roleMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
        this._baseMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
        this._roleMethListViewer.refresh();
        this._baseMethListViewer.refresh();
        this._methMapBtnComp.enableAll();
        this._methMapBtnComp.deselectAll();
        this.toggleApplyButton();
    }

    IType findRoleType(IType teamClass, String roleName) throws JavaModelException {
        IType roleType;
        IType[] roles;
        IType[] iTypeArray = roles = teamClass.getTypes();
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            roleType = iTypeArray[n2];
            if (roleType.getElementName().equals(roleName)) {
                return roleType;
            }
            ++n2;
        }
        iTypeArray = roles;
        n = roles.length;
        n2 = 0;
        while (n2 < n) {
            roleType = iTypeArray[n2];
            IType result = this.findRoleType(roleType, roleName);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private void toggleApplyButton() {
        if (this._baseMethListViewer.getSelection().isEmpty() || this._roleMethListViewer.getSelection().isEmpty() || this._methMapBtnComp.getSelectedButton() == null) {
            this._applyBtn.setEnabled(false);
        } else {
            this._applyBtn.setEnabled(true);
        }
    }

    public void setCalloutMapping(ASTNode selectedNode, IType teamType) {
        if (!(selectedNode instanceof CalloutMappingDeclaration)) {
            return;
        }
        this._selectedCallinDecl = null;
        this._selectedCalloutDecl = (CalloutMappingDeclaration)selectedNode;
        RoleTypeDeclaration roleTypeDecl = (RoleTypeDeclaration)this._selectedCalloutDecl.getParent();
        this.setFocusRole(roleTypeDecl, teamType, false);
        MethodSpec roleMethSpec = (MethodSpec)this._selectedCalloutDecl.getRoleMappingElement();
        IMember roleMeth = this.findCorrespondingIMember((MethodMappingElement)roleMethSpec, (IMember[])this._roleMethods, null);
        if (roleMeth != null) {
            this._roleMethListViewer.setSelection((ISelection)new StructuredSelection((Object)roleMeth));
        } else {
            this._roleMethListViewer.setSelection((ISelection)new StructuredSelection((Object)this._fakedMeth));
        }
        MethodMappingElement baseSpec = this._selectedCalloutDecl.getBaseMappingElement();
        ArrayList<MethodMappingElement> baseSpecs = new ArrayList<MethodMappingElement>();
        baseSpecs.add(baseSpec);
        List<IMember> curBaseMeths = this.findCorrespondingIMembers(baseSpecs, this._baseMethods);
        if (curBaseMeths != null) {
            this._baseMethListViewer.setSelection((ISelection)new StructuredSelection(curBaseMeths));
        } else {
            this._baseMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
        }
        this._parameterMappings = this._selectedCalloutDecl.getParameterMappings();
        if (this._selectedCalloutDecl.isCalloutOverride()) {
            this._methMapBtnComp.setSelectionButton(this._calloutOverrideBtn);
        } else {
            this._methMapBtnComp.setSelectionButton(this._calloutBtn);
        }
        this.toggleApplyButton();
    }

    public void setCallinMapping(ASTNode selectedNode, IType teamType) {
        if (!(selectedNode instanceof CallinMappingDeclaration)) {
            return;
        }
        this._selectedCalloutDecl = null;
        this._selectedCallinDecl = (CallinMappingDeclaration)selectedNode;
        RoleTypeDeclaration roleTypeDecl = (RoleTypeDeclaration)this._selectedCallinDecl.getParent();
        this.setFocusRole(roleTypeDecl, teamType, false);
        MethodSpec roleMethSpec = (MethodSpec)this._selectedCallinDecl.getRoleMappingElement();
        IMember roleMeth = this.findCorrespondingIMember((MethodMappingElement)roleMethSpec, (IMember[])this._roleMethods, null);
        if (roleMeth != null) {
            this._roleMethListViewer.setSelection((ISelection)new StructuredSelection((Object)roleMeth));
        } else {
            this._roleMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
        }
        List baseMapElems = this._selectedCallinDecl.getBaseMappingElements();
        if (baseMapElems.size() == 0) {
            return;
        }
        List<IMember> baseMembs = this.findCorrespondingIMembers(baseMapElems, this._baseMethods);
        if (baseMembs != null) {
            this._baseMethListViewer.setSelection((ISelection)new StructuredSelection(baseMembs));
        } else {
            this._baseMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
        }
        this._parameterMappings = this._selectedCallinDecl.getParameterMappings();
        this.toggleModifierButtons(this._selectedCallinDecl.getCallinModifier(), 0);
        this.toggleApplyButton();
    }

    private List<IMember> findCorrespondingIMembers(List<MethodMappingElement> methodSpecs, IMember[] members) {
        Hashtable<String, Integer> methodAppearances = this.getMethodAppearances(members);
        ArrayList<IMember> baseMembers = new ArrayList<IMember>();
        for (MethodMappingElement methodSpec : methodSpecs) {
            IMember foundMethod = this.findCorrespondingIMember(methodSpec, members, methodAppearances);
            baseMembers.add(foundMethod);
        }
        return baseMembers;
    }

    private IMember findCorrespondingIMember(MethodMappingElement methodSpec, IMember[] methods, Hashtable<String, Integer> methodAppearances) {
        if (methodAppearances == null) {
            methodAppearances = this.getMethodAppearances(methods);
        }
        String methodName = methodSpec.getName().toString();
        int idx = 0;
        while (idx < methods.length) {
            if (methodName.equals(methods[idx].getElementName())) {
                Integer value = methodAppearances.get(methodName);
                if (value > 1) {
                    if (methodSpec instanceof MethodSpec && methods[idx] instanceof IMethod) {
                        List parameters = ((MethodSpec)methodSpec).parameters();
                        String[] parameterTypes = ((IMethod)methods[idx]).getParameterTypes();
                        if (parameters.size() == parameterTypes.length && this.validateParameterMatching(parameters, parameterTypes)) {
                            return methods[idx];
                        }
                    }
                } else {
                    return methods[idx];
                }
            }
            ++idx;
        }
        return null;
    }

    private boolean validateParameterMatching(List parameters, String[] parameterTypes) {
        boolean totallyMatch = true;
        int counter = 0;
        for (SingleVariableDeclaration variable : parameters) {
            String paramTypeNameFromIMethod;
            String simpleTypeName;
            String paramTypeNameFromMethodSpec = null;
            if (variable.getType().isPrimitiveType()) {
                paramTypeNameFromMethodSpec = ((PrimitiveType)variable.getType()).getPrimitiveTypeCode().toString();
            }
            if (variable.getType().isSimpleType()) {
                ITypeBinding typeBinding = ((SimpleType)variable.getType()).resolveBinding();
                paramTypeNameFromMethodSpec = typeBinding == null ? ((SimpleType)variable.getType()).getName().getFullyQualifiedName() : typeBinding.getQualifiedName();
            }
            if (variable.getType().isArrayType()) {
                Type arrayType = ((ArrayType)variable.getType()).getElementType();
                if (arrayType.isPrimitiveType()) {
                    paramTypeNameFromMethodSpec = ((PrimitiveType)arrayType).getPrimitiveTypeCode().toString();
                }
                if (arrayType.isSimpleType()) {
                    ITypeBinding typeBinding = ((SimpleType)arrayType).resolveBinding();
                    paramTypeNameFromMethodSpec = typeBinding == null ? ((SimpleType)arrayType).getName().getFullyQualifiedName() : typeBinding.getQualifiedName();
                }
                int dimensions = ((ArrayType)variable.getType()).getDimensions();
                int i = 0;
                while (i < dimensions) {
                    paramTypeNameFromMethodSpec = String.valueOf(paramTypeNameFromMethodSpec) + "[]";
                    ++i;
                }
            }
            if (!(simpleTypeName = this.getSimpleParameterName(paramTypeNameFromIMethod = Signature.toString((String)parameterTypes[counter]))).equals(paramTypeNameFromMethodSpec)) {
                totallyMatch = false;
            }
            ++counter;
        }
        return totallyMatch;
    }

    private String getSimpleParameterName(String parameterName) {
        String[] simpleNameArray = parameterName.split("\\.");
        if (simpleNameArray.length == 0) {
            return parameterName;
        }
        return simpleNameArray[simpleNameArray.length - 1];
    }

    private Hashtable<String, Integer> getMethodAppearances(IMember[] methods) {
        Hashtable<String, Integer> appearances = new Hashtable<String, Integer>();
        int idx = 0;
        while (idx < methods.length) {
            String methodName = methods[idx].getElementName();
            if (appearances.containsKey(methodName)) {
                Integer value = appearances.get(methodName);
                int app = value;
                appearances.put(methodName, new Integer(++app));
            } else {
                appearances.put(methodName, new Integer(1));
            }
            ++idx;
        }
        return appearances;
    }

    private void toggleModifierButtons(int modifiers, int selectionLevel) {
        List<Button> buttonList = this.getButtonsForModifiers(modifiers);
        switch (selectionLevel) {
            case 0: {
                for (Button button : buttonList) {
                    this._methMapBtnComp.setSelectionButton(button);
                }
                break;
            }
            case 1: {
                if (Modifier.isReplace((int)modifiers)) {
                    this._callinReplaceBtn.setEnabled(false);
                    this._methMapBtnComp.removeSelectionButton(this._callinReplaceBtn);
                } else {
                    this._callinReplaceBtn.setEnabled(true);
                }
                if (Modifier.isBefore((int)modifiers)) {
                    this._callinBeforeBtn.setEnabled(false);
                    this._methMapBtnComp.removeSelectionButton(this._callinBeforeBtn);
                } else {
                    this._callinBeforeBtn.setEnabled(true);
                }
                if (Modifier.isAfter((int)modifiers)) {
                    this._callinAfterBtn.setEnabled(false);
                    this._methMapBtnComp.removeSelectionButton(this._callinAfterBtn);
                } else {
                    this._callinAfterBtn.setEnabled(true);
                }
                if (this.isCallout(modifiers)) {
                    this._calloutBtn.setEnabled(false);
                    this._methMapBtnComp.removeSelectionButton(this._calloutBtn);
                } else {
                    this._calloutBtn.setEnabled(true);
                }
                if (this.isCalloutOverride(modifiers)) {
                    this._calloutOverrideBtn.setEnabled(false);
                    this._methMapBtnComp.removeSelectionButton(this._calloutOverrideBtn);
                    break;
                }
                this._calloutOverrideBtn.setEnabled(true);
                break;
            }
        }
    }

    private List<Button> getButtonsForModifiers(int modifiers) {
        ArrayList<Button> buttonList = new ArrayList<Button>();
        if (Modifier.isReplace((int)modifiers)) {
            buttonList.add(this._callinReplaceBtn);
        }
        if (Modifier.isBefore((int)modifiers)) {
            buttonList.add(this._callinBeforeBtn);
        }
        if (Modifier.isAfter((int)modifiers)) {
            buttonList.add(this._callinAfterBtn);
        }
        if (this.isCallout(modifiers)) {
            buttonList.add(this._calloutBtn);
        }
        if (this.isCalloutOverride(modifiers)) {
            buttonList.add(this._calloutBtn);
        }
        return buttonList;
    }

    private boolean isCalloutOverride(int modifiers) {
        return (modifiers & 0x2000000) != 0;
    }

    private boolean isCallout(int modifiers) {
        return (modifiers & 0x1000000) != 0;
    }

    private void addButtonListener(Button button) {
        SelectionListener buttonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                Button selectedButton = (Button)evt.getSource();
                BindingConfiguration.this._methMapBtnComp.doRadioButtonBehavior(selectedButton);
                BindingConfiguration.this.toggleApplyButton();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
            }
        };
        button.addSelectionListener(buttonListener);
    }

    private void addApplyButtonListener(Button applyButton) {
        SelectionAdapter applyButtonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BindingConfiguration.this.applyPressed();
            }
        };
        applyButton.addSelectionListener((SelectionListener)applyButtonListener);
    }

    private boolean createMethodMapping() {
        StructuredSelection selectedRoleMethod;
        int methMapModifier = 0;
        boolean calloutOverride = false;
        boolean signatureFlag = true;
        this._newCallout = true;
        Button selectedButton = this._methMapBtnComp.getSelectedButton();
        if (this._calloutBtn.equals(selectedButton)) {
            methMapModifier = 0;
            this._newCallout = true;
        }
        if (this._calloutOverrideBtn.equals(selectedButton)) {
            calloutOverride = true;
            methMapModifier = 0;
            this._newCallout = true;
        }
        if (this._callinReplaceBtn.equals(selectedButton)) {
            methMapModifier = 8192;
            this._newCallout = false;
        }
        if (this._callinBeforeBtn.equals(selectedButton)) {
            methMapModifier = 131072;
            this._newCallout = false;
        }
        if (this._callinAfterBtn.equals(selectedButton)) {
            methMapModifier = 262144;
            this._newCallout = false;
        }
        if ((selectedRoleMethod = (StructuredSelection)this._roleMethListViewer.getSelection()).isEmpty()) {
            return false;
        }
        StructuredSelection selectedBaseMethods = (StructuredSelection)this._baseMethListViewer.getSelection();
        if (selectedBaseMethods.isEmpty()) {
            return false;
        }
        IMethod roleMethod = (IMethod)selectedRoleMethod.getFirstElement();
        IMember[] baseMethods = new IMember[selectedBaseMethods.size()];
        int baseMethodsCount = 0;
        for (IMember baseMethod : selectedBaseMethods) {
            baseMethods[baseMethodsCount++] = baseMethod;
        }
        AST ast = this._selectedRole.getAST();
        if (this._newCallout) {
            if (baseMethods[0] instanceof IField) {
                this._calloutMappings = new CalloutMappingDeclaration[]{this.createCalloutMapping(ast, roleMethod, baseMethods[0], 524288, calloutOverride, signatureFlag), this.createCalloutMapping(ast, roleMethod, baseMethods[0], 0x100000, calloutOverride, signatureFlag)};
                return this._calloutMappings[0] != null && this._calloutMappings[1] != null;
            }
            this._calloutMappings = new CalloutMappingDeclaration[]{this.createCalloutMapping(ast, roleMethod, baseMethods[0], methMapModifier, calloutOverride, signatureFlag)};
            return this._calloutMappings[0] != null;
        }
        return this.createCallinMapping(ast, roleMethod, baseMethods, methMapModifier, signatureFlag);
    }

    private boolean createCallinMapping(AST ast, IMethod roleIMethod, IMember[] baseMethods, int modifier, boolean signatureFlag) {
        MethodSpec roleMethodSpec;
        IMethod templateForRoleMethodSpec;
        IMember[] iMemberArray = baseMethods;
        int n = baseMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (!(member instanceof IMethod)) {
                return false;
            }
            ++n2;
        }
        MethodSpec givenRoleMSpec = null;
        List givenBaseMSpecs = null;
        if (this._selectedCallinDecl != null) {
            givenRoleMSpec = (MethodSpec)this._selectedCallinDecl.getRoleMappingElement();
            givenBaseMSpecs = this._selectedCallinDecl.getBaseMappingElements();
        }
        if ((templateForRoleMethodSpec = roleIMethod).getElementName().startsWith(FAKED_METHOD_NAME)) {
            templateForRoleMethodSpec = (IMethod)baseMethods[0];
        }
        if ((roleMethodSpec = this.createMethodSpec(ast, templateForRoleMethodSpec, givenRoleMSpec, signatureFlag)) == null) {
            return false;
        }
        ArrayList<MethodSpec> baseMethodSpecs = new ArrayList<MethodSpec>();
        int idx = 0;
        while (idx < baseMethods.length) {
            MethodSpec baseMethodSpec;
            IMethod baseIMethod = (IMethod)baseMethods[idx];
            MethodSpec baseMSpec = null;
            if (givenBaseMSpecs != null && baseMethods.length == 1) {
                baseMSpec = (MethodSpec)givenBaseMSpecs.get(idx);
            }
            if ((baseMethodSpec = this.createMethodSpec(ast, baseIMethod, baseMSpec, signatureFlag)) != null) {
                baseMethodSpecs.add(baseMethodSpec);
            }
            ++idx;
        }
        if (this._selectedCallinDecl == null) {
            this._parameterMappings = null;
        }
        this._callinMapping = ASTNodeCreator.createCallinMappingDeclaration((AST)ast, null, (int)modifier, (MethodSpec)roleMethodSpec, baseMethodSpecs, (List)this._parameterMappings);
        return true;
    }

    private CalloutMappingDeclaration createCalloutMapping(AST ast, IMethod roleMethod, IMember baseMember, int bindingModifier, boolean calloutOverride, boolean signatureFlag) {
        MethodSpec selRolMethSpec = null;
        MethodMappingElement selBasMethSpec = null;
        if (this._selectedCalloutDecl != null) {
            selRolMethSpec = (MethodSpec)this._selectedCalloutDecl.getRoleMappingElement();
            selBasMethSpec = this._selectedCalloutDecl.getBaseMappingElement();
            if (baseMember instanceof IMethod && !(selBasMethSpec instanceof MethodSpec)) {
                return null;
            }
            if (baseMember instanceof IField && !(selBasMethSpec instanceof FieldAccessSpec)) {
                return null;
            }
        }
        MethodSpec baseMethodSpec = null;
        if (baseMember instanceof IMethod) {
            baseMethodSpec = this.createMethodSpec(ast, (IMethod)baseMember, (MethodSpec)selBasMethSpec, signatureFlag);
        } else {
            try {
                IField iField = (IField)baseMember;
                baseMethodSpec = ASTNodeCreator.createFieldAccSpec((AST)ast, (bindingModifier == 524288 ? 1 : 0) != 0, (String)iField.getElementName(), (String)Signature.toString((String)iField.getTypeSignature()), (boolean)signatureFlag);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (baseMethodSpec == null) {
            return null;
        }
        MethodSpec roleMethodSpec = null;
        if (roleMethod.getElementName().startsWith(FAKED_METHOD_NAME)) {
            if (baseMember instanceof IMethod) {
                roleMethodSpec = this.createMethodSpec(ast, (IMethod)baseMember, null, signatureFlag);
            } else {
                try {
                    IField baseField = (IField)baseMember;
                    String name = baseMember.getElementName();
                    name = name.length() == 1 ? name.toUpperCase() : String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
                    if (bindingModifier == 524288) {
                        roleMethodSpec = this.createMethodSpec(ast, baseField.getTypeSignature(), "get" + name, NO_STRINGS, NO_STRINGS, null, signatureFlag);
                    }
                    roleMethodSpec = this.createMethodSpec(ast, "V", "set" + name, new String[]{baseField.getTypeSignature()}, new String[]{baseMember.getElementName()}, null, signatureFlag);
                }
                catch (JavaModelException e) {
                    return null;
                }
            }
        } else {
            roleMethodSpec = this.createMethodSpec(ast, roleMethod, selRolMethSpec, signatureFlag);
        }
        if (roleMethodSpec == null) {
            return null;
        }
        if (this._selectedCalloutDecl == null) {
            this._parameterMappings = null;
        }
        return ASTNodeCreator.createCalloutMappingDeclaration((AST)ast, null, (int)0, (MethodMappingElement)roleMethodSpec, (MethodMappingElement)baseMethodSpec, (int)bindingModifier, (List)this._parameterMappings, (boolean)calloutOverride, (boolean)signatureFlag);
    }

    private MethodSpec createMethodSpec(AST ast, IMethod baseMember, MethodSpec givenMethodSpec, boolean signatureFlag) {
        try {
            return this.createMethodSpec(ast, baseMember.getReturnType(), baseMember.getElementName(), baseMember.getParameterTypes(), baseMember.getParameterNames(), givenMethodSpec, signatureFlag);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    private MethodSpec createMethodSpec(AST ast, String typeSignature, String name, String[] parameterTypes, String[] parameterNames, MethodSpec givenMethodSpec, boolean signatureFlag) {
        String returnTypeString = Signature.toString((String)typeSignature);
        Type returnType = ASTNodeCreator.createType((AST)ast, (String)returnTypeString);
        List mSpecParameters = null;
        if (givenMethodSpec != null) {
            mSpecParameters = givenMethodSpec.parameters();
        }
        ArrayList<SingleVariableDeclaration> methodParameters = new ArrayList<SingleVariableDeclaration>();
        int idx = 0;
        while (idx < parameterTypes.length) {
            SingleVariableDeclaration roleParameter;
            Type parameterType = ASTNodeCreator.createType((AST)ast, (String)Signature.getSimpleName((String)Signature.toString((String)parameterTypes[idx])));
            if (mSpecParameters != null && mSpecParameters.size() == parameterNames.length) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)mSpecParameters.get(idx);
                roleParameter = ASTNodeCreator.createArgument((AST)ast, (int)0, (Type)parameterType, (String)param.getName().toString(), null);
            } else {
                roleParameter = ASTNodeCreator.createArgument((AST)ast, (int)0, (Type)parameterType, (String)parameterNames[idx], null);
            }
            methodParameters.add(roleParameter);
            ++idx;
        }
        MethodSpec methodSpec = ASTNodeCreator.createMethodSpec((AST)ast, (String)name, (Type)returnType, methodParameters, (boolean)signatureFlag);
        return methodSpec;
    }

    public static String getMethodSignature(IMethod meth) {
        StringBuffer result = new StringBuffer();
        if (meth != null) {
            result.append(meth.getElementName());
            result.append('(');
            String[] parameterTypes = meth.getParameterTypes();
            int idx = 0;
            while (idx < parameterTypes.length) {
                String curType = parameterTypes[idx];
                result.append(curType);
                if (idx < parameterTypes.length) {
                    result.append(", ");
                }
                ++idx;
            }
            result.append(')');
        }
        return result.toString();
    }

    public void resetLists() {
        this._baseMethListViewer.getTable().removeAll();
        this._roleMethListViewer.getTable().removeAll();
        this._methMapBtnComp.enableAll();
        this._methMapBtnComp.deselectAll();
    }

    public void setCurrentTeamForMethodFake(IType teamType) {
        this._curTeam = teamType;
    }

    private void applyPressed() {
        if (this._selectedRole.isRoleFile()) {
            this.openErrorDialog(NLS.bind((String)Messages.BindingConfiguration_error_cant_edit_rolefile, (Object)this._selectedRole.getName().getIdentifier(), (Object)this._selectedRole.getName().getIdentifier()));
            return;
        }
        RoleTypeDeclaration currentRole = this._selectedRole;
        while ((currentRole = (RoleTypeDeclaration)ASTNodes.getParent((ASTNode)currentRole, (int)121)) != null) {
            if (currentRole.isRoleFile()) {
                if (this._bindingEditor.isRootTeam((TypeDeclaration)currentRole)) break;
                this.openErrorDialog(NLS.bind((String)Messages.BindingConfiguration_error_cant_edit_rolefile_nested, (Object[])new Object[]{this._selectedRole.getName().getIdentifier(), currentRole.getName().getIdentifier(), currentRole.getName().getIdentifier()}));
                return;
            }
            currentRole = (RoleTypeDeclaration)ASTNodes.getParent((ASTNode)this._selectedRole, (int)121);
        }
        this._calloutMappings = null;
        this._callinMapping = null;
        int selectedIndex = -1;
        if (this.createMethodMapping()) {
            if (this._calloutMappings != null) {
                if (this._selectedCalloutDecl != null) {
                    selectedIndex = this._selectedRole.bodyDeclarations().indexOf(this._selectedCalloutDecl);
                    this._selectedRole.bodyDeclarations().remove(this._selectedCalloutDecl);
                }
                if (this._selectedCallinDecl != null) {
                    selectedIndex = this._selectedRole.bodyDeclarations().indexOf(this._selectedCallinDecl);
                    this._selectedRole.bodyDeclarations().remove(this._selectedCallinDecl);
                }
                if (selectedIndex == -1) {
                    this._selectedRole.bodyDeclarations().add(this._calloutMappings[0]);
                    if (this._calloutMappings.length > 1) {
                        this._selectedRole.bodyDeclarations().add(this._calloutMappings[1]);
                    }
                } else {
                    this._selectedRole.bodyDeclarations().add(selectedIndex, this._calloutMappings[0]);
                    if (this._calloutMappings.length > 1) {
                        this._selectedRole.bodyDeclarations().add(selectedIndex, this._calloutMappings[1]);
                    }
                }
            }
            if (this._callinMapping != null) {
                if (this._selectedCallinDecl != null) {
                    selectedIndex = this._selectedRole.bodyDeclarations().indexOf(this._selectedCallinDecl);
                    this._selectedRole.bodyDeclarations().remove(this._selectedCallinDecl);
                }
                if (this._selectedCalloutDecl != null) {
                    selectedIndex = this._selectedRole.bodyDeclarations().indexOf(this._selectedCalloutDecl);
                    this._selectedRole.bodyDeclarations().remove(this._selectedCalloutDecl);
                }
                if (selectedIndex == -1) {
                    this._selectedRole.bodyDeclarations().add(this._callinMapping);
                } else {
                    this._selectedRole.bodyDeclarations().add(selectedIndex, this._callinMapping);
                }
            }
            this._roleMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
            this._baseMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
            this._roleMethListViewer.refresh();
            this._baseMethListViewer.refresh();
            this._bindingEditor.refresh();
            if (this._callinMapping != null) {
                this._bindingEditor.methodBindingAdded((AbstractMethodMappingDeclaration)this._callinMapping);
            } else {
                this._bindingEditor.methodBindingAdded((AbstractMethodMappingDeclaration)this._calloutMappings[0]);
                if (this._calloutMappings.length > 1) {
                    this._bindingEditor.methodBindingAdded((AbstractMethodMappingDeclaration)this._calloutMappings[1]);
                }
            }
        } else {
            this.openErrorDialog(Messages.BindingConfiguration_error_binding_creation_failed);
            this._roleMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
            this._baseMethListViewer.setSelection((ISelection)new StructuredSelection(EMPTY_LIST));
            this._roleMethListViewer.refresh();
            this._baseMethListViewer.refresh();
            this._methMapBtnComp.enableAll();
            this._methMapBtnComp.deselectAll();
            this._bindingEditor.refresh();
        }
    }

    private void openErrorDialog(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.BindingConfiguration_error_unspecific, (String)message);
    }

    class BaseMethodContentProvider
    implements IStructuredContentProvider {
        BaseMethodContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return BindingConfiguration.this._baseMethods != null ? this.getFilteredMethods() : EMPTY_LIST;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private Object[] getFilteredMethods() {
            ArrayList<IMember> result = new ArrayList<IMember>();
            int idx = 0;
            while (idx < BindingConfiguration.this._baseMethods.length) {
                IMember curElem = BindingConfiguration.this._baseMethods[idx];
                try {
                    if (!(curElem.getElementName().startsWith(BindingConfiguration.OT_GENERATED_INDICATOR) || curElem.exists() && Flags.isSynthetic((int)curElem.getFlags()))) {
                        result.add(curElem);
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++idx;
            }
            return result.toArray();
        }
    }

    class RoleMethodContentProvider
    implements IStructuredContentProvider {
        RoleMethodContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getFakedMethodList();
        }

        private Object[] getFakedMethodList() {
            if (BindingConfiguration.this._curTeam == null) {
                return EMPTY_LIST;
            }
            BindingConfiguration.this._fakedMeth = BindingConfiguration.this._curTeam.getMethod(FAKED_METHOD_NAME, new String[0]);
            if (BindingConfiguration.this._roleMethods == null) {
                return new IMethod[]{BindingConfiguration.this._fakedMeth};
            }
            ArrayList<IMethod> result = new ArrayList<IMethod>();
            int idx = 0;
            while (idx < BindingConfiguration.this._roleMethods.length) {
                IMethod curElem = BindingConfiguration.this._roleMethods[idx];
                if (!curElem.getElementName().startsWith(BindingConfiguration.OT_GENERATED_INDICATOR)) {
                    result.add(curElem);
                }
                ++idx;
            }
            result.add(BindingConfiguration.this._fakedMeth);
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

