/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.Protections;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class RoleSplitter {
    public static TypeDeclaration createInterfacePart(TypeDeclaration teamDeclaration, TypeDeclaration roleClassDeclaration) {
        TypeDeclaration interfaceDeclaration = AstConverter.genRoleInterface(teamDeclaration, roleClassDeclaration);
        RoleSplitter.renameClass(roleClassDeclaration);
        AstEdit.addMemberTypeDeclaration(teamDeclaration, interfaceDeclaration);
        RoleSplitter.createInterfaceStatements(teamDeclaration, interfaceDeclaration, roleClassDeclaration);
        interfaceDeclaration.baseclass = AstClone.copyTypeReference(roleClassDeclaration.baseclass);
        if ((roleClassDeclaration.bits & 0x100) != 0 && roleClassDeclaration.scope != null) {
            ((BlockScope)roleClassDeclaration.scope.parent).addLocalType(interfaceDeclaration);
        }
        return interfaceDeclaration;
    }

    private static void createInterfaceStatements(TypeDeclaration teamDecl, TypeDeclaration roleIfcDecl, TypeDeclaration roleClassDecl) {
        int i;
        FieldDeclaration[] fields = roleClassDecl.fields;
        AbstractMethodDeclaration[] methods = roleClassDecl.methods;
        if (fields != null) {
            int fieldsLength = fields.length;
            i = 0;
            while (i < fieldsLength) {
                FieldDeclaration field = fields[i];
                if (field.isStatic() && (field.modifiers & 0x10) != 0 && (field.modifiers & 2) == 0) {
                    AstEdit.addField(roleIfcDecl, field, false, false, false);
                    AstEdit.removeField(roleClassDecl, field);
                }
                ++i;
            }
        }
        if (methods != null) {
            int methodsLength = methods.length;
            i = 0;
            while (i < methodsLength) {
                AbstractMethodDeclaration abstractMethod = methods[i];
                if (abstractMethod instanceof MethodDeclaration) {
                    final MethodDeclaration method = (MethodDeclaration)abstractMethod;
                    if ((abstractMethod.modifiers & 2) == 0) {
                        final MethodDeclaration newmethod = AstConverter.genRoleIfcMethod(teamDecl, method);
                        AstEdit.addMethod(roleIfcDecl, newmethod);
                        roleIfcDecl.getRoleModel()._state.addJob(10, new Runnable(){

                            @Override
                            public void run() {
                                if (method.binding != null && (method.binding.modifiers & 0x100000) != 0 && newmethod.binding != null) {
                                    newmethod.binding.modifiers |= 0x100000;
                                    newmethod.binding.tagBits |= 0x400000000000L;
                                }
                            }
                        });
                    }
                }
                ++i;
            }
        }
    }

    public static void transformClassPart(TypeDeclaration teamDeclaration, TypeDeclaration roleClassDeclaration) {
        char[] oldName = CharOperation.subarray(roleClassDeclaration.name, IOTConstants.OT_DELIM_LEN, -1);
        RoleSplitter.renameSuperReference(roleClassDeclaration);
        RoleSplitter.renameConstructors(roleClassDeclaration);
        AstEdit.addImplementsInterfaceReference(oldName, roleClassDeclaration);
        AbstractMethodDeclaration[] methods = roleClassDeclaration.methods;
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                if (!(methods[i].isConstructor() || (methods[i].modifiers & 3) != 0 && (methods[i].modifiers & 0x408) != 1032)) {
                    MethodModel.getModel(methods[i]).storeModifiers(methods[i].modifiers);
                }
                ++i;
            }
        }
    }

    private static void renameClass(TypeDeclaration classTypeDeclaration) {
        classTypeDeclaration.name = CharOperation.concat(IOTConstants.OT_DELIM_NAME, classTypeDeclaration.name);
        if (classTypeDeclaration.binding != null) {
            classTypeDeclaration.binding.sourceName = classTypeDeclaration.name;
        }
    }

    private static void renameConstructors(TypeDeclaration classTypeDeclaration) {
        char[] newname = classTypeDeclaration.name;
        if (classTypeDeclaration.methods != null) {
            int i = 0;
            while (i < classTypeDeclaration.methods.length) {
                AbstractMethodDeclaration method = classTypeDeclaration.methods[i];
                if (method.isConstructor()) {
                    method.selector = newname;
                }
                ++i;
            }
        }
    }

    private static void renameSuperReference(TypeDeclaration classTypeDeclaration) {
        block20: {
            TypeReference reference = classTypeDeclaration.superclass;
            if (reference == null) break block20;
            switch (reference.getClass().getName()) {
                case "org.eclipse.jdt.internal.codeassist.complete.CompletionOnKeyword1": 
                case "org.eclipse.jdt.internal.codeassist.complete.CompletionOnKeyword2": 
                case "org.eclipse.jdt.internal.codeassist.complete.CompletionOnKeyword3": {
                    return;
                }
                case "org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleTypeReference": {
                    return;
                }
                case "org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedTypeReference": {
                    return;
                }
            }
            if (reference instanceof SingleTypeReference) {
                SingleTypeReference singRef = (SingleTypeReference)reference;
                singRef.token = CharOperation.concat(IOTConstants.OT_DELIM_NAME, singRef.token);
            } else if (reference instanceof QualifiedTypeReference) {
                QualifiedTypeReference qualRef = (QualifiedTypeReference)reference;
                int tokenPos = qualRef.tokens.length - 1;
                qualRef.tokens[tokenPos] = CharOperation.concat(IOTConstants.OT_DELIM_NAME, qualRef.tokens[tokenPos]);
            }
        }
    }

    public static void setupInterfaceForExtends(TypeDeclaration teamDecl, TypeDeclaration roleClass, TypeDeclaration roleIfcDecl) {
        ReferenceBinding[] tsupers;
        ReferenceBinding superClass = roleClass.binding.superclass();
        if (superClass == null) {
            return;
        }
        if (superClass.isDirectRole() && !CharOperation.equals(superClass.internalName(), IOTConstants.OTCONFINED)) {
            return;
        }
        ReferenceBinding[] referenceBindingArray = tsupers = roleClass.getRoleModel().getTSuperRoleBindings();
        int n = tsupers.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding tsuperRole = referenceBindingArray[n2];
            if (TypeBinding.equalsEquals(tsuperRole.superclass(), superClass)) {
                return;
            }
            ++n2;
        }
        if (roleIfcDecl == null) {
            return;
        }
        SourceTypeBinding ifcBinding = roleIfcDecl.binding;
        ReferenceBinding javaLangObject = teamDecl.scope.getJavaLangObject();
        AstGenerator gen = roleClass.superclass != null ? new AstGenerator(roleClass.superclass.sourceStart, roleClass.superclass.sourceEnd) : new AstGenerator(roleClass.sourceStart, roleClass.sourceEnd);
        while (superClass != null && TypeBinding.notEquals(superClass, javaLangObject)) {
            MethodBinding[] methods = superClass.methods();
            int i = 0;
            while (i < methods.length) {
                block18: {
                    MethodBinding m = methods[i];
                    if (!(m.isConstructor() || m.isPrivate() || m.isStatic())) {
                        if (!m.isPublic()) {
                            MethodBinding existingMethod = TypeAnalyzer.findMethod(roleIfcDecl.scope, ifcBinding, m.selector, m.parameters);
                            if (existingMethod == null || !existingMethod.isValidBinding()) {
                                ProblemMethodBinding problemMethod = new ProblemMethodBinding(m, m.selector, m.parameters, 2);
                                problemMethod.modifiers = m.modifiers;
                                problemMethod.modifiers |= 0x1000400;
                                problemMethod.thrownExceptions = m.thrownExceptions;
                                problemMethod.returnType = m.returnType;
                                MethodModel.getModel((MethodBinding)problemMethod).problemDetail = MethodModel.ProblemDetail.RoleInheritsNonPublic;
                                ((ReferenceBinding)ifcBinding).addMethod(problemMethod);
                            }
                        } else {
                            int j = 0;
                            while (j < IOTConstants.OT_KEYWORDS.length) {
                                if (CharOperation.equals(m.selector, IOTConstants.OT_KEYWORDS[j])) {
                                    roleClass.scope.problemReporter().inheritedNameIsOTKeyword(m, gen.sourceStart, gen.sourceEnd);
                                    break block18;
                                }
                                ++j;
                            }
                            MethodBinding declaredMethod = TypeAnalyzer.findCompatibleMethod(ifcBinding, m);
                            if (declaredMethod == null) {
                                MethodDeclaration newmethod = AstConverter.genIfcMethodFromBinding(teamDecl, m, gen);
                                boolean wasSynthetic = false;
                                if ((newmethod.modifiers & 0x1000) != 0) {
                                    wasSynthetic = true;
                                    newmethod.modifiers &= 0xFFFFEFFF;
                                }
                                AstEdit.addMethod(roleIfcDecl, newmethod, wasSynthetic, false, null);
                                if (newmethod.binding != null) {
                                    newmethod.binding.tagBits |= 0x200L;
                                    newmethod.binding.copyInheritanceSrc = m;
                                }
                            } else if (!Protections.isAsVisible(declaredMethod.modifiers, m.modifiers)) {
                                roleClass.scope.problemReporter().visibilityConflict(declaredMethod, m);
                            }
                        }
                    }
                }
                ++i;
            }
            superClass = superClass.superclass();
        }
    }

    public static void linkRoles(CompilationUnitDeclaration unit) {
        if (unit.types != null) {
            TypeDeclaration[] typeDeclarationArray = unit.types;
            int n = unit.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                RoleSplitter.linkRoles(type);
                ++n2;
            }
        }
    }

    public static void linkRoles(TypeDeclaration type) {
        if (type.isRole()) {
            RoleModel model = type.getRoleModel();
            RoleSplitter.linkScopes(model);
            RoleSplitter.linkSuperAndBaseInIfc(model);
        }
        if (type.memberTypes != null) {
            TypeDeclaration[] typeDeclarationArray = type.memberTypes;
            int n = type.memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration member = typeDeclarationArray[n2];
                RoleSplitter.linkRoles(member);
                ++n2;
            }
        }
    }

    private static void linkSuperAndBaseInIfc(RoleModel role) {
        ReferenceBinding superClass;
        if (!role.isSourceRole()) {
            return;
        }
        ReferenceBinding binding = role.getBinding();
        if (binding == null || binding.isBinaryBinding()) {
            return;
        }
        ReferenceBinding classPart = role.getClassPartBinding();
        ReferenceBinding ifcPart = role.getInterfacePartBinding();
        if (classPart != null && ifcPart != null) {
            ifcPart.baseclass = classPart.baseclass;
        }
        if (classPart != null && classPart.superclass() != null && (superClass = classPart.superclass()).isDirectRole()) {
            TypeDeclaration interfaceAst = role.getInterfaceAst();
            if (interfaceAst != null) {
                ifcPart = interfaceAst.binding;
                ReferenceBinding superIfc = superClass.enclosingType().getMemberType(superClass.sourceName());
                superIfc = superClass.transferTypeArguments(superIfc);
                if (!CharOperation.equals(ifcPart.internalName(), IOTConstants.CONFINED) && CharOperation.equals(superIfc.internalName(), IOTConstants.CONFINED)) {
                    superIfc = ifcPart.enclosingType().getMemberType(IOTConstants.CONFINED);
                }
                AstEdit.addImplementsBinding(interfaceAst, superIfc);
            } else {
                System.out.println("Binary interface part of source role: " + role);
            }
        }
    }

    private static void linkScopes(RoleModel model) {
        if (model._classPart != null && model._interfacePart != null) {
            if (TypeModel.isIgnoreFurtherInvestigation(model._interfacePart)) {
                model._classPart.tagAsHavingErrors();
            } else {
                model._interfacePart.scope.parent = model._classPart.scope;
            }
        }
    }

    public static boolean isClassPartName(char[] typeName) {
        return CharOperation.prefixEquals(IOTConstants.OT_DELIM_NAME, typeName);
    }

    public static char[] getInterfacePartName(char[] classPartName) {
        return CharOperation.subarray(classPartName, IOTConstants.OT_DELIM_LEN, -1);
    }
}

