/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IRecordComponent;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.AnnotationInfo;
import org.eclipse.jdt.internal.core.BinaryField;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.MappingElementInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CallinMethodMappingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CalloutMappingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.util.FieldData;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

class ClassFileInfo
extends OpenableElementInfo
implements SuffixConstants {
    protected JavaElement[] binaryChildren = null;
    protected ITypeParameter[] typeParameters;

    ClassFileInfo() {
    }

    private void generateAnnotationsInfos(JavaElement member, IBinaryAnnotation[] binaryAnnotations, long tagBits, HashMap newElements) {
        this.generateAnnotationsInfos(member, null, binaryAnnotations, tagBits, newElements);
    }

    private void generateAnnotationsInfos(JavaElement member, char[] parameterName, IBinaryAnnotation[] binaryAnnotations, long tagBits, HashMap newElements) {
        if (binaryAnnotations != null) {
            int i = 0;
            int length = binaryAnnotations.length;
            while (i < length) {
                IBinaryAnnotation annotationInfo = binaryAnnotations[i];
                this.generateAnnotationInfo(member, parameterName, newElements, annotationInfo, null);
                ++i;
            }
        }
        this.generateStandardAnnotationsInfos(member, parameterName, tagBits, newElements);
    }

    private void generateAnnotationInfo(JavaElement parent, HashMap newElements, IBinaryAnnotation annotationInfo, String memberValuePairName) {
        this.generateAnnotationInfo(parent, null, newElements, annotationInfo, memberValuePairName);
    }

    private void generateAnnotationInfo(JavaElement parent, char[] parameterName, HashMap newElements, IBinaryAnnotation annotationInfo, String memberValuePairName) {
        char[] typeName = Signature.toCharArray(CharOperation.replaceOnCopy((char[])annotationInfo.getTypeName(), (char)'/', (char)'.'));
        Annotation annotation = new Annotation(parent, new String(typeName), memberValuePairName);
        while (newElements.containsKey(annotation)) {
            annotation.occurrenceCount = annotation.occurrenceCount + 1;
        }
        newElements.put(annotation, annotationInfo);
        IBinaryElementValuePair[] pairs = annotationInfo.getElementValuePairs();
        int i = 0;
        int length = pairs.length;
        while (i < length) {
            Object value = pairs[i].getValue();
            if (value instanceof IBinaryAnnotation) {
                this.generateAnnotationInfo(annotation, newElements, (IBinaryAnnotation)value, new String(pairs[i].getName()));
            } else if (value instanceof Object[]) {
                Object[] valueArray = (Object[])value;
                int j = 0;
                int valueArrayLength = valueArray.length;
                while (j < valueArrayLength) {
                    Object nestedValue = valueArray[j];
                    if (nestedValue instanceof IBinaryAnnotation) {
                        this.generateAnnotationInfo(annotation, newElements, (IBinaryAnnotation)nestedValue, new String(pairs[i].getName()));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void generateStandardAnnotationsInfos(JavaElement javaElement, char[] parameterName, long tagBits, HashMap newElements) {
        if ((tagBits & 0xF7FFFFF840000000L) == 0L) {
            return;
        }
        if ((tagBits & 0x300000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION, this.getRetentionPolicy(tagBits), newElements);
        }
        if ((tagBits & 0x400000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_DEPRECATED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x800000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x1000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x10000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x8000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_SAFEVARARGS, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
    }

    private void generateStandardAnnotation(JavaElement javaElement, char[][] typeName, IMemberValuePair[] members, HashMap newElements) {
        Annotation annotation = new Annotation(javaElement, new String(CharOperation.concatWith((char[][])typeName, (char)'.')));
        AnnotationInfo annotationInfo = new AnnotationInfo();
        annotationInfo.members = members;
        newElements.put(annotation, annotationInfo);
    }

    private IMemberValuePair[] getRetentionPolicy(long tagBits) {
        if ((tagBits & 0x300000000000L) == 0L) {
            return Annotation.NO_MEMBER_VALUE_PAIRS;
        }
        String retention = null;
        retention = (tagBits & 0x300000000000L) == 0x300000000000L ? String.valueOf(new String(CharOperation.concatWith((char[][])TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, (char)'.'))) + '.' + new String(TypeConstants.UPPER_RUNTIME) : ((tagBits & 0x100000000000L) != 0L ? String.valueOf(new String(CharOperation.concatWith((char[][])TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, (char)'.'))) + '.' + new String(TypeConstants.UPPER_SOURCE) : String.valueOf(new String(CharOperation.concatWith((char[][])TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, (char)'.'))) + '.' + new String(TypeConstants.UPPER_CLASS));
        final String value = retention;
        return new IMemberValuePair[]{new IMemberValuePair(){

            @Override
            public int getValueKind() {
                return 12;
            }

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public String getMemberName() {
                return new String(TypeConstants.VALUE);
            }
        }};
    }

    private void generateFieldInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IBinaryField[] fields = typeInfo.getFields();
        if (fields == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        int fieldCount = fields.length;
        while (i < fieldCount) {
            IBinaryField fieldInfo = fields[i];
            if (!(CharOperation.prefixEquals((char[])IOTConstants.OT_DOLLAR_NAME, (char[])fieldInfo.getName()) || typeInfo.isRecord() && (fieldInfo.getModifiers() & 8) == 0)) {
                BinaryField field = new BinaryField((JavaElement)((Object)type), manager.intern(new String(fieldInfo.getName())));
                newElements.put(field, fieldInfo);
                childrenHandles.add(field);
                this.generateAnnotationsInfos(field, fieldInfo.getAnnotations(), fieldInfo.getTagBits(), newElements);
            }
            ++i;
        }
    }

    private void generateRecordComponentInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IRecordComponent[] components = typeInfo.getRecordComponents();
        if (components == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        int fieldCount = components.length;
        while (i < fieldCount) {
            IRecordComponent componentInfo = components[i];
            BinaryField component = new BinaryField((JavaElement)((Object)type), manager.intern(new String(componentInfo.getName()))){

                @Override
                public boolean isRecordComponent() throws JavaModelException {
                    return true;
                }
            };
            newElements.put(component, componentInfo);
            childrenHandles.add(component);
            this.generateAnnotationsInfos(component, componentInfo.getAnnotations(), componentInfo.getTagBits(), newElements);
            ++i;
        }
    }

    private void generateInnerClassHandles(IType type, IBinaryType typeInfo, ArrayList childrenHandles) {
        IBinaryNestedType[] innerTypes = typeInfo.getMemberTypes();
        if (innerTypes != null) {
            IPackageFragment pkg = (IPackageFragment)type.getAncestor(4);
            int i = 0;
            int typeCount = innerTypes.length;
            while (i < typeCount) {
                IBinaryNestedType binaryType = innerTypes[i];
                IClassFile parentClassFile = pkg.getClassFile(String.valueOf(new String(ClassFile.unqualifiedName(binaryType.getName()))) + ".class");
                int flags = binaryType.getModifiers();
                if ((flags & 0x208) != 520) {
                    int pos;
                    BinaryType innerType = new BinaryType(typeInfo.getName(), (JavaElement)((Object)parentClassFile), ClassFile.simpleName(binaryType.getName()));
                    if (Flags.isTeam(typeInfo.getModifiers())) {
                        flags |= 0x10000;
                    }
                    String baseclassName = null;
                    String baseclassAnchor = null;
                    if (typeInfo instanceof ClassFileReader && (baseclassName = ((ClassFileReader)typeInfo).getBaseclassName(innerType.getElementName())) != null && (pos = baseclassName.indexOf(60)) > -1) {
                        baseclassAnchor = baseclassName.substring(pos + 1, baseclassName.length() - 1);
                        baseclassName = baseclassName.substring(0, pos);
                    }
                    OTModelManager.getSharedInstance().addType(innerType, flags, baseclassName, baseclassAnchor, false);
                    childrenHandles.add(innerType);
                }
                ++i;
            }
        }
    }

    private void evaluateAttribute(CalloutMappingsAttribute attr, IType type, List<IJavaElement> childrenHandles, CompilerOptions.WeavingScheme scheme) {
        int i = 0;
        while (i < attr.getNumMappings()) {
            IMethodMapping mapping;
            MappingElementInfo calloutInfo = new MappingElementInfo();
            calloutInfo.setRoleMethod(new MethodData(attr.getRoleMethodNameAt(i), attr.getRoleMethodSignatureAt(i)));
            boolean isCTF = false;
            int flags = attr.getCalloutFlagsAt(i);
            if (flags == 0) {
                calloutInfo.setBaseMethods(new MethodData[]{new MethodData(attr.getBaseMethodNameAt(i), attr.getBaseMethodSignatureAt(i))});
            } else {
                String fieldType;
                isCTF = true;
                String fieldName = attr.getBaseMethodNameAt(i);
                if (fieldName.charAt(7) == '$') {
                    fieldName = fieldName.substring(8);
                }
                boolean isSetter = flags == 2;
                String accessorSignature = attr.getBaseMethodSignatureAt(i);
                String string = isSetter ? Signature.getParameterTypes(accessorSignature)[scheme == CompilerOptions.WeavingScheme.OTRE ? 1 : 0] : (fieldType = Signature.getReturnType(accessorSignature));
                if (fieldType.indexOf(47) > -1) {
                    fieldType = String.valueOf(ClassFile.translatedName(fieldType.toCharArray()));
                }
                calloutInfo.setBaseField(new FieldData(fieldName, fieldType, isSetter));
            }
            calloutInfo.setHasSignature(true);
            calloutInfo.setDeclaredModifiers(attr.getDeclaredModifiersAt(i));
            IMethodMapping iMethodMapping = mapping = isCTF ? OTModelManager.getSharedInstance().addCalloutToFieldBinding(type, calloutInfo) : OTModelManager.getSharedInstance().addCalloutBinding(type, calloutInfo);
            if (mapping != null) {
                childrenHandles.add(mapping);
            }
            ++i;
        }
    }

    private void evaluateAttribute(CallinMethodMappingsAttribute attr, IType type, List<IJavaElement> childrenHandles) {
        int j = 0;
        while (j < attr.getLength()) {
            MappingElementInfo callinInfo = new MappingElementInfo();
            callinInfo.setCallinName(attr.getCallinNameAt(j));
            callinInfo.setRoleMethod(new MethodData(attr.getRoleMethodNameAt(j), attr.getRoleMethodSignatureAt(j)));
            String[] baseNames = attr.getBaseMethodNamesAt(j);
            String[] baseSigns = attr.getBaseMethodSignaturesAt(j);
            MethodData[] baseMethods = new MethodData[baseNames.length];
            int k = 0;
            while (k < baseNames.length) {
                baseMethods[k] = new MethodData(baseNames[k], baseSigns[k], attr.getCovariantReturnAt(j));
                ++k;
            }
            callinInfo.setBaseMethods(baseMethods);
            callinInfo.setCallinKind(attr.getCallinModifierAt(j));
            callinInfo.setHasSignature(true);
            ICallinMapping mapping = OTModelManager.getSharedInstance().addCallinBinding(type, callinInfo);
            if (mapping != null) {
                childrenHandles.add(mapping);
            }
            ++j;
        }
    }

    private void generateMethodInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles, ArrayList typeParameterHandles) {
        IBinaryMethod[] methods = typeInfo.getMethods();
        if (methods == null) {
            return;
        }
        int i = 0;
        int methodCount = methods.length;
        while (i < methodCount) {
            IBinaryMethod methodInfo = methods[i];
            boolean isConstructor = methodInfo.isConstructor();
            boolean isEnum = false;
            try {
                isEnum = type.isEnum();
            }
            catch (JavaModelException javaModelException) {}
            if (!CharOperation.prefixEquals((char[])IOTConstants.OT_DOLLAR_NAME, (char[])methodInfo.getSelector())) {
                boolean useGenericSignature = true;
                char[] signature = methodInfo.getGenericSignature();
                String[] pNames = null;
                if (signature == null) {
                    int length;
                    useGenericSignature = false;
                    signature = methodInfo.getMethodDescriptor();
                    if (isEnum && isConstructor && (length = (pNames = Signature.getParameterTypes(new String(signature))).length - 2) >= 0) {
                        String[] stringArray = pNames;
                        pNames = new String[length];
                        System.arraycopy(stringArray, 2, pNames, 0, length);
                    }
                }
                String selector = new String(methodInfo.getSelector());
                if (isConstructor && (selector = type.getElementName()).startsWith("__OT__")) {
                    selector = selector.substring(IOTConstants.OT_DELIM_LEN);
                }
                try {
                    if (!isEnum || !isConstructor || useGenericSignature) {
                        pNames = Signature.getParameterTypes(new String(signature));
                    }
                    if (isConstructor && useGenericSignature && type.isMember() && !Flags.isStatic(type.getFlags())) {
                        int length = pNames.length;
                        String[] stringArray = pNames;
                        pNames = new String[length + 1];
                        System.arraycopy(stringArray, 0, pNames, 1, length);
                        char[] descriptor = methodInfo.getMethodDescriptor();
                        String[] parameterTypes = Signature.getParameterTypes(new String(descriptor));
                        pNames[0] = parameterTypes[0];
                    }
                }
                catch (IllegalArgumentException | JavaModelException object) {
                    signature = methodInfo.getMethodDescriptor();
                    pNames = Signature.getParameterTypes(new String(signature));
                }
                char[][] paramNames = new char[pNames.length][];
                int j = 0;
                while (j < pNames.length) {
                    paramNames[j] = pNames[j].toCharArray();
                    ++j;
                }
                char[][] parameterTypes = ClassFile.translatedNames(paramNames);
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                selector = manager.intern(selector);
                int j2 = 0;
                while (j2 < pNames.length) {
                    pNames[j2] = manager.intern(new String(parameterTypes[j2]));
                    ++j2;
                }
                BinaryMethod method = new BinaryMethod((JavaElement)((Object)type), selector, pNames);
                childrenHandles.add(method);
                while (newElements.containsKey(method)) {
                    method.occurrenceCount = method.occurrenceCount + 1;
                }
                newElements.put(method, methodInfo);
                int max = pNames.length;
                Object argumentNames = methodInfo.getArgumentNames();
                if (argumentNames == null || ((char[][])argumentNames).length < max) {
                    argumentNames = new char[max][];
                    int j3 = 0;
                    while (j3 < max) {
                        argumentNames[j3] = ("arg" + j3).toCharArray();
                        ++j3;
                    }
                }
                int startIndex = 0;
                try {
                    if (isConstructor) {
                        if (isEnum) {
                            startIndex = 2;
                        } else if (type.isMember() && !Flags.isStatic(type.getFlags())) {
                            startIndex = 1;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
                int j4 = startIndex;
                while (j4 < max) {
                    IBinaryAnnotation[] parameterAnnotations = methodInfo.getParameterAnnotations(j4 - startIndex, typeInfo.getFileName());
                    if (parameterAnnotations != null) {
                        LocalVariable localVariable = new LocalVariable(method, new String(argumentNames[j4]), 0, -1, 0, -1, method.parameterTypes[j4], null, -1, true);
                        this.generateAnnotationsInfos(localVariable, argumentNames[j4], parameterAnnotations, methodInfo.getTagBits(), newElements);
                    }
                    ++j4;
                }
                this.generateTypeParameterInfos(method, signature, newElements, typeParameterHandles);
                this.generateAnnotationsInfos(method, methodInfo.getAnnotations(), methodInfo.getTagBits(), newElements);
                Object defaultValue = methodInfo.getDefaultValue();
                if (defaultValue instanceof IBinaryAnnotation) {
                    this.generateAnnotationInfo(method, newElements, (IBinaryAnnotation)defaultValue, new String(methodInfo.getSelector()));
                }
            }
            ++i;
        }
    }

    private void generateTypeParameterInfos(BinaryMember parent, char[] signature, HashMap newElements, ArrayList typeParameterHandles) {
        if (signature == null) {
            return;
        }
        char[][] typeParameterSignatures = Signature.getTypeParameters(signature);
        int i = 0;
        int typeParameterCount = typeParameterSignatures.length;
        while (i < typeParameterCount) {
            char[] typeParameterSignature = typeParameterSignatures[i];
            char[] typeParameterName = Signature.getTypeVariable(typeParameterSignature);
            CharOperation.replace((char[])typeParameterSignature, (char)'/', (char)'.');
            char[][] typeParameterBoundSignatures = Signature.getTypeParameterBounds(typeParameterSignature);
            int boundLength = typeParameterBoundSignatures.length;
            char[][] typeParameterBounds = new char[boundLength][];
            int j = 0;
            while (j < boundLength) {
                typeParameterBounds[j] = Signature.toCharArray(typeParameterBoundSignatures[j]);
                ++j;
            }
            TypeParameter typeParameter = new TypeParameter(parent, new String(typeParameterName));
            TypeParameterElementInfo info = new TypeParameterElementInfo();
            info.bounds = typeParameterBounds;
            info.boundsSignatures = typeParameterBoundSignatures;
            typeParameterHandles.add(typeParameter);
            while (newElements.containsKey(typeParameter)) {
                typeParameter.occurrenceCount = typeParameter.occurrenceCount + 1;
            }
            newElements.put(typeParameter, info);
            ++i;
        }
    }

    protected void readBinaryChildren(ClassFile classFile, HashMap newElements, IBinaryType typeInfo) {
        ArrayList<IJavaElement> childrenHandles = new ArrayList<IJavaElement>();
        BinaryType type = (BinaryType)classFile.getType(typeInfo != null ? typeInfo.getEnclosingTypeName() : null);
        ArrayList typeParameterHandles = new ArrayList();
        if (typeInfo != null) {
            this.generateAnnotationsInfos(type, typeInfo.getAnnotations(), typeInfo.getTagBits(), newElements);
            this.generateTypeParameterInfos(type, typeInfo.getGenericSignature(), newElements, typeParameterHandles);
            this.generateFieldInfos(type, typeInfo, newElements, childrenHandles);
            this.generateRecordComponentInfos(type, typeInfo, newElements, childrenHandles);
            this.generateMethodInfos(type, typeInfo, newElements, childrenHandles, typeParameterHandles);
            this.generateInnerClassHandles(type, typeInfo, childrenHandles);
            if (typeInfo instanceof ClassFileReader) {
                CompilerOptions.WeavingScheme scheme = CompilerOptions.WeavingScheme.OTDRE;
                for (AbstractAttribute attr : ((ClassFileReader)typeInfo).getOTAttributes()) {
                    if (!attr.nameEquals(IOTConstants.OT_COMPILER_VERSION)) continue;
                    scheme = ((WordValueAttribute)attr).weavingSchemeFromCompilerVersion();
                    break;
                }
                for (AbstractAttribute attr : ((ClassFileReader)typeInfo).getOTAttributes()) {
                    if (attr.nameEquals(IOTConstants.CALLIN_METHOD_MAPPINGS)) {
                        this.evaluateAttribute((CallinMethodMappingsAttribute)attr, type, childrenHandles);
                        continue;
                    }
                    if (!attr.nameEquals(IOTConstants.CALLOUT_MAPPINGS)) continue;
                    this.evaluateAttribute((CalloutMappingsAttribute)attr, type, childrenHandles, scheme);
                }
            }
        }
        this.binaryChildren = new JavaElement[childrenHandles.size()];
        childrenHandles.toArray(this.binaryChildren);
        int typeParameterHandleSize = typeParameterHandles.size();
        if (typeParameterHandleSize == 0) {
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        } else {
            this.typeParameters = new ITypeParameter[typeParameterHandleSize];
            typeParameterHandles.toArray(this.typeParameters);
        }
    }

    void removeBinaryChildren() throws JavaModelException {
        int i;
        JavaModelManager manager;
        if (this.binaryChildren != null) {
            manager = JavaModelManager.getJavaModelManager();
            i = 0;
            while (i < this.binaryChildren.length) {
                JavaElement child = this.binaryChildren[i];
                if (child instanceof BinaryType) {
                    manager.removeInfoAndChildren(child.getParent());
                } else {
                    manager.removeInfoAndChildren(child);
                }
                ++i;
            }
            this.binaryChildren = JavaElement.NO_ELEMENTS;
        }
        if (this.typeParameters != null) {
            manager = JavaModelManager.getJavaModelManager();
            i = 0;
            while (i < this.typeParameters.length) {
                TypeParameter typeParameter = (TypeParameter)this.typeParameters[i];
                manager.removeInfoAndChildren(typeParameter);
                ++i;
            }
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        }
    }
}

