/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Field;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmTypeHelper;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CreateFieldAccessAdapter
extends AbstractTransformableClassNode {
    private Field field;
    private int accessId;
    private Method access;
    private int firstArgIndex;

    public CreateFieldAccessAdapter(Field field, int accessId) {
        this.field = field;
        this.accessId = accessId;
        if (field.isStatic()) {
            this.access = ConstantMembers.accessStatic;
            this.firstArgIndex = 0;
        } else {
            this.access = ConstantMembers.access;
            this.firstArgIndex = 1;
        }
    }

    @Override
    public boolean transform() {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(21, this.firstArgIndex + 1));
        LabelNode writeAccess = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(154, writeAccess));
        if (this.field.isStatic()) {
            instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.name, this.field.getName(), this.field.getSignature()));
        } else {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.name, this.field.getName(), this.field.getSignature()));
        }
        Type type = Type.getType((String)this.field.getSignature());
        instructions.add(AsmTypeHelper.getBoxingInstructionForType(type));
        instructions.add((AbstractInsnNode)new InsnNode(176));
        instructions.add((AbstractInsnNode)writeAccess);
        if (!this.field.isStatic()) {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        instructions.add((AbstractInsnNode)new VarInsnNode(25, this.firstArgIndex + 2));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(50));
        if (type.getSort() != 9 && type.getSort() != 10) {
            String objectType = AsmTypeHelper.getBoxingType(type);
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
            instructions.add(AsmTypeHelper.getUnboxingInstructionForType(type, objectType));
        } else {
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, type.getInternalName()));
        }
        if (this.field.isStatic()) {
            instructions.add((AbstractInsnNode)new FieldInsnNode(179, this.name, this.field.getName(), this.field.getSignature()));
        } else {
            instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.name, this.field.getName(), this.field.getSignature()));
        }
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new InsnNode(176));
        MethodNode method = this.getMethod(this.access);
        this.addNewLabelToSwitch(method.instructions, instructions, this.accessId);
        return true;
    }
}

