/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.tests.TestConfiguration;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.eclipse.ohf.utilities.xml.XMLReader;
import org.eclipse.ohf.utilities.xml.XMLWriter;
import org.eclipse.ohf.utilities.xml.XMLWriterParser;
import org.xml.sax.SAXException;

public abstract class OHFTestCase
extends TestCase {
    private void prettyXML(String source, String dest) throws UnsupportedEncodingException, FileNotFoundException, SAXException {
        XMLWriter dst = new XMLWriter((OutputStream)new FileOutputStream(new File(dest)), "UTF-8");
        dst.setPretty(true);
        XMLReader src = new XMLReader((XMLObjectParser)new XMLWriterParser(dst));
        src.parse((InputStream)new FileInputStream(new File(source)));
    }

    protected void compareXMLs(String filename1, String filename2, String name1, String name2) throws IOException, OHFException, InterruptedException, SAXException {
        FileInputStream one = new FileInputStream(new File(filename1));
        FileInputStream two = new FileInputStream(new File(filename2));
        int size1 = one.available();
        int size2 = two.available();
        int[] list = new int[]{size1, size2};
        int size = NumberUtils.min((int[])list);
        boolean same = true;
        int count = 0;
        while (same && count < size) {
            same = one.read() == two.read();
            ++count;
        }
        if (!same || size1 != size2) {
            this.prettyXML(filename1, "C:\\temp\\" + name1 + ".xml");
            this.prettyXML(filename2, "C:\\temp\\" + name2 + ".xml");
            Runtime.getRuntime().exec("C:\\Program Files\\WinMerge\\WinMerge \"C:\\temp\\" + name1 + ".xml" + "\" \"" + "C:\\temp\\" + name2 + ".xml" + "\"");
            Thread.sleep(1000L);
            if (!same) {
                throw new OHFException("Content is not as expected @ " + Integer.toString(count) + " of " + Integer.toString(size) + " (" + Integer.toString(size1) + "/" + Integer.toString(size2) + ")");
            }
            throw new OHFException("Content is same until end of file @ " + Integer.toString(size1) + "/" + Integer.toString(size2));
        }
    }

    protected void compareFiles(String filename1, String filename2) throws IOException, OHFException, InterruptedException {
        FileInputStream one = new FileInputStream(new File(filename1));
        FileInputStream two = new FileInputStream(new File(filename2));
        boolean same = one.available() == two.available();
        while (same && one.available() > 0) {
            boolean bl = same = one.read() == two.read();
        }
        if (!same) {
            Runtime.getRuntime().exec("C:\\Program Files\\WinMerge\\WinMerge \"" + filename1 + "\" \"" + filename2 + "\"");
            Thread.sleep(1000L);
            throw new OHFException("Content is not as expected @ " + Integer.toString(one.available()));
        }
    }

    protected void compareStrings(String content1, String content2) throws IOException, OHFException, InterruptedException {
        String filename1 = String.valueOf(TestConfiguration.tempFilename()) + "1";
        String filename2 = String.valueOf(TestConfiguration.tempFilename()) + "2";
        this.stringToFile(content1, filename1);
        this.stringToFile(content2, filename2);
        this.compareFiles(filename1, filename2);
    }

    private void stringToFile(String content, String filename) throws IOException {
        FileWriter file = new FileWriter(new File(filename));
        file.write(content);
        file.flush();
        file.close();
    }
}

