/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe;

import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.conf.AbstractRhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.xds.consumer.Consumer;
import org.eclipse.ohf.ihe.xds.source.Source;

public class XdsResources
extends AbstractRhioDedicatedResources {
    static final Logger mLogger = Logger.getLogger(XdsResources.class);
    private Consumer mXdsStoredQueriesDocumentConsumer;
    private Consumer mXdsNoneStoredQueriesDocumentConsumer;
    private Source mXdsDocumentSource;

    public XdsResources(RhioConfig pConfig) {
        super(pConfig);
    }

    public boolean isNoneStoredQueriesResourcesAvaliable() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getNoneStoredQueriesUrl() != null;
    }

    public boolean isStoredQueriesResourcesAvaliable() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueriesUrl() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer getNoneStoredQueriesXdsDocumentConsumer() throws UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getNoneStoredQueriesXdsDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsNoneStoredQueriesDocumentConsumer != null) {
            return this.mXdsNoneStoredQueriesDocumentConsumer;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsNoneStoredQueriesDocumentConsumer != null) {
                return this.mXdsNoneStoredQueriesDocumentConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getNoneStoredQueriesUrl()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getNoneStoredQueriesUrl() == null) {
                throw new UnavailableResourcesException("NoneStoredQueriesUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            this.mXdsNoneStoredQueriesDocumentConsumer = new Consumer(this.getRhioConfiguration().getXdsRegistryConfig().getNoneStoredQueriesUrl().defaultUri());
        }
        return this.mXdsNoneStoredQueriesDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer getStoredQueriesXdsDocumentConsumer() throws UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getStoredQueriesXdsDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsStoredQueriesDocumentConsumer != null) {
            return this.mXdsStoredQueriesDocumentConsumer;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsStoredQueriesDocumentConsumer != null) {
                return this.mXdsStoredQueriesDocumentConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueriesUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueriesUrl() == null) {
                throw new UnavailableResourcesException("StoredQueriesUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            this.mXdsStoredQueriesDocumentConsumer = new Consumer(this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueriesUrl().defaultUri());
        }
        return this.mXdsStoredQueriesDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getXdsDocumentSource() {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Source getXdsDocumentSource()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsDocumentSource != null) {
            return this.mXdsDocumentSource;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsDocumentSource != null) {
                return this.mXdsDocumentSource;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"create Source");
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            this.mXdsDocumentSource = new Source(this.getRhioConfiguration().getXdsRepositoryConfig().getUrl().defaultUri());
        }
        return this.mXdsDocumentSource;
    }
}

