/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pix.consumer;

import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerException;

public class PixConsumerResponse
extends PixPdqMessage {
    private boolean hasERR = false;
    private boolean hasPID = false;
    private static final int version = 8;

    public PixConsumerResponse(MessageManager globalFactory) throws PixConsumerException {
        try {
            this.setDefinitions(globalFactory.getVersionDefinitions());
            this.setVersion(8);
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
    }

    public void init() {
        SegmentList segList = this.getSegments();
        int i = 0;
        while (i < segList.size()) {
            if (!this.hasERR && segList.item(i).getCode().compareTo("ERR") == 0) {
                this.hasERR = true;
            } else if (!this.hasPID && segList.item(i).getCode().compareTo("PID") == 0) {
                this.hasPID = true;
            }
            ++i;
        }
    }

    public boolean hasError() {
        return this.hasERR;
    }

    public String getResponseAckCode(boolean expandString) throws PixConsumerException {
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("MSA", 1);
        int fieldIndex = 0;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
        return value;
    }

    public String getControlId() throws PixConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSA", 1);
        int fieldIndex = 1;
        try {
            return seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
    }

    public int getErrorCountBySegment() {
        if (!this.hasERR) {
            return -1;
        }
        return this.getSegments().countByCode("ERR");
    }

    public int getErrorCountByRepeat() {
        if (!this.hasERR) {
            return -1;
        }
        try {
            int fieldIndex = 1;
            return this.getSegments().getByCodeAndIndex("ERR", 1).getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String[] getErrorLocation(int segmentIndex, int repeatIndex) throws PixConsumerException {
        if (!this.hasERR) {
            return null;
        }
        Segment seg = this.getSegments().getByCodeAndIndex("ERR", segmentIndex + 1);
        int fieldIndex = 1;
        try {
            return PixPdqMessageUtilities.getFieldComponentsInRepeat((Segment)seg, (int)fieldIndex, (int)repeatIndex);
        }
        catch (PixPdqMessageException e) {
            throw new PixConsumerException(e);
        }
    }

    public String[] getErrorCode(int segmentIndex) throws PixConsumerException {
        if (!this.hasERR) {
            return null;
        }
        Segment seg = this.getSegments().getByCodeAndIndex("ERR", segmentIndex + 1);
        int fieldIndex = 2;
        try {
            return PixPdqMessageUtilities.getFieldComponents((Segment)seg, (int)fieldIndex);
        }
        catch (PixPdqMessageException e) {
            throw new PixConsumerException(e);
        }
    }

    public String getErrorSeverity(int segmentIndex, boolean expandString) throws PixConsumerException {
        if (!this.hasERR) {
            return "";
        }
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("ERR", segmentIndex + 1);
        int fieldIndex = 3;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
        return value;
    }

    public String getQueryStatus(boolean expandString) throws PixConsumerException {
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("QAK", 1);
        int fieldIndex = 1;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
        return value;
    }

    public String[] getQueryName() throws PixConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("QPD", 1);
        int fieldIndex = 0;
        try {
            return PixPdqMessageUtilities.getFieldComponents((Segment)seg, (int)fieldIndex);
        }
        catch (PixPdqMessageException e) {
            throw new PixConsumerException(e);
        }
    }

    public String getQueryTag() throws PixConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("QPD", 1);
        int fieldIndex = 1;
        try {
            return seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
    }

    public int getPatientCount() {
        return this.getSegments().countByCode("PID");
    }

    public int getPatientIdentifierCount(int patientIndex) throws PixConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 2;
        try {
            return seg.getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
    }

    public String[] getPatientIdentifier(int patientIndex, int identifierIndex) throws PixConsumerException {
        String[] values = new String[4];
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 2;
        try {
            Field fld = seg.getFields().item(fieldIndex).getRepeat(identifierIndex);
            values[0] = fld.forceElement("1").getAsString();
            values[1] = fld.forceElement("4-1").getAsString();
            values[2] = fld.forceElement("4-2").getAsString();
            values[3] = fld.forceElement("4-3").getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
        return values;
    }

    public int getPatientNameCount(int patientIndex) {
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 4;
        try {
            return seg.getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String[] getPatientName(int patientIndex, int patientNameIndex) throws PixConsumerException {
        String[] values = new String[6];
        int fieldIndex = 4;
        try {
            Field fld = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex).getRepeat(patientNameIndex);
            values[0] = fld.forceElement("1-1").getAsString();
            values[1] = fld.forceElement("2").getAsString();
            values[2] = fld.forceElement("3").getAsString();
            values[3] = fld.forceElement("4").getAsString();
            values[4] = fld.forceElement("5").getAsString();
            values[5] = fld.forceElement("6").getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
        return values;
    }

    public String getPatientNameFamilyName(int patientIndex, int patientNameIndex) throws PixConsumerException {
        String component = "1-1";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameGivenName(int patientIndex, int patientNameIndex) throws PixConsumerException {
        String component = "2";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameOtherName(int patientIndex, int patientNameIndex) throws PixConsumerException {
        String component = "3";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameSuffix(int patientIndex, int patientNameIndex) throws PixConsumerException {
        String component = "4";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNamePrefix(int patientIndex, int patientNameIndex) throws PixConsumerException {
        String component = "5";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameDegree(int patientIndex, int patientNameIndex) throws PixConsumerException {
        String component = "6";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    private String getPatientNameRepeatField(int patientIndex, int patientNameIndex, String component) throws PixConsumerException {
        try {
            int fieldIndex = 4;
            Field fld = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex).getRepeat(patientNameIndex);
            return fld.forceElement(component).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixConsumerException(e);
        }
    }
}

