/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.payload;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.payload.SoapAttachment;
import org.eclipse.ohf.ihe.atna.payload.service.payload.PayloadService;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PayloadImpl
implements PayloadService {
    private static final Logger logger = Logger.getLogger(PayloadImpl.class);
    private String m_url = "";

    public void PayloadImpl() {
        final ClassLoader classLoader = this.getClass().getClassLoader();
        Thread thread = new Thread(){

            public void run() {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        };
        thread.run();
    }

    public void getData() {
        SOAPMessage request = null;
        try {
            MessageFactory factory = MessageFactory.newInstance();
            request = factory.createMessage();
            request.getSOAPBody();
            SOAPFactory.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public SOAPMessage setData(String[] args) {
        SOAPMessage soap = null;
        if (args.length != 1) {
            System.err.println("\nUsage: give at least the path to files");
        }
        String path = args[0];
        int NumOfAttachFiles = 0;
        String xdsPropertiesFile = String.valueOf(path) + "\\" + "test.properties";
        String url = null;
        String patientid = null;
        String SubmitMetadataFile = null;
        System.out.print(" Made the call inside of setData\n");
        PayloadImpl.clearFile(String.valueOf(path) + "\\" + "error.log");
        PayloadImpl.clearFile(String.valueOf(path) + "\\" + "log.msg");
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(xdsPropertiesFile));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            System.out.print(" Not a test Directory\n");
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SubmitMetadataFile = props.getProperty("metadatafile");
        url = props.getProperty("url");
        this.setUrl(url);
        patientid = props.getProperty("patientid");
        NumOfAttachFiles = Integer.valueOf(props.getProperty("NumOfDoc"));
        String[] attachfileArray = new String[2];
        String[] mimeTypeArray = new String[2];
        String[] uuidArray = new String[2];
        if (NumOfAttachFiles >= 0 && NumOfAttachFiles <= 2) {
            if (NumOfAttachFiles == 1) {
                attachfileArray[0] = props.getProperty("doc1");
                mimeTypeArray[0] = props.getProperty("doc1mimeType");
                uuidArray[0] = props.getProperty("doc1UUID");
            }
            if (NumOfAttachFiles == 2) {
                attachfileArray[0] = props.getProperty("doc1");
                mimeTypeArray[0] = props.getProperty("doc1mimeType");
                uuidArray[0] = props.getProperty("doc1UUID");
                attachfileArray[1] = props.getProperty("doc2");
                mimeTypeArray[1] = props.getProperty("doc2mimeType");
                uuidArray[1] = props.getProperty("doc2UUID");
            }
        } else {
            System.out.println("\nThe number of attached files must be 0, 1 or 2\n");
            System.exit(0);
        }
        if (patientid == null || SubmitMetadataFile == null || url == null) {
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            System.out.println("url = " + url);
            System.out.println("metadatafile = " + SubmitMetadataFile);
            System.out.println("patientid = " + patientid);
            System.out.println("\n*** null value was found\n");
            System.exit(0);
        }
        File Metadata = new File(String.valueOf(path) + "\\" + SubmitMetadataFile);
        soap = this.buildDocuments(Metadata, attachfileArray, mimeTypeArray, uuidArray, NumOfAttachFiles, url, patientid);
        return soap;
    }

    public SOAPMessage prepareData(String metadata, SoapAttachment[] attachments) {
        SOAPMessage soap = null;
        String SubmitMetadataFile = null;
        System.out.print(" Made the call inside of prepareData\n");
        if (metadata == null) {
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            System.out.println("metadatafile = " + SubmitMetadataFile);
            System.out.println("\n*** null value was found\n");
            return null;
        }
        soap = this.buildDocuments(metadata, attachments);
        return soap;
    }

    public SOAPMessage buildDocuments(File metadatafile, String[] attachfileArray, String[] mimeTypeArray, String[] uuidArray, int NumOfAttachFiles, String url, String patientid) {
        String headervalue = " ";
        PrintStream orig = System.out;
        File msgfile = null;
        String msgfilename = "log.msg";
        SOAPMessage message = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            message = messageFactory.createMessage();
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = envelope.getHeader();
            soapHeader.addTextNode(headervalue);
            SOAPBody soapBody = envelope.getBody();
            soapBody.addDocument(this.buildDoc(metadatafile));
            msgfile = new File(msgfilename);
            this.msgtofile(msgfile);
            System.out.println("\nURL = " + url);
            System.out.println("patientid = " + patientid);
            System.out.println("\n************************************************");
            PayloadImpl.printMessage(message, "REQUEST");
            Calendar c = Calendar.getInstance();
            c.getTime();
            c.getTimeInMillis();
            if (NumOfAttachFiles > 0) {
                int i = 0;
                while (i < NumOfAttachFiles) {
                    String ExtrinsicObjMimeType = mimeTypeArray[i];
                    String ExtrinsicObjUUID = uuidArray[i];
                    FileDataSource Attachfile = new FileDataSource(attachfileArray[i]);
                    DataHandler Attachmentdh = new DataHandler((DataSource)Attachfile);
                    AttachmentPart Attachmentpart = message.createAttachmentPart(Attachmentdh);
                    Attachmentpart.setMimeHeader("Content-Type", ExtrinsicObjMimeType);
                    Attachmentpart.setContentId(ExtrinsicObjUUID);
                    message.addAttachmentPart(Attachmentpart);
                    ++i;
                }
            }
        }
        catch (ConnectException ce) {
            logger.error((Object)ce);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            ce.printStackTrace();
        }
        catch (SOAPException ex) {
            logger.error((Object)ex);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            ex.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)e);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            e.printStackTrace();
        }
        return message;
    }

    public static void attachBytes(SOAPMessage soapMessage, byte[] theBytes, String contentType) throws SOAPException {
        AttachmentPart attachment = soapMessage.createAttachmentPart();
        attachment.setContent((Object)new ByteArrayInputStream(theBytes), contentType);
        soapMessage.addAttachmentPart(attachment);
    }

    public SOAPMessage buildDocuments(String metadatafile, SoapAttachment[] attachfileArray) {
        String headervalue = " ";
        PrintStream orig = System.out;
        File msgfile = null;
        String msgfilename = "log.msg";
        SOAPMessage message = null;
        int NumOfAttachFiles = 0;
        if (attachfileArray != null) {
            NumOfAttachFiles = attachfileArray.length;
        }
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            message = messageFactory.createMessage();
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = envelope.getHeader();
            soapHeader.addTextNode(headervalue);
            SOAPBody soapBody = envelope.getBody();
            soapBody.addDocument(this.buildDoc(metadatafile));
            msgfile = new File(msgfilename);
            this.msgtofile(msgfile);
            if (NumOfAttachFiles > 0) {
                int i = 0;
                while (i < NumOfAttachFiles) {
                    String attachdata = attachfileArray[i].getData();
                    String ExtrinsicObjMimeType = attachfileArray[i].getMimeType();
                    if (ExtrinsicObjMimeType.equalsIgnoreCase("text/xml") || ExtrinsicObjMimeType.equalsIgnoreCase("application/xml")) {
                        ExtrinsicObjMimeType = "multipart/*";
                    }
                    String ExtrinsicObjUUID = attachfileArray[i].getContentId();
                    AttachmentPart attachment = message.createAttachmentPart();
                    attachment.setContent((Object)attachdata, ExtrinsicObjMimeType);
                    attachment.setContentId(ExtrinsicObjUUID);
                    message.addAttachmentPart(attachment);
                    ++i;
                }
                message.saveChanges();
            }
            PayloadImpl.printMessage(message, "REQUEST");
        }
        catch (ConnectException ce) {
            logger.error((Object)ce);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            ce.printStackTrace();
        }
        catch (SOAPException ex) {
            logger.error((Object)ex);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            ex.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)e);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            e.printStackTrace();
        }
        return message;
    }

    public static void redirectOut() {
        try {
            File log = new File("error.log");
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(log)), true);
            System.setErr(printStream);
            System.setOut(printStream);
        }
        catch (IOException iOException) {
            System.out.println("Problem with the logfile");
        }
    }

    public static void clearFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
    }

    public void msgtofile(File msgfile) {
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(msgfile, true)), true);
            System.setErr(printStream);
            System.setOut(printStream);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            System.out.println("Problem with the message file");
        }
    }

    public Document buildDoc(File documentfile) {
        Document document = null;
        PrintStream orig = System.out;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            document = builder.parse(documentfile);
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)pce);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            pce.printStackTrace();
        }
        catch (SAXException se) {
            logger.error((Object)se);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            se.printStackTrace();
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            ex.printStackTrace();
        }
        return document;
    }

    public Document buildDoc(String documentdata) {
        Document document = null;
        PrintStream orig = System.out;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            document = builder.parse(new ByteArrayInputStream(documentdata.getBytes()));
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)pce);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            pce.printStackTrace();
        }
        catch (SAXException se) {
            logger.error((Object)se);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            se.printStackTrace();
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            System.setOut(orig);
            System.out.println("\n\nERROR OCCURRED: See error.log\n");
            PayloadImpl.redirectOut();
            ex.printStackTrace();
        }
        return document;
    }

    private static void printMessage(SOAPMessage message, String headerType) throws IOException, SOAPException {
        if (message != null) {
            System.out.println("\n\nHeader: " + headerType);
            if (message.saveRequired()) {
                message.saveChanges();
            }
            MimeHeaders headers = message.getMimeHeaders();
            PayloadImpl.printHeaders(headers);
            System.out.println("\n\nMessage: " + headerType);
            message.writeTo((OutputStream)System.out);
            System.out.println();
        }
    }

    private static void printHeaders(MimeHeaders headers) {
        PayloadImpl.printHeaders(headers.getAllHeaders());
    }

    private static void printHeaders(Iterator iter) {
        while (iter.hasNext()) {
            MimeHeader header = (MimeHeader)iter.next();
            System.out.println("\t" + header.getName() + " : " + header.getValue());
        }
    }

    public void setUrl(String m_url) {
        this.m_url = m_url;
    }

    public String getUrl() {
        return this.m_url;
    }
}

