/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe.pixpdq;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.BridgeException;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.AbstractRhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.DefaultMessageQueryName;
import org.eclipse.ohf.bridge.conf.GlobalConfigurations;
import org.eclipse.ohf.bridge.conf.SessionContext;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.ApplicationAndFacilityProperties;
import org.eclipse.ohf.bridge.conf.rhio.IheUri;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.hl7v2.core.definitions.formats.PrivateFormat;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.common.mllp.MLLPDestination;
import org.eclipse.ohf.ihe.common.mllp.SecureTCPPort;
import org.eclipse.ohf.ihe.common.mllp.TCPPort;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumer;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumer;
import org.eclipse.ohf.ihe.pix.source.PixSource;

public class PixPdqResources
extends AbstractRhioDedicatedResources {
    static final Logger mLogger = Logger.getLogger(PixPdqResources.class);
    private PdqConsumer mPdqConsumer;
    private PixConsumer mHl7PixConsumer;
    private PixSource mPixSourcePixDestination;
    private PixSource mPixSourceXdsDestination;
    private GlobalConfigurations mConfigurations;

    public PixPdqResources(RhioConfig pRhioConfig, GlobalConfigurations pConfigurations) {
        super(pRhioConfig);
        this.mConfigurations = pConfigurations;
    }

    private void checkResourseAvaliability() throws UnavailableResourcesException {
        if (this.getRhioConfiguration().getPixConfig().getDefaultPixUri() == null) {
            throw new UnavailableResourcesException("RESOURCE DOS NOT EXIST: PIX server not configured for this RHIO [" + this.getRhioConfiguration().getName() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdqConsumer getPdqConsumer() throws ClientException, HL7V2Exception, URISyntaxException, UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PdqConsumer getPdqConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        this.checkResourseAvaliability();
        IheUri queryURI = this.getQueryUri();
        if (queryURI == null) {
            throw new UnavailableResourcesException("RESOURCE DOS NOT EXIST: PIX server not configured for this RHIO [" + this.getRhioConfiguration().getName() + "]");
        }
        if (this.mPdqConsumer != null) {
            return this.mPdqConsumer;
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (this.mPdqConsumer != null) {
                return this.mPdqConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating PdqConsumer");
            }
            URI pixUri = new URI(queryURI.defaultUri());
            TCPPort destination = this.getTcpPort(pixUri.getScheme());
            char[] sHex = new char[]{'\u000b'};
            char[] eHex = new char[]{'\u001c', '\r'};
            destination.setBufferSize(2000);
            destination.setEndHex(eHex);
            destination.setStartHex(sHex);
            destination.setTcpHost(pixUri.getHost());
            destination.setTcpPort(pixUri.getPort());
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Using host:" + pixUri.getHost() + " port:" + pixUri.getPort()));
            }
            MLLPDestination mllp = new MLLPDestination(destination);
            this.mPdqConsumer = new PdqConsumer(this.getHL7DefinitionsPrivateFormat());
            this.mPdqConsumer.setMaxVerifyEvent(3);
            this.mPdqConsumer.setMLLPDestination(mllp);
            return this.mPdqConsumer;
        }
    }

    private TCPPort getTcpPort(String pScheme) {
        if ("MLLPS".equalsIgnoreCase(pScheme)) {
            return new SecureTCPPort();
        }
        if ("MLLP".equalsIgnoreCase(pScheme)) {
            return new TCPPort();
        }
        throw new IllegalArgumentException("the scheme is unknown (should be either mllp or mllps) it is: " + pScheme);
    }

    private IheUri getQueryUri() {
        IheUri queryURI = this.getRhioConfiguration().getPixConfig().getQueryPixUri();
        if (queryURI == null) {
            queryURI = this.getRhioConfiguration().getPixConfig().getDefaultPixUri();
        }
        return queryURI;
    }

    private PrivateFormat getHL7DefinitionsPrivateFormat() throws HL7V2Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("using HL7DefinitionsFile = " + this.mConfigurations.getHL7DefinitionsFile().getAbsolutePath()));
        }
        PrivateFormat javaStream = new PrivateFormat(this.mConfigurations.getHL7DefinitionsFile());
        return javaStream;
    }

    private MLLPDestination createMLLPDestination(URI pUri) throws URISyntaxException {
        MLLPDestination mllpDestination = new MLLPDestination(pUri);
        return mllpDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixConsumer getHl7PixConsumer() throws ClientException, HL7V2Exception, FileNotFoundException, URISyntaxException, UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PixConsumer getHl7PixConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        this.checkResourseAvaliability();
        IheUri queryURI = this.getQueryUri();
        if (queryURI == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("No PIX configured for " + this.getRhioConfiguration()));
            }
            return null;
        }
        if (this.mHl7PixConsumer != null) {
            return this.mHl7PixConsumer;
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (this.mHl7PixConsumer != null) {
                return this.mHl7PixConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating PixConsumer");
            }
            PixConsumer pixConsumer = new PixConsumer(this.getHL7DefinitionsPrivateFormat());
            pixConsumer.setMaxVerifyEvent(3);
            pixConsumer.setMLLPDestination(this.createMLLPDestination(new URI(queryURI.defaultUri())));
            this.mHl7PixConsumer = pixConsumer;
        }
        return this.mHl7PixConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixSource getPixSourcePixDestination() throws ClientException, HL7V2Exception, URISyntaxException, UnavailableResourcesException {
        this.checkResourseAvaliability();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PixSource getPixSourcePixDestination()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mPixSourcePixDestination != null) {
            return this.mPixSourcePixDestination;
        }
        IheUri uri = this.getRhioConfiguration().getPixConfig().getDefaultPixUri();
        if (uri == null) {
            uri = this.getRhioConfiguration().getPixConfig().getDefaultPixUri();
        }
        if (uri == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("No PIX configured for " + this.getRhioConfiguration()));
            }
            return null;
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (this.mPixSourcePixDestination != null) {
                return this.mPixSourcePixDestination;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating PixSource");
            }
            PixSource source = new PixSource(this.getHL7DefinitionsPrivateFormat());
            source.setMLLPDestination(this.createMLLPDestination(new URI(uri.defaultUri())));
            source.setMaxVerifyEvent(3);
            this.mPixSourcePixDestination = source;
        }
        return this.mPixSourcePixDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixSource getPixSourceXdsDestination() throws ClientException, HL7V2Exception, URISyntaxException, UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PixSource getPixSourceXdsDestination()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        this.checkResourseAvaliability();
        if (this.mPixSourceXdsDestination != null) {
            return this.mPixSourceXdsDestination;
        }
        if (this.getRhioConfiguration().getXdsRegistryConfig().getMllp() == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("No Registry MLLP configured for " + this.getRhioConfiguration()));
            }
            return null;
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (this.mPixSourceXdsDestination != null) {
                return this.mPixSourceXdsDestination;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating new PixSource");
            }
            PixSource source = new PixSource(this.getHL7DefinitionsPrivateFormat());
            source.setMLLPDestination(this.createMLLPDestination(new URI(this.getRhioConfiguration().getXdsRegistryConfig().getMllp().defaultUri())));
            source.setMaxVerifyEvent(3);
            this.mPixSourceXdsDestination = source;
        }
        return this.mPixSourceXdsDestination;
    }

    public ApplicationAndFacilityProperties getPixConsumerProperties() throws BridgeException {
        ApplicationAndFacilityProperties properties = this.createSessionApplicationAndFacilityProperties();
        if (Utils.isEmptyOrNull((String)properties.getFacility())) {
            properties.setFacility(this.getRhioConfiguration().getPixConfig().getPixConsumerProperties().getFacility());
        }
        if (Utils.isEmptyOrNull((String)properties.getApplication())) {
            properties.setApplication(this.getRhioConfiguration().getPixConfig().getPixConsumerProperties().getApplication());
        }
        return properties;
    }

    public ApplicationAndFacilityProperties getPixSourceProperties() throws BridgeException {
        ApplicationAndFacilityProperties properties = this.createSessionApplicationAndFacilityProperties();
        if (Utils.isEmptyOrNull((String)properties.getFacility())) {
            properties.setFacility(this.getRhioConfiguration().getPixConfig().getPixSourceProperties().getFacility());
        }
        if (Utils.isEmptyOrNull((String)properties.getApplication())) {
            properties.setApplication(this.getRhioConfiguration().getPixConfig().getPixSourceProperties().getApplication());
        }
        return properties;
    }

    public ApplicationAndFacilityProperties getPdqConsumerProperties() throws BridgeException {
        ApplicationAndFacilityProperties properties = this.createSessionApplicationAndFacilityProperties();
        if (Utils.isEmptyOrNull((String)properties.getFacility())) {
            properties.setFacility(this.getRhioConfiguration().getPixConfig().getPdqConsumerProperties().getFacility());
        }
        if (Utils.isEmptyOrNull((String)properties.getApplication())) {
            properties.setApplication(this.getRhioConfiguration().getPixConfig().getPdqConsumerProperties().getApplication());
        }
        return properties;
    }

    private ApplicationAndFacilityProperties createSessionApplicationAndFacilityProperties() {
        ApplicationAndFacilityProperties properties = new ApplicationAndFacilityProperties();
        SessionContext session = TransactionContext.instant().getSessionContext();
        properties.setFacility(session.getUserFacilityName());
        properties.setApplication(session.getUserApplicationName());
        return properties;
    }

    public DefaultMessageQueryName getDefaultMessageQueryName() {
        return this.getRhioConfiguration().getPixConfig().getDefaultMessageQueryName();
    }
}

