/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.hl7v2.message;

import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.HL7_Constants;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;

public abstract class PixPdqMessage
extends Message
implements HL7_Constants {
    private static Logger logger = Logger.getLogger(PixPdqMessage.class);

    public String[] getSendingApplication() throws PixPdqMessageException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSH", 1);
        int fieldIndex = 2;
        return PixPdqMessageUtilities.getFieldComponents(seg, fieldIndex);
    }

    public void changeDefaultSendingApplication(String namespaceId, String universalId, String universalIdType) throws PixPdqMessageException {
        if (!PixPdqMessageUtilities.isHDParamValid(namespaceId, universalId, universalIdType)) {
            throw new PixPdqMessageException("PixPdqMessage: changeDefaultSendingApplication - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
        }
        this.setField("MSH-3-1", namespaceId);
        this.setField("MSH-3-2", universalId);
        this.setField("MSH-3-3", universalIdType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixPdqMessage: changeDefaultSendingApplication ");
        }
    }

    public String[] getSendingFacility() throws PixPdqMessageException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSH", 1);
        int fieldIndex = 3;
        return PixPdqMessageUtilities.getFieldComponents(seg, fieldIndex);
    }

    public void changeDefaultSendingFacility(String namespaceId, String universalId, String universalIdType) throws PixPdqMessageException {
        if (!PixPdqMessageUtilities.isHDParamValid(namespaceId, universalId, universalIdType)) {
            throw new PixPdqMessageException("PixPdqMessage: changeDefaultSendingFacility - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
        }
        this.setField("MSH-4-1", namespaceId);
        this.setField("MSH-4-2", universalId);
        this.setField("MSH-4-3", universalIdType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixPdqMessage: changeDefaultSendingFacility ");
        }
    }

    public String[] getReceivingApplication() throws PixPdqMessageException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSH", 1);
        int fieldIndex = 4;
        return PixPdqMessageUtilities.getFieldComponents(seg, fieldIndex);
    }

    public void changeDefaultReceivingApplication(String namespaceId, String universalId, String universalIdType) throws PixPdqMessageException {
        if (!PixPdqMessageUtilities.isHDParamValid(namespaceId, universalId, universalIdType)) {
            throw new PixPdqMessageException("PixPdqMessage: changeDefaultReceivingApplication - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
        }
        this.setField("MSH-5-1", namespaceId);
        this.setField("MSH-5-2", universalId);
        this.setField("MSH-5-3", universalIdType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixPdqMessage: changeDefaultReceivingApplication ");
        }
    }

    public String[] getReceivingFacility() throws PixPdqMessageException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSH", 1);
        int fieldIndex = 5;
        return PixPdqMessageUtilities.getFieldComponents(seg, fieldIndex);
    }

    public void changeDefaultRecievingFacility(String namespaceId, String universalId, String universalIdType) throws PixPdqMessageException {
        if (!PixPdqMessageUtilities.isHDParamValid(namespaceId, universalId, universalIdType)) {
            throw new PixPdqMessageException("PixPdqMessage: changeDefaultReceivingFacility - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
        }
        this.setField("MSH-6-1", namespaceId);
        this.setField("MSH-6-2", universalId);
        this.setField("MSH-6-3", universalIdType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixPdqMessage: changeDefaultRecievingFacility ");
        }
    }

    public String getMessageControlID() throws PixPdqMessageException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSH", 1);
        int fieldIndex = 9;
        try {
            return seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixPdqMessageException(e);
        }
    }

    public void changeDefaultControlId(String controlId) throws PixPdqMessageException {
        if (controlId == null || controlId.length() <= 0) {
            throw new PixPdqMessageException("PixPdqMessage: changeDefaultControlId - " + controlId + " invalid parameter ");
        }
        this.setField("MSH-10", controlId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixPdqMessage: changeDefaultControlId ");
        }
    }

    public String[] getProcessEnvironment() throws PixPdqMessageException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSH", 1);
        int fieldIndex = 10;
        return PixPdqMessageUtilities.getFieldComponents(seg, fieldIndex);
    }

    public void changeDefaultProcessEnvironment(String environment) throws PixPdqMessageException {
        if (environment == null || environment.length() <= 0) {
            throw new PixPdqMessageException("PixPdqMessage: changeDefaultProcessEnvironment - " + environment + " invalid parameter ");
        }
        this.setField("MSH-11-1", environment);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixPdqMessage: changeDefaultProcessEnvironment ");
        }
    }

    public String[] getCharacterSet() throws PixPdqMessageException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSH", 1);
        int fieldIndex = 17;
        try {
            int repeats = PixPdqMessageUtilities.getRepeatCount(seg, fieldIndex + 1);
            Field fld = seg.getFields().item(fieldIndex);
            String[] retArray = new String[repeats];
            int i = 0;
            while (i < repeats) {
                retArray[i] = fld.getRepeat(i).getComponents().item(0).getAsString();
                ++i;
            }
            return retArray;
        }
        catch (HL7V2Exception e) {
            throw new PixPdqMessageException(e);
        }
    }

    public void changeDefaultCharacterSet(String charSet) throws PixPdqMessageException {
        if (charSet == null || charSet.length() <= 0) {
            throw new PixPdqMessageException("PixPdqMessage: changeDefaultCharacterSet - " + charSet + " invalid parameter ");
        }
        this.setField("MSH-18-1", charSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixPdqMessage: changeDefaultCharacterSet ");
        }
    }

    public void setField(String path, String data) throws PixPdqMessageException {
        try {
            StringTokenizer stok = new StringTokenizer(path, "-");
            String code = stok.nextToken();
            Segment seg = this.getSegments().getByCodeAndIndex(code, 1);
            if (seg == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("PixMsgADT: setField segment " + code + " was not found in message."));
                }
                throw new PixPdqMessageException("PixMsgADT: setField segment " + code + " was not found in message.");
            }
            String fieldIndexBase1 = stok.nextToken();
            int fieldIndex = Integer.parseInt(fieldIndexBase1) - 1;
            Field fld = seg.forceField(fieldIndex);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PixMsgADT: setField " + path + " : " + code + "-" + fieldIndexBase1));
            }
            if (fld.getDefinition() == null || !fld.getDefinition().isRepeatable()) {
                this.forceElement(path).setAsString(data);
            } else {
                boolean done = false;
                String repeatPath = "1";
                if (stok.hasMoreTokens()) {
                    int len = code.length() + fieldIndexBase1.length() + 2;
                    repeatPath = path.substring(len);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  path: " + path + " repeatPath: " + repeatPath));
                }
                int i = 0;
                while (i < fld.getNonEmptyCount()) {
                    String currentValue = null;
                    currentValue = fld.getRepeat(i).forceElement(repeatPath).getAsString();
                    if (currentValue == null || currentValue.length() <= 0) {
                        fld.getRepeat(i).forceElement(repeatPath).setAsString(data);
                        done = true;
                    }
                    ++i;
                }
                if (!done) {
                    fld.addRepeat(true).forceElement(repeatPath).setAsString(data);
                }
            }
        }
        catch (HL7V2Exception e) {
            logger.error((Object)("PixMsgADT: setField - " + path + " " + data + " caused exception " + e.getLocalizedMessage()));
            throw new PixPdqMessageException(e);
        }
    }

    public void setNonNullElement(String alias, String msgDefault) throws PixPdqMessageException {
        try {
            if (this.getElement(alias).isNull()) {
                this.setField(alias, msgDefault);
            }
        }
        catch (HL7V2Exception e) {
            throw new PixPdqMessageException(e);
        }
    }
}

