/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pdq.consumer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.definitions.formats.PrivateFormat;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.HL7_Constants;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.Client;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerQuery;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerResponse;

public class PdqConsumer
extends Client
implements HL7_Constants {
    private static Logger logger = Logger.getLogger(PdqConsumer.class);

    public PdqConsumer() throws ClientException {
    }

    public PdqConsumer(PrivateFormat javaStream) throws ClientException {
        super(javaStream);
    }

    public PdqConsumer(PrivateFormat javaStream, InputStream conformanceProfile) throws ClientException {
        super(javaStream, conformanceProfile);
    }

    public PdqConsumer(String msAccessFile) throws ClientException {
        super(msAccessFile);
    }

    public PdqConsumer(String msAccessFile, InputStream conformanceProfile) throws ClientException {
        super(msAccessFile, conformanceProfile);
    }

    public PdqConsumerQuery createQuery() throws PdqConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: createQuery - Entry ");
        }
        PdqConsumerQuery query = new PdqConsumerQuery(this.getMessageManager(), this.getCPProfile());
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = query.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: createQuery - Exit controlId: " + controlId));
        }
        return query;
    }

    public String sendQuery(String rawHL7, boolean verify, String auditUser) throws PdqConsumerException {
        String queryResponse = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: sendQuery - Entry ");
        }
        try {
            queryResponse = this.sendHL7(rawHL7, verify, auditUser, "OHF_PdqConsumer");
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: sendQuery - Exit ");
        }
        return queryResponse;
    }

    public Message sendQuery(Message msg, boolean verify, String auditUser) throws PdqConsumerException {
        Message queryResponse = null;
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: sendQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        try {
            queryResponse = this.sendMsg(msg, verify, auditUser, "OHF_PdqConsumer");
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PdqConsumer: sendQuery - Exit controlId: " + controlId));
        }
        return queryResponse;
    }

    public PdqConsumerResponse sendQuery(PdqConsumerQuery msg, boolean verify, String auditUser) throws PdqConsumerException {
        String hl7;
        Message msgResponse = null;
        PdqConsumerResponse queryResponse = new PdqConsumerResponse(this.getMessageManager());
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: sendQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        try {
            msgResponse = this.sendMsg((Message)msg, verify, auditUser, "OHF_PdqConsumer");
            hl7 = PixPdqMessageUtilities.msgToString((Message)msgResponse);
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PdqConsumerException(e);
        }
        queryResponse = new PdqConsumerResponse(MessageManager.getFactory());
        ByteArrayInputStream inStream = new ByteArrayInputStream(hl7.getBytes());
        ParsingOptions pOptions = new ParsingOptions();
        try {
            pOptions.setFormat(1);
            if (hl7.compareTo("") == 0) {
                return queryResponse;
            }
            MessageManager.getFactory().load((InputStream)inStream, (Message)queryResponse, pOptions);
            queryResponse.init();
        }
        catch (HL7V2Exception e) {
            logger.error((Object)"PdqConsumer: sendQuery - createQueryResponse HL7V2Exception ", (Throwable)e);
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PdqConsumer: sendQuery - Exit controlId: " + controlId));
        }
        return queryResponse;
    }
}

