/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.transform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.xds.metadata.DocumentRoot;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.SubmissionSetType;
import org.eclipse.ohf.ihe.xds.metadata.transform.MetadataTransformationException;
import org.eclipse.ohf.ihe.xds.metadata.transform.SubmissionSetTransformer;
import org.eclipse.ohf.ihe.xds.metadata.util.MetadataResourceFactoryImpl;

public class ByteArraySubmissionSetTransformer
implements SubmissionSetTransformer {
    public static final String DESCRIPTOR = "BYTE_SS_XFRMR";
    private static final Logger logger = Logger.getLogger(ByteArraySubmissionSetTransformer.class);
    private byte[] submissionSetByteArray;

    public byte[] getSubmissionSetByteArray() {
        return this.submissionSetByteArray;
    }

    public void transform(SubmissionSetType subSet) throws MetadataTransformationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Composing DocumentRoot");
        }
        DocumentRoot root = MetadataFactory.eINSTANCE.createDocumentRoot();
        root.setSubmissionSet(subSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading MetadataPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Saving Resources.");
        }
        Resource resources = new MetadataResourceFactoryImpl().createResource(URI.createURI((String)"urn:org:eclipse:ohf:ihe:xds:metadata"));
        resources.getContents().add((Object)root);
        ByteArrayOutputStream bos = null;
        try {
            try {
                bos = new ByteArrayOutputStream();
                resources.save((OutputStream)bos, null);
                this.submissionSetByteArray = bos.toByteArray();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Saved DocumentEntry metadata to byte array");
                }
            }
            finally {
                bos.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"IOException while saving Resources to byte array.", (Throwable)e);
            throw new MetadataTransformationException("IOException while saving Resources to byte array.", e);
        }
    }
}

