/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.transform;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExternalIdentifierType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RimFactory;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.SlotType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.StatusType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ValueListType;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.transform.FolderTransformer;
import org.eclipse.ohf.ihe.xds.metadata.transform.MetadataTransformationException;

public class EbXML_2_1FolderTransformer
implements FolderTransformer {
    public static final String DESCRIPTOR = "EBXML_FOL_XFRMR";
    private static final Logger logger = Logger.getLogger(EbXML_2_1FolderTransformer.class);
    private RegistryPackageType folderData = null;
    private AssociationType1[] documentsInFolder = null;

    public AssociationType1[] getAssociatedDocuments() {
        return this.documentsInFolder;
    }

    public RegistryPackageType getRegistryPackage() {
        return this.folderData;
    }

    public void transform(FolderType folder) throws MetadataTransformationException {
        if (folder == null) {
            logger.error((Object)"Folder is null, cannot execute transformation.");
            throw new MetadataTransformationException("Folder is null, cannot execute transformation.");
        }
        this.folderData = RimFactory.eINSTANCE.createRegistryPackageType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting attributes on the Registry Package.");
        }
        this.setRegistryPackageAttributes(folder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Name on the Registry Package.");
        }
        this.folderData.setName(EbXML_2_1FolderTransformer.copy(folder.getTitle()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Description on the Registry Package.");
        }
        this.folderData.setDescription(EbXML_2_1FolderTransformer.copy(folder.getComments()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Name on the Registry Package.");
        }
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType s = RimFactory.eINSTANCE.createInternationalStringType();
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType s2 = RimFactory.eINSTANCE.createLocalizedStringType();
        s2.setValue("FOLDER");
        s.getLocalizedString().add((Object)s2);
        this.folderData.setName(s);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Slots on the Registry Package.");
        }
        this.setRegistryPackageSlots(folder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Classifications on the Registry Package.");
        }
        this.setRegistryPackageClassifications(folder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting External Identifiers on the Registry Package.");
        }
        this.setRegistryPackageExternalIdentifiers(this.folderData, folder);
        if (folder.getAssociatedDocuments() != null && !folder.getAssociatedDocuments().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting associated documents to the AssociationType1[].");
            }
            this.setAssociatedDocuments(folder);
        }
    }

    private void setRegistryPackageAttributes(FolderType folder) {
        this.folderData.setId(folder.getEntryUUID());
        this.folderData.setObjectType("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2");
        if (folder.isSetAvailabilityStatus()) {
            if (folder.getAvailabilityStatus().equals(AvailabilityStatusType.APPROVED_LITERAL)) {
                this.folderData.setStatus(StatusType.APPROVED_LITERAL);
            } else if (folder.getAvailabilityStatus().equals(AvailabilityStatusType.DEPRECATED_LITERAL)) {
                this.folderData.setStatus(StatusType.DEPRECATED_LITERAL);
            } else if (folder.getAvailabilityStatus().equals(AvailabilityStatusType.SUBMITTED_LITERAL)) {
                this.folderData.setStatus(StatusType.SUBMITTED_LITERAL);
            } else if (folder.getAvailabilityStatus().equals(AvailabilityStatusType.WITHDRAWN_LITERAL)) {
                this.folderData.setStatus(StatusType.WITHDRAWN_LITERAL);
            }
        }
    }

    private void setRegistryPackageSlots(FolderType folder) {
        EList slots = this.folderData.getSlot();
        if (folder.getLastUpdateTime() != null) {
            SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
            ValueListType list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("lastUpdateTime");
            slot.getValueList().getValue().add((Object)folder.getLastUpdateTime());
            slots.add((Object)slot);
        }
    }

    private void setRegistryPackageClassifications(FolderType folder) {
        EList folderCodes = folder.getCode();
        if (folderCodes == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Folder Code list contains no codes.");
            }
            return;
        }
        int i = 0;
        while (i < folderCodes.size()) {
            ClassificationType c = RimFactory.eINSTANCE.createClassificationType();
            CodedMetadataType cm = (CodedMetadataType)folderCodes.get(i);
            c.setClassificationScheme("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5");
            c.setNodeRepresentation(cm.getCode());
            c.setClassifiedObject(folder.getEntryUUID());
            c.setName(EbXML_2_1FolderTransformer.copy(cm.getDisplayName()));
            if (cm.getSchemeName() != null) {
                EList slots = c.getSlot();
                SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
                ValueListType list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)cm.getSchemeName());
                slots.add((Object)slot);
            }
            this.folderData.getClassification().add((Object)c);
            ++i;
        }
    }

    private void setRegistryPackageExternalIdentifiers(RegistryPackageType folderData, FolderType folder) {
        EList externalIdentifiers = folderData.getExternalIdentifier();
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType idName = RimFactory.eINSTANCE.createLocalizedStringType();
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType exIDName = RimFactory.eINSTANCE.createInternationalStringType();
        ExternalIdentifierType exID = RimFactory.eINSTANCE.createExternalIdentifierType();
        if (folder.getPatientId() != null) {
            exID.setValue(HL7V2MessageFormat.toMessageString((CX)folder.getPatientId(), (char)'^', (char)'&'));
            idName.setValue("XDSFolder.patientId");
            exIDName.getLocalizedString().add((Object)idName);
            exID.setName(exIDName);
            exID.setIdentificationScheme("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a");
            externalIdentifiers.add((Object)exID);
        }
        if (folder.getUniqueId() != null) {
            exID = RimFactory.eINSTANCE.createExternalIdentifierType();
            exID.setValue(folder.getUniqueId());
            idName.setValue("XDSFolder.uniqueId");
            exIDName.getLocalizedString().add((Object)idName);
            exID.setName(exIDName);
            exID.setIdentificationScheme("urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a");
            externalIdentifiers.add((Object)exID);
        }
    }

    private void setAssociatedDocuments(FolderType folder) {
        this.documentsInFolder = new AssociationType1[folder.getAssociatedDocuments().size()];
        int i = 0;
        while (i < folder.getAssociatedDocuments().size()) {
            this.documentsInFolder[i] = RimFactory.eINSTANCE.createAssociationType1();
            this.documentsInFolder[i].setTargetObject((String)folder.getAssociatedDocuments().get(i));
            this.documentsInFolder[i].setAssociationType("HasMember");
            this.documentsInFolder[i].setSourceObject(folder.getEntryUUID());
            ++i;
        }
    }

    private static org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType copy(InternationalStringType ist) {
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType result = RimFactory.eINSTANCE.createInternationalStringType();
        if (ist != null) {
            Iterator i = ist.getLocalizedString().iterator();
            while (i.hasNext()) {
                org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType lst = RimFactory.eINSTANCE.createLocalizedStringType();
                LocalizedStringType original = (LocalizedStringType)i.next();
                lst.setCharset(original.getCharset());
                lst.setLang(original.getLang());
                lst.setValue(original.getValue());
                result.getLocalizedString().add((Object)lst);
            }
        }
        return result;
    }
}

