/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.formats;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPItemXML;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPCell;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CPCellXML
extends CPItemXML {
    public CPCellXML(CPCell cell) {
        super(cell);
    }

    private CPCell cell() {
        return (CPCell)this.element;
    }

    public void start(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        this.cell().setName(attributes.getValue("Name"));
        this.cell().setDataType(attributes.getValue("Datatype"));
        this.cell().setLength(this.readLength(attributes.getValue("Length")));
        this.cell().setTable(attributes.getValue("Table"));
        this.cell().setFixedValue(attributes.getValue("ConstantValue"));
        super.start(namespace, name, defaultNamespace, attributes);
    }

    public XMLObjectParser startElement(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        if (name.equals("DataValues")) {
            this.cell().addDataValue(attributes.getValue("ExValue"));
            return null;
        }
        return super.startElement(namespace, name, defaultNamespace, attributes);
    }

    private int readLength(String value) throws SAXException {
        if (value == null || value.equals("") || value.equals("*")) {
            return -1;
        }
        if (StringUtils.isNumeric((String)value)) {
            return Integer.parseInt(value);
        }
        throw new SAXException("illegal value \"" + value + "\" for Length at " + this.getPath());
    }
}

