/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.formats;

import org.eclipse.ohf.hl7v2.core.conformance.formats.CPDynamicDefinitionXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPElementXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPMetaDataXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPStaticDefinitionReferenceParser;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPStaticDefinitionXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPUseCaseXML;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.eclipse.ohf.utilities.xml.XMLStringParser;
import org.eclipse.ohf.utilities.xml.XMLStringsParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CPConformanceProfileStarterParser
extends CPElementXML {
    public CPConformanceProfileStarterParser(CPConformanceProfile profile) {
        super(profile);
    }

    private CPConformanceProfile profile() {
        return (CPConformanceProfile)this.element;
    }

    public void start(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        if (namespace != null && !namespace.equals("") && name.equals("HL7v2xConformanceProfile")) {
            throw new SAXException("This is not a conformance profile");
        }
        this.profile().clear();
        this.profile().setHl7Version(attributes.getValue("HL7Version"));
        this.profile().setProfileType(this.readProfileType(attributes.getValue("ProfileType")));
        this.profile().setIdentifier(attributes.getValue("Identifier"));
        super.start(namespace, name, defaultNamespace, attributes);
    }

    private int readProfileType(String value) throws SAXException {
        if (value == null || value.equals("") || value.equals("HL7")) {
            return 1;
        }
        if (value.equals("Implementation")) {
            return 3;
        }
        if (value.equals("Constrainable")) {
            return 2;
        }
        throw new SAXException("unexpected value \"" + value + "\" for ProfileType");
    }

    public XMLObjectParser startElement(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        if (name.equals("HL7v2xConformanceProfile")) {
            return null;
        }
        if (name.equals("MetaData")) {
            return new CPMetaDataXML(this.profile().getMetaData());
        }
        if (name.equals("ImpNote")) {
            return new XMLStringParser();
        }
        if (name.equals("UseCase")) {
            return new CPUseCaseXML(this.profile().getUseCase());
        }
        if (name.equals("Encodings")) {
            return new XMLStringsParser("", "Encoding");
        }
        if (name.equals("DynamicDef")) {
            return new CPDynamicDefinitionXML(this.profile().getInteractions().addInteraction().getDynamicDefinition());
        }
        if (name.equals("HL7v2xStaticDef")) {
            return new CPStaticDefinitionXML(this.profile().getInteractions().itemInteraction(this.profile().getInteractions().size() - 1).getStaticDefinition());
        }
        if (name.equals("HL7v2xStaticDefRef")) {
            return new CPStaticDefinitionReferenceParser(this.profile().getInteractions().itemInteraction(this.profile().getInteractions().size() - 1).getStaticDefinition());
        }
        return super.startElement(namespace, name, defaultNamespace, attributes);
    }

    public void endChild(XMLObjectParser child) throws SAXException {
        if (child.getName().equals("ImpNote")) {
            this.profile().setImplementationNote(((XMLStringParser)child).getContent());
        } else if (child.getName().equals("Encodings")) {
            this.profile().setEncodings(((XMLStringsParser)child).getContent());
        } else {
            super.endChild(child);
        }
    }
}

