/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.formats;

import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPComponentXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPConformanceProfileStarterParser;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPFieldXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPSegmentGroupXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPSegmentXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPStaticDefinitionXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPTableXML;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentGroup;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTable;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CPDocumentParser
extends XMLObjectParser {
    private CPConformanceProfileStarterParser profileParser = null;
    private CPDocument document;
    private boolean found = false;

    public CPDocumentParser(CPDocument document) {
        this.setDocument(document);
    }

    public void start(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        try {
            this.document.clear();
            if ((namespace == null || namespace.equals("")) && name.equals("HL7v2xConformanceProfile")) {
                CPConformanceProfile profile = new CPConformanceProfile();
                this.profileParser = new CPConformanceProfileStarterParser(profile);
                this.profileParser.start(namespace, name, defaultNamespace, attributes);
                this.document.setDocumentType(1);
                this.document.setHl7Version(VersionDefnList.getVersion(profile.getHl7Version()));
                this.document.setContent(profile);
            } else {
                if (namespace != null && !namespace.equals("") || !name.equals("HL7v2xConformanceDocument")) {
                    throw new SAXException("This is not a static Conformance Profile Document");
                }
                this.document.setHl7Version(VersionDefnList.getVersion(attributes.getValue("HL7Version")));
                this.document.setName(attributes.getValue("Name"));
                this.document.setDerivation(attributes.getValue("Derivation"));
                this.document.setDocumentType(this.readModelType(attributes.getValue("Type")));
            }
        }
        catch (HL7V2Exception e) {
            throw new SAXException((Exception)((Object)e));
        }
        super.start(namespace, name, defaultNamespace, attributes);
    }

    private int readModelType(String value) throws SAXException {
        if (value == null || value.equals("")) {
            throw new SAXException("empty value for ModelType");
        }
        if (value.equals("Message")) {
            return 2;
        }
        if (value.equals("SegmentGroup")) {
            return 3;
        }
        if (value.equals("Segment")) {
            return 4;
        }
        if (value.equals("Field")) {
            return 5;
        }
        if (value.equals("Component")) {
            return 6;
        }
        if (value.equals("Table")) {
            return 7;
        }
        throw new SAXException("unexpected value \"" + value + "\" for ModelType");
    }

    public XMLObjectParser startElement(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        try {
            if (this.profileParser != null) {
                return this.profileParser.startElement(namespace, name, defaultNamespace, attributes);
            }
            if (name.equals("HL7v2xStaticDef")) {
                if (this.document.getDocumentType() != 2) {
                    throw new SAXException("found unexpected message definition");
                }
                CPStaticDefinition message = new CPStaticDefinition(null);
                this.document.setContent(message);
                this.found = true;
                return new CPStaticDefinitionXML(message);
            }
            if (name.equals("SegmentGroup")) {
                if (this.document.getDocumentType() != 3) {
                    throw new SAXException("found unexpected segmentGroup");
                }
                CPSegmentGroup group = new CPSegmentGroup(null);
                this.document.setContent(group);
                this.found = true;
                return new CPSegmentGroupXML(group);
            }
            if (name.equals("Segment")) {
                if (this.document.getDocumentType() != 4) {
                    throw new SAXException("found unexpected segment");
                }
                CPSegment segment = new CPSegment(null);
                this.document.setContent(segment);
                this.found = true;
                return new CPSegmentXML(segment);
            }
            if (name.equals("Field")) {
                if (this.document.getDocumentType() != 5) {
                    throw new SAXException("found unexpected Field");
                }
                CPField field = new CPField(null);
                this.document.setContent(field);
                this.found = true;
                return new CPFieldXML(field);
            }
            if (name.equals("Component")) {
                if (this.document.getDocumentType() != 6) {
                    throw new SAXException("found unexpected Datatype");
                }
                CPComponent component = new CPComponent(null);
                this.document.setContent(component);
                this.found = true;
                return new CPComponentXML(component, true);
            }
            if (name.equals("Table")) {
                if (this.document.getDocumentType() != 7) {
                    throw new SAXException("found unexpected Table");
                }
                CPTable table = new CPTable(null);
                this.document.setContent(table);
                this.found = true;
                return new CPTableXML(table);
            }
            return super.startElement(namespace, name, defaultNamespace, attributes);
        }
        catch (HL7V2Exception e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void endChild(XMLObjectParser child) throws SAXException {
        if (this.profileParser != null) {
            this.profileParser.endChild(child);
        } else if (!this.found) {
            throw new SAXException("no definition content found");
        }
        super.endChild(child);
    }

    public CPDocument getDocument() {
        return this.document;
    }

    public void setDocument(CPDocument document) {
        this.document = document;
    }
}

