/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.formats;

import org.eclipse.ohf.hl7v2.core.conformance.formats.CPDescribedXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPMetaDataXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPSegmentGroupXML;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPSegmentXML;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CPStaticDefinitionXML
extends CPDescribedXML {
    public CPStaticDefinitionXML(CPStaticDefinition definition) {
        super(definition);
        definition.setReferenceOnly(false);
    }

    private CPStaticDefinition definition() {
        return (CPStaticDefinition)this.element;
    }

    public void start(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        this.definition().setMsgType(attributes.getValue("MsgType"));
        this.definition().setEventType(attributes.getValue("EventType"));
        this.definition().setMsgStructId(attributes.getValue("MsgStructID"));
        this.definition().setOrderControl(attributes.getValue("OrderControl"));
        this.definition().setEventDesc(attributes.getValue("EventDesc"));
        this.definition().setIdentifier(attributes.getValue("Identifier"));
        this.definition().setRole(this.readRole(attributes.getValue("Role")));
        super.start(namespace, name, defaultNamespace, attributes);
    }

    private int readRole(String value) throws SAXException {
        if (value == null || value.equals("")) {
            return 2;
        }
        if (value.equals("Sender")) {
            return 2;
        }
        if (value.equals("Receiver")) {
            return 1;
        }
        throw new SAXException("unexpected value \"" + value + "\" for Role");
    }

    public XMLObjectParser startElement(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        if (name.equals("MetaData")) {
            return new CPMetaDataXML(this.definition().getMetaData());
        }
        if (name.equals("Segment")) {
            return new CPSegmentXML(this.definition().getElements().addSegment());
        }
        if (name.equals("SegGroup")) {
            return new CPSegmentGroupXML(this.definition().getElements().addSegmentGroup());
        }
        return super.startElement(namespace, name, defaultNamespace, attributes);
    }
}

