/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPDescribed;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPMetaData;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElements;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPStaticDefinition
extends CPDescribed {
    public static final int ROLE_UNKNOWN = 0;
    public static final int ROLE_RECEIVER = 1;
    public static final int ROLE_SENDER = 2;
    private String eventDesc;
    private String eventType;
    private String identifier;
    private String msgStructId;
    private String msgType;
    private String orderControl;
    private int role;
    private CPMetaData metaData = new CPMetaData(this);
    private boolean referenceOnly;
    private CPSegmentElements elements = new CPSegmentElements(this);

    public CPStaticDefinition(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.msgType = null;
        this.eventType = null;
        this.msgStructId = null;
        this.orderControl = null;
        this.eventDesc = null;
        this.identifier = null;
        this.role = 0;
        if (this.metaData != null) {
            this.metaData.clear();
        }
        if (this.elements != null) {
            this.elements.clear();
        }
    }

    public String getEventDesc() {
        return this.eventDesc;
    }

    public void setEventDesc(String eventDesc) {
        this.eventDesc = eventDesc;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public CPMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(CPMetaData metaData) {
        this.metaData = metaData;
    }

    public String getMsgStructId() {
        return this.msgStructId;
    }

    public void setMsgStructId(String msgStructId) {
        this.msgStructId = msgStructId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getOrderControl() {
        return this.orderControl;
    }

    public void setOrderControl(String orderControl) {
        this.orderControl = orderControl;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public CPSegmentElements getElements() {
        return this.elements;
    }

    public boolean hasMsgStructId() {
        return this.msgStructId != null && !this.msgStructId.equals("");
    }

    public boolean isReferenceOnly() {
        return this.referenceOnly;
    }

    public void setReferenceOnly(boolean referenceOnly) {
        this.referenceOnly = referenceOnly;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{15, 16, 17, 18, 1, 14, 19, 20, 21, 22, 23, 11});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.getMetaData().getProperty(id);
            }
            case 14: {
                return Integer.toString(this.getRole());
            }
            case 19: {
                return this.getMsgType();
            }
            case 20: {
                return this.getEventType();
            }
            case 21: {
                return this.getMsgStructId();
            }
            case 22: {
                return this.getOrderControl();
            }
            case 23: {
                return this.getEventDesc();
            }
            case 11: {
                return this.getIdentifier();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.getMetaData().setProperty(id, value);
                break;
            }
            case 14: {
                this.setRole(Integer.parseInt(value));
                break;
            }
            case 19: {
                this.setMsgType(value);
                break;
            }
            case 20: {
                this.setEventType(value);
                break;
            }
            case 21: {
                this.setMsgStructId(value);
                break;
            }
            case 22: {
                this.setOrderControl(value);
                break;
            }
            case 23: {
                this.setEventDesc(value);
                break;
            }
            case 11: {
                this.setIdentifier(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Message Definition";
    }

    public void defaults() {
        super.defaults();
        this.msgType = null;
        this.eventType = null;
        this.msgStructId = null;
        this.orderControl = null;
        this.eventDesc = null;
        this.identifier = null;
        this.role = 1;
        this.metaData.defaults();
        this.referenceOnly = false;
    }

    public int elementType() {
        return 9;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPStaticDefinition src = (CPStaticDefinition)source;
        this.metaData = src.metaData.cloneMetaData();
        this.metaData.setOwner(this);
        this.elements = src.elements.cloneSegmentElements();
        this.elements.setOwner(this);
        this.msgType = src.msgType;
        this.eventType = src.eventType;
        this.msgStructId = src.msgStructId;
        this.orderControl = src.orderControl;
        this.eventDesc = src.eventDesc;
        this.identifier = src.identifier;
        this.role = src.role;
        this.referenceOnly = src.referenceOnly;
    }

    public CPStaticDefinition cloneStaticDefinition() throws CloneNotSupportedException {
        return (CPStaticDefinition)this.clone();
    }
}

