/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.InputStream;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;
import org.eclipse.ohf.utilities.PreviewStream;

public abstract class Parser
extends Worker {
    private PreviewStream stream;
    private ParsingOptions options = new ParsingOptions();

    public Parser() {
    }

    public Parser(InputStream stream) {
        this.setStream(stream);
    }

    public PreviewStream getStream() throws HL7V2Exception {
        this.condition(this.hasStream(), "no stream", 19);
        return this.stream;
    }

    public void setStream(InputStream stream) {
        PreviewStream st = stream instanceof PreviewStream ? (PreviewStream)stream : new PreviewStream(stream);
        this.stream = st;
    }

    public boolean hasStream() {
        return this.stream != null;
    }

    public abstract void decode(Message var1) throws HL7V2Exception;

    public abstract void decode(Segment var1) throws HL7V2Exception;

    public abstract void decode(Field var1) throws HL7V2Exception;

    public abstract void decode(Component var1) throws HL7V2Exception;

    public ParsingOptions getOptions() {
        return this.options;
    }

    public void setOptions(ParsingOptions options) throws HL7V2Exception {
        this.condition(options != null, "no options", 19);
        this.options = options;
    }
}

