/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.formats.Composer;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Content;
import org.eclipse.ohf.hl7v2.core.message.model.ContentBinary;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentGroup;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.xml.XMLWriter;

public class XMLComposer
extends Composer {
    private static final String V2_XML_NS = "urn:hl7-org:v2xml";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private XMLWriter xml;

    public XMLComposer() {
    }

    public XMLComposer(OutputStream stream) throws HL7V2Exception {
        super(stream);
    }

    protected OutputStreamWriter createWriter(OutputStream stream, String charset) throws HL7V2Exception {
        try {
            this.xml = new XMLWriter(stream, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HL7V2Exception("Illegal encoding method", 19);
        }
        return this.xml;
    }

    public void compose(Message message) throws HL7V2Exception {
        try {
            this.condition(message.getVersion() >= 6, "Unable to encode messages with VersionDefn " + VersionDefnList.display(message.getVersion()) + " in XML", 22);
            this.condition(message.getStructId() != "", "Cannot encode an XML message with no assigned structure (" + VersionDefnList.display(message.getVersion()) + "/" + message.getEvent() + "/" + message.getMessageType() + ")", 22);
            message.getSegments().buildSegmentMap(this.getOptions());
            this.condition(message.getSegments().getMap() != null, "Cannot encode an XML message with no segment map (" + VersionDefnList.display(message.getVersion()) + "/" + message.getEvent() + "/" + message.getMessageType() + ")", 22);
            message.resolveVariableTypes();
            this.xml.start();
            this.xml.defaultNamespace(V2_XML_NS);
            this.xml.namespace(XSI_NS, "xsi");
            this.xml.attribute(XSI_NS, "schemaLocation", "urn:hl7-org:v2xml " + message.getStructId() + ".xsd");
            this.xml.open(V2_XML_NS, message.getStructId());
            this.encodeSegmentGroup(message.getSegments().getMap());
            this.xml.close();
            this.xml.flush();
        }
        catch (OHFException e1) {
            throw new HL7V2Exception(e1, 22);
        }
        catch (Exception e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    private void encodeSegmentGroup(SegmentGroup segmentGroup) throws OHFException, IOException {
        int i = 0;
        while (i < segmentGroup.getChildren().size()) {
            SegmentGroup child = segmentGroup.getChildren().item(i);
            if (child.isGroup()) {
                String name = child.getName();
                if (name.equals("")) {
                    name = "what_is_this_group_called";
                }
                this.xml.open(V2_XML_NS, name);
                this.encodeSegmentGroup(child);
                this.xml.close();
            } else {
                int j = 0;
                while (j < child.getSegments().size()) {
                    this.compose(child.getSegments().item(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    public void compose(Segment segment) throws HL7V2Exception {
        try {
            this.xml.open(V2_XML_NS, segment.getCode());
            this.encodeSegmentContent(segment);
            this.xml.close();
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    private void encodeSegmentContent(Segment segment) throws OHFException {
        int i = 0;
        while (i < segment.getFields().size()) {
            this.encode(segment.getFields().item(i), String.valueOf(segment.getCode()) + "." + Integer.toString(i + 1));
            ++i;
        }
    }

    public void encode(Field field, String name) throws HL7V2Exception {
        try {
            this.encodeCell(field, name);
            if (field.hasRepeats()) {
                int i = 0;
                while (i < field.getRepeats().size()) {
                    this.encodeCell(field.getRepeats().item(i), name);
                    ++i;
                }
            }
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    private void writeCell(String name, String value) throws OHFException, IOException {
        if (value != null && !value.equals("")) {
            this.xml.element(V2_XML_NS, name, value);
        }
    }

    private void encodeCell(Cell cell, String name) throws OHFException, IOException {
        if (cell.hasContent()) {
            if (cell.hasComponents()) {
                String type = "UNK";
                if (cell.getCellType() == 4) {
                    Field field = (Field)cell;
                    if (field.hasSpecifiedDataType()) {
                        type = field.getSpecifiedDataType();
                    } else if (field.getStructure() != null) {
                        type = field.getStructure().getDataTypeCode();
                    }
                } else {
                    Component comp = (Component)cell;
                    if (comp.getDefinition() != null) {
                        type = comp.getDefinition().getDataTypeCode();
                    }
                }
                this.xml.open(V2_XML_NS, name);
                int i = 0;
                while (i < cell.getComponents().size()) {
                    this.encodeCell(cell.getComponents().itemCell(i), String.valueOf(type) + "." + Integer.toString(i + 1));
                    ++i;
                }
                this.xml.close();
            } else if (cell.getNullify()) {
                this.writeCell(name, "\"\"");
            } else if (cell.isSimple()) {
                this.writeCell(name, cell.getRawContent());
            } else {
                this.buildComplexContent(name, cell);
            }
        }
    }

    private void buildComplexContent(String name, Cell cell) throws OHFException, IOException {
        this.xml.open(V2_XML_NS, name);
        int i = 0;
        while (i < cell.getContents().count()) {
            Content content = cell.getContents().item(i);
            if (content.getContentType() == 1) {
                throw new HL7V2Exception("cannot find a null here", 18);
            }
            if (content.getContentType() == 0) {
                this.xml.text(content.getText());
            } else if (content.getContentType() == 2) {
                this.xml.attribute(V2_XML_NS, "V", content.getText());
                this.xml.element(V2_XML_NS, "escape", null);
            } else if (content.getContentType() == 3) {
                this.xml.escapedText(((ContentBinary)content).getXmlText());
            } else {
                throw new HL7V2Exception("unknown content type " + Integer.toString(content.getContentType()), 18);
            }
            ++i;
        }
        this.xml.close();
    }

    public void compose(Field field) throws HL7V2Exception {
        this.encode(field, "UNK.0");
    }

    public void compose(Component component) throws HL7V2Exception {
        try {
            this.encodeCell(component, "UNK.0");
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }
}

