/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Node;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class Component
extends Cell {
    private static final long serialVersionUID = 6640748142441145283L;
    private transient ComponentDefn definition;

    public Component(int cellType, int index) throws HL7V2Exception {
        super(index);
        this.nodeType = cellType;
    }

    public TableDefn getTable() {
        if (this.definition != null) {
            return this.definition.getTable();
        }
        return null;
    }

    public DataTypeDefn getDataType() {
        if (this.definition != null) {
            return this.definition.getDatatype();
        }
        return null;
    }

    public void makeForBuild() throws HL7V2Exception {
        this.condition(this.definition != null, "Definition is not provided", 19);
        StructureDefn struc = this.definition.getStructure();
        if (struc != null && struc.getComponents().size() > 0 && (struc.getComponents().size() > 1 || struc.getComponents().item(0) != this.definition)) {
            int i = 0;
            while (i < struc.getComponents().size()) {
                Component child = this.forceComponent(i);
                child.setDefinition(struc.getComponents().item(i));
                child.makeForBuild();
                ++i;
            }
        }
    }

    public ComponentDefn getDefinition() {
        return this.definition;
    }

    public void setDefinition(ComponentDefn definition) {
        this.definition = definition;
    }

    public Node.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        if (!this.hasOwner()) {
            return new Node.ElementTestResult(this, "", false);
        }
        Node.ElementTestResult result = this.getOwner().testIsElement(name, false);
        if (!result.matches) {
            return new Node.ElementTestResult(this, "", false);
        }
        if (result.tail.equals("")) {
            return new Node.ElementTestResult(this, "", this.index == 1);
        }
        String[] parts = StringUtils.split((String)result.tail, (String)"-", (int)2);
        if (StringUtils.isNumeric((String)parts[0]) && Integer.parseInt(parts[0]) == this.index) {
            if (parts.length == 1) {
                return new Node.ElementTestResult(this, "", true);
            }
            if (!last) {
                return new Node.ElementTestResult(this, parts[1], true);
            }
            boolean ok = true;
            Component cell = this;
            do {
                ok = StringUtils.isNumeric((String)(parts = StringUtils.split((String)parts[1], (String)"-"))[0]) && Integer.parseInt(parts[0]) == 1 && cell.getComponentCount() >= 1;
                cell = ok ? cell.getComponent(0) : null;
            } while (ok && parts.length == 2);
            return new Node.ElementTestResult(this, "", ok);
        }
        return new Node.ElementTestResult(this, "", false);
    }

    protected int getSubComponentType() {
        return 6;
    }
}

