/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.eclipse.ohf.hl7v2.core.message.model.Content;

public class ContentBinary
extends Content {
    private static final long serialVersionUID = 6324319976131884048L;
    private static final int GROW_SIZE = 100;
    private int[] content = new int[100];
    private int capacity = 100;
    private int size = 0;

    public String getText() {
        return "[binary]";
    }

    public int getContentType() {
        return 3;
    }

    public int[] getContent() {
        int[] value = new int[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.content[i];
            ++i;
        }
        return value;
    }

    public void setContent(int[] content) {
        this.content = content;
        this.capacity = this.size = content.length;
    }

    public void add(int b) {
        if (this.size == this.capacity) {
            this.grow();
        }
        this.content[this.size] = b;
        ++this.size;
    }

    private void grow() {
        int old = this.capacity;
        this.capacity += 100;
        int[] temp = new int[this.capacity];
        int i = 0;
        while (i < old) {
            temp[i] = this.content[i];
            ++i;
        }
        this.content = temp;
    }

    public String getHexText() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            sb.append(Integer.toHexString(this.content[i]).toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public String getXmlText() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            sb.append("&#x" + Integer.toHexString(this.content[i]).toUpperCase() + ";");
            ++i;
        }
        return sb.toString();
    }
}

