/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.ohf.hl7v2.core.message.model.Content;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public class ContentList
extends Worker
implements Serializable {
    private static final long serialVersionUID = 4353530769410879638L;
    private Vector items = new Vector();
    private String path;
    private boolean complex;

    public ContentList(boolean complex, String path) {
        this.complex = complex;
        this.path = path;
    }

    public void clear() {
        this.items.clear();
    }

    public Content item(int index) {
        return (Content)this.items.get(index);
    }

    public int count() {
        return this.items.size();
    }

    public void add(Content content) throws HL7V2Exception {
        this.condition(this.complex || this.count() == 0 && content.getContentType() != 2, "Cannot accept complex content at " + this.path, 19);
        this.condition(this.count() == 0 || this.item(0).getContentType() != 1, "cannot add multiple items when existing item is null " + this.path, 19);
        this.condition(this.count() == 0 || content.getContentType() != 1, "cannot add null to multiple items " + this.path, 19);
        this.items.add(content);
    }

    public void insert(Content content, int index) throws HL7V2Exception {
        this.condition(this.complex || this.count() == 0 && content.getContentType() != 2, "Cannot accept complex content " + this.path, 19);
        this.condition(this.count() == 0 || this.item(0).getContentType() != 1, "cannot add multiple items when existing item is null " + this.path, 19);
        this.condition(this.count() == 0 || content.getContentType() != 1, "cannot add null to multiple items " + this.path, 19);
        this.items.insertElementAt(content, index);
    }

    public void remove(int index) throws HL7V2Exception {
        this.items.remove(index);
    }

    public int indexOfItem(Content content) {
        return this.items.indexOf(content);
    }

    public boolean isComplex() {
        return this.complex;
    }
}

