/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.DefinitionManager;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Delimiters;
import org.eclipse.ohf.hl7v2.core.message.model.ModelProvider;
import org.eclipse.ohf.hl7v2.core.message.model.Node;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class Message
extends ModelProvider {
    private static final long serialVersionUID = -82226212705213352L;
    private Delimiters delimiters = new Delimiters();
    private SegmentList segments = new SegmentList(this, true);
    private transient MessageStructureDefn structure = null;
    private String event = "";
    private String messageType = "";
    private String structId = "";
    private String messageId = "";
    private int defaultFormat;

    public Message() {
        this.init();
    }

    public Message(ModelProvider source) throws HL7V2Exception {
        super(source);
        this.init();
    }

    public Message(VersionDefnList models) throws HL7V2Exception {
        super(models);
        this.init();
    }

    private void init() {
        this.nodeType = 2;
    }

    public void clear() {
        this.event = "";
        this.messageType = "";
        this.structId = "";
        this.messageId = "";
        this.delimiters.reset();
        this.segments.clear();
        this.structure = null;
        super.clear();
    }

    public void clearContent() throws HL7V2Exception {
        this.segments.clear();
        this.addMSHFromFields();
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (result) {
            Message other = (Message)obj;
            result = this.equals(other.delimiters, this.delimiters) && this.equals(other.segments, this.segments) && this.equals(other.structure, this.structure) && this.equals(other.event, this.event) && this.equals(other.messageType, this.messageType) && this.equals(other.structId, this.structId) && this.equals(other.messageId, this.messageId) && other.defaultFormat == this.defaultFormat;
        }
        return result;
    }

    private void dropDefinition() {
        this.structure = null;
    }

    private void tryLoadStruct() throws HL7V2Exception {
        EventDefn eventModel;
        if (this.structId != "" && this.event != "" && this.messageType != "" && (eventModel = this.getVersionDefinition().getEvents().itemByName(this.event)) != null) {
            EventMessageDefn message = eventModel.getMessages().itemByMessage(this.messageType);
            if (message != null) {
                this.structId = message.getStructureCode();
            } else {
                message = eventModel.getMessages().itemByReply(this.messageType);
                if (message != null) {
                    this.structId = message.getStructureCode();
                } else if (this.messageType.equals("ACK")) {
                    this.structId = "ACK";
                }
            }
        }
        if (this.structId != "") {
            this.structure = this.getVersionDefinition().getMessageStructures().itemByName(this.structId);
        }
    }

    public int getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setDefaultFormat(int defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public Delimiters getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(Delimiters delimiters) {
        this.delimiters = delimiters;
    }

    public SegmentList getSegments() {
        return this.segments;
    }

    public String getMessageId() throws HL7V2Exception {
        if (!this.messageId.equals("")) {
            return this.messageId;
        }
        Cell cell = this.getElement("MSH-10");
        if (cell != null) {
            return cell.getAsString();
        }
        return null;
    }

    public void setMessageId(String messageId) throws HL7V2Exception {
        if (messageId == null) {
            messageId = "";
        }
        this.messageId = messageId;
        Cell cell = this.getElement("MSH-10");
        if (cell != null) {
            cell.setAsString(messageId);
        }
    }

    public String getEvent() throws HL7V2Exception {
        if (!this.event.equals("")) {
            return this.event;
        }
        Cell cell = this.getElement("MSH-9-2");
        if (cell != null) {
            return cell.getAsString();
        }
        return null;
    }

    public void setEvent(String event) throws HL7V2Exception {
        this.dropDefinition();
        if (event == null) {
            event = "";
        }
        this.event = event;
        if (this.getVersion() > 3) {
            Cell cell = this.getElement("MSH-9-2");
            if (cell != null) {
                cell.setAsString(event);
            }
            this.tryLoadStruct();
        }
    }

    public String getMessageType() throws HL7V2Exception {
        if (!this.messageType.equals("")) {
            return this.messageType;
        }
        Cell cell = this.getElement("MSH-9-1");
        if (cell != null) {
            return cell.getAsString();
        }
        return null;
    }

    public void setMessageType(String messageType) throws HL7V2Exception {
        this.dropDefinition();
        if (messageType == null) {
            messageType = "";
        }
        this.messageType = messageType;
        if (this.getVersion() > 3) {
            Cell cell = this.getElement("MSH-9-1");
            if (cell != null) {
                cell.setAsString(messageType);
            }
            this.tryLoadStruct();
        }
    }

    public String getStructId() throws HL7V2Exception {
        if (!this.structId.equals("")) {
            return this.structId;
        }
        Cell cell = this.getElement("MSH-9-3");
        if (cell != null) {
            return cell.getAsString();
        }
        return null;
    }

    public void setStructId(String structId) throws HL7V2Exception {
        this.dropDefinition();
        if (structId == null) {
            structId = "";
        }
        this.structId = structId;
        Cell cell = this.getElement("MSH-9-3");
        if (cell != null) {
            cell.setAsString(structId);
            this.tryLoadStruct();
        }
    }

    public MessageStructureDefn getStructure() {
        return this.structure;
    }

    public String elementName() {
        return "";
    }

    public Node.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        return new Node.ElementTestResult(this, name, true);
    }

    public Cell getElement(String path) throws HL7V2Exception {
        String[] parts = StringUtils.split((String)path, (String)"-", (int)2);
        Segment segment = this.getSegmentForPath(path, parts);
        if (segment == null) {
            return null;
        }
        return segment.getElement(parts[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Segment getSegmentForPath(String path, String[] parts) throws HL7V2Exception {
        if (parts.length != 2) {
            throw new HL7V2Exception("Illegal element name " + path, 19);
        }
        String code = parts[0];
        int index = 1;
        if (code.length() <= 3) {
            if (code.length() >= 3) return this.segments.getByCodeAndIndex(code, index);
            throw new HL7V2Exception("Illegal element name " + path, 19);
        }
        if (code.length() <= 4) throw new HL7V2Exception("Illegal element name " + path, 19);
        if (code.charAt(3) != ':') throw new HL7V2Exception("Illegal element name " + path, 19);
        if (!StringUtils.isNumeric((String)code.substring(4))) throw new HL7V2Exception("Illegal element name " + path, 19);
        index = Integer.parseInt(code.substring(4));
        code = code.substring(0, 3);
        return this.segments.getByCodeAndIndex(code, index);
    }

    public Cell forceElement(String path) throws HL7V2Exception {
        String[] parts = StringUtils.split((String)path, (String)"-", (int)2);
        Segment segment = this.getSegmentForPath(path, parts);
        if (segment == null) {
            throw new HL7V2Exception("CPSegment not found for " + path, 19);
        }
        return segment.forceElement(parts[1]);
    }

    public void bindToMSH() throws HL7V2Exception {
        Segment segment = this.getSegments().item(0);
        int version = VersionDefnList.getVersion(segment.getElement("12").getAsString());
        this.setVersion(version);
        if (version == 3) {
            this.setMessageType(segment.getElement("9").getAsString());
            this.setEvent("");
        } else {
            this.setMessageType(segment.getElement("9-1").getAsString());
            this.setEvent(segment.getElement("9-2").getAsString());
            if (version >= 6) {
                if (segment.getElement("9-3").getAsString() != "") {
                    this.setStructId(segment.getElement("9-3").getAsString());
                }
                this.tryLoadStruct();
            }
        }
        this.setMessageId(segment.getElement("10").getAsString());
    }

    public Segment addMSHFromFields() throws HL7V2Exception {
        return this.addMSHFromFields(new Date());
    }

    public Segment addMSHFromFields(Date date) throws HL7V2Exception {
        this.condition(this.segments.countByCode("MSH") == 0, "Attempt to add a second MSH to a message", 19);
        Segment segment = this.segments.add("MSH");
        segment.getElement("12").setAsString(VersionDefnList.display(this.getVersion()));
        if (this.getVersion() == 3) {
            segment.getElement("9").setAsString(this.messageType);
        } else {
            segment.getElement("9-1").setAsString(this.messageType);
            segment.getElement("9-2").setAsString(this.event);
            if (this.getVersion() >= 6) {
                this.tryLoadStruct();
                if (this.structId != "") {
                    segment.getElement("9-3").setAsString(this.structId);
                }
            }
        }
        segment.getElement("7").setAsDateTime(date);
        if (this.messageId != "") {
            segment.getElement("10").setAsString(this.messageId);
        }
        return segment;
    }

    public boolean hasStructId() {
        return this.structId != null || !this.structId.equals("");
    }

    public void resolveVariableTypes() throws NumberFormatException, HL7V2Exception {
        int i = 0;
        while (i < this.segments.size()) {
            Segment seg = this.segments.item(i);
            if (seg.getCode().equals("OBX")) {
                String type = seg.getElement("2").getAsString();
                if (type == null || type.equals("")) {
                    type = "ST";
                }
                seg.getFields().item(4).setSpecifiedDataType(type);
            }
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.structure == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.structure.getPath());
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String defn = in.readUTF();
        if (defn.equals("")) {
            this.structure = null;
        } else {
            try {
                this.structure = (MessageStructureDefn)DefinitionManager.getByPath(defn);
            }
            catch (HL7V2Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        in.defaultReadObject();
        this.segments.setOwner(this);
    }
}

