/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.ohf.hl7v2.core.definitions.DefinitionManager;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.model.Node;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public abstract class ModelProvider
extends Node {
    private static final long serialVersionUID = -82226212705213353L;
    protected transient VersionDefnList definitions;
    protected transient VersionDefn definition;

    public ModelProvider() {
    }

    public ModelProvider(VersionDefnList definitions) throws HL7V2Exception {
        this.setDefinitions(definitions);
    }

    public ModelProvider(ModelProvider source) throws HL7V2Exception {
        this.setDefinitions(source.definitions);
        this.definition = source.definition;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (result) {
            ModelProvider other = (ModelProvider)obj;
            result = this.equals(other.definitions, this.definitions) && this.equals(other.definition, this.definition);
        }
        return result;
    }

    public VersionDefnList getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(VersionDefnList definitions) throws HL7V2Exception {
        this.condition(this.definition == null, "Unable to set definitions when a definition is in use", 19);
        this.definitions = definitions;
    }

    public VersionDefn getVersionDefinition() {
        return this.definition;
    }

    public void clear() {
        this.definition = null;
    }

    public int getVersion() throws HL7V2Exception {
        return this.getVersionDefinition().getVersion();
    }

    public void setVersion(int version) throws HL7V2Exception {
        this.condition(VersionDefnList.isValid(version), "must be a valid version", 19);
        if (this.definition == null || this.definition.getVersion() != version) {
            this.condition(this.definitions != null, "No VersionDefnList", 19);
            this.condition(this.definitions.existsByVersion(version), "the definitions don't have this version", 8);
            this.definition = this.definitions.itemByVersion(version);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.definitions == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.definitions.getPath());
        }
        if (this.definition == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.definition.getPath());
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String defn = in.readUTF();
        if (defn.equals("")) {
            this.definitions = null;
        } else {
            try {
                this.definitions = (VersionDefnList)DefinitionManager.getByPath(defn);
            }
            catch (HL7V2Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        defn = in.readUTF();
        if (defn.equals("")) {
            this.definitions = null;
        } else {
            try {
                this.definitions = (VersionDefnList)DefinitionManager.getByPath(defn);
            }
            catch (HL7V2Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        in.defaultReadObject();
    }
}

