/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.message.model.ModelProvider;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public abstract class Node
extends Worker {
    public static final int NODE_TYPE_LIST = 1;
    public static final int NODE_TYPE_MESSAGE = 2;
    public static final int MODE_TYPE_SEGMENT = 3;
    public static final int NODE_TYPE_FIELD = 4;
    public static final int NODE_TYPE_COMPONENT = 5;
    public static final int NODE_TYPE_SUBCOMPONENT = 6;
    private transient Node owner;
    protected int nodeType;

    public Node() {
    }

    public Node(Node owner) {
        this.setOwner(owner);
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public Node getOwner() {
        return this.owner;
    }

    public void setOwner(Node owner) {
        this.owner = owner;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof Node && ((Node)other).nodeType == this.nodeType;
    }

    protected boolean equals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    protected boolean equals(int int1, int int2) {
        return int1 == int2;
    }

    public VersionDefn getVersionDefinition() {
        Node temp = this;
        while (temp != null && !(temp instanceof ModelProvider)) {
            temp = temp.getOwner();
        }
        if (temp == null) {
            return null;
        }
        return temp.getVersionDefinition();
    }

    public abstract void clear() throws HL7V2Exception;

    public abstract void clearContent() throws HL7V2Exception;

    public abstract String elementName() throws HL7V2Exception;

    protected abstract ElementTestResult testIsElement(String var1, boolean var2) throws HL7V2Exception;

    public boolean isElement(String name) throws HL7V2Exception {
        ElementTestResult result = this.testIsElement(name, true);
        return result.matches;
    }

    protected class ElementTestResult {
        protected String tail;
        protected boolean matches;

        protected ElementTestResult(String tail, boolean matches) {
            this.tail = tail;
            this.matches = matches;
        }

        protected ElementTestResult() {
        }
    }
}

