/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import org.eclipse.ohf.hl7v2.core.message.model.Node;
import org.eclipse.ohf.hl7v2.core.message.model.NodeIterator;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class NodeList
extends Node {
    private static final long serialVersionUID = -847186762606356012L;
    private boolean owns;
    private Vector items = new Vector();

    public NodeList(Node owner, boolean owns) {
        super(owner);
        this.owns = owns;
        this.nodeType = 1;
    }

    public void clear() {
        this.items.clear();
    }

    public void clearContent() throws HL7V2Exception {
        int i = 0;
        while (i < this.size()) {
            this.itemNode(i).clearContent();
            ++i;
        }
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = super.equals(obj) && obj instanceof NodeList && this.size() == ((NodeList)obj).size();
        if (result) {
            NodeList other = (NodeList)obj;
            int i = 0;
            while (i < this.size()) {
                result = result && this.itemNode(i).equals(other.itemNode(i));
                ++i;
            }
        }
        return result;
    }

    protected Node itemNode(int index) {
        return (Node)this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    protected void add(Node node) throws HL7V2Exception {
        this.condition(!this.owns || node.getOwner() == null, "add a node to more than one list", 1);
        if (this.owns) {
            node.setOwner(this);
        }
        this.items.add(node);
    }

    protected void insert(Node node, int index) throws HL7V2Exception {
        this.condition(!this.owns || node.getOwner() == null, "add a node to more than one list", 1);
        if (this.owns) {
            node.setOwner(this);
        }
        this.items.insertElementAt(node, index);
    }

    protected void remove(int index) throws HL7V2Exception {
        if (this.owns) {
            this.itemNode(index).setOwner(null);
        }
        this.items.remove(index);
    }

    public int indexOfItem(Node node) {
        return this.items.indexOf(node);
    }

    public String elementName() throws HL7V2Exception {
        if (this.getOwner() != null) {
            return this.getOwner().elementName();
        }
        return "";
    }

    protected Node.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        if (this.hasOwner()) {
            return this.getOwner().testIsElement(name, false);
        }
        return new Node.ElementTestResult("", false);
    }

    public NodeIterator iteratorNode() {
        return this.makeIterator();
    }

    protected NodeIterator makeIterator() {
        return new NodeIterator(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.owns) {
            int i = 0;
            while (i < this.items.size()) {
                this.itemNode(i).setOwner(this);
                ++i;
            }
        }
    }
}

