/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;

public class CPProfileBuilder {
    private VersionDefn version;

    public CPProfileBuilder() {
    }

    public CPProfileBuilder(VersionDefn version) {
        this.setVersion(version);
    }

    public VersionDefn getVersion() {
        return this.version;
    }

    public void setVersion(VersionDefn version) {
        this.version = version;
    }

    public void buildMessage(CPStaticDefinition confMessage, String event, String messageType) {
        confMessage.setMsgType(messageType);
        confMessage.setEventType(event);
        EventDefn eventDefn = this.version.getEvents().itemByName(event);
        if (eventDefn != null) {
            confMessage.setEventDesc(eventDefn.getDescription());
        }
    }

    public void buildSegment(CPSegment confSegment, String code) {
        this.buildSegment(confSegment, this.version.getSegments().itemByName(code));
    }

    public void buildSegment(CPSegment confSegment, SegmentDefn segmentDefn) {
        confSegment.clear();
        confSegment.setName(segmentDefn.getName());
        confSegment.setDescription(segmentDefn.getDescription());
        int i = 0;
        while (i < segmentDefn.getFields().size()) {
            CPField confField = confSegment.getFields().addField();
            this.buildField(confField, segmentDefn.getFields().item(i));
            ++i;
        }
    }

    private void buildField(CPField confField, FieldDefn fieldDefn) {
        confField.setItemNo(Integer.toString(fieldDefn.getDataElementId()));
        if (fieldDefn.isRequired()) {
            confField.setMin(1);
        } else {
            confField.setMin(0);
        }
        if (fieldDefn.isRepeatable()) {
            if (fieldDefn.getRepeatCount() > 0) {
                confField.setMax(fieldDefn.getRepeatCount());
            } else {
                confField.setMax(-1);
            }
        } else {
            confField.setMax(1);
        }
        DataElementDefn defn = fieldDefn.getDataElement();
        if (defn != null) {
            confField.setName(defn.getDescription());
            confField.setDataType(defn.getStructureCode());
            confField.setLength(defn.getLength());
            confField.setTable(Integer.toString(defn.getTableId()));
            confField.setUsage(3);
            confField.setDescription(defn.getDescription());
            StructureDefn struc = defn.getStructure();
            if (struc != null) {
                confField.setDescription(struc.getDescription());
                int i = 0;
                while (i < struc.getComponents().size()) {
                    CPComponent confComp = confField.getComponents().addComponent();
                    this.buildComponent(confComp, struc.getComponents().item(i), true);
                    ++i;
                }
            }
        }
    }

    private void buildComponent(CPComponent confComp, ComponentDefn compDefn, boolean subComponents) {
        confComp.setName(compDefn.getName());
        confComp.setDataType(compDefn.getDataTypeCode());
        confComp.setTable(Integer.toString(compDefn.getTableId()));
        confComp.setUsage(3);
        confComp.setDescription(compDefn.getName());
        StructureDefn struc = compDefn.getStructure();
        if (struc != null) {
            confComp.setDescription(struc.getDescription());
            if (subComponents) {
                int i = 0;
                while (i < struc.getComponents().size()) {
                    CPComponent confSubComp = confComp.getComponents().addComponent();
                    this.buildComponent(confSubComp, struc.getComponents().item(i), true);
                    ++i;
                }
            }
        }
    }
}

