/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.message.ComposingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentGroup;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public class SegmentGroupMapper
extends Worker {
    private ComposingOptions options;
    private Message message;
    private int index;
    private SegmentList segments;

    public SegmentGroupMapper(ComposingOptions options, Message message) {
        this.setOptions(options);
        this.setMessage(message);
    }

    public ComposingOptions getOptions() {
        return this.options;
    }

    public void setOptions(ComposingOptions options) {
        this.options = options;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SegmentGroup buildMap(SegmentGroupDefn definition, boolean optional) throws HL7V2Exception {
        SegmentGroup result = null;
        int loop = 0;
        boolean finished = false;
        boolean found = false;
        while (!finished && loop < definition.getChildren().size()) {
            SegmentGroupDefn child = definition.getChildren().item(loop);
            if (child.getGroupType() == 0) {
                if (this.index < this.segments.size() && this.segments.item(this.index).matches(child.getName())) {
                    result = this.makeGroupExist(definition, result);
                    result.addSegment(this.segments.item(this.index));
                    ++this.index;
                    found = true;
                    if (definition.getGroupType() == 2) {
                        finished = true;
                    } else if (child.isRepeating()) {
                        while (this.index < this.segments.size() && this.segments.item(this.index).matches(child.getName())) {
                            result.addSegment(this.segments.item(this.index));
                            ++this.index;
                        }
                    }
                } else if (!child.isOptional() && definition.getGroupType() != 2) {
                    if (result == null && definition.isOptional()) {
                        finished = true;
                    } else if (optional) {
                        finished = true;
                    } else {
                        if (this.index < this.segments.size()) {
                            throw new HL7V2Exception("The CPSegment '" + child.getName() + "' in the Group '" + definition.getName() + "' was not found but the segment has already been found, instead '" + this.segments.item(this.index).getCode() + "' was found", 1);
                        }
                        if (!this.options.isAllowMappingToFail()) throw new HL7V2Exception("The CPSegment '" + child.getName() + "' in the Group '" + definition.getName() + "' was not found and the message has no more segments", 1);
                        finished = true;
                    }
                }
            } else {
                SegmentGroup map = this.buildMap(child, optional || child.isOptional());
                if (map != null) {
                    result = this.makeGroupExist(definition, result);
                    result.getChildren().add(map);
                    map.setName(child.getName());
                    if (child.isRepeating()) {
                        do {
                            if ((map = this.buildMap(child, true)) == null) continue;
                            result.getChildren().add(map);
                        } while (map != null);
                    } else if (!(definition.isOptional() || child.isOptional() || optional)) {
                        throw new HL7V2Exception("The CPSegment Group '" + child.getName() + "' in the Group '" + definition.getName() + "' was not found", 1);
                    }
                }
            }
            ++loop;
        }
        if (definition.getGroupType() != 2 && result != null && this.options.isOptimisticMapping()) {
            while (this.index < this.segments.size() && this.segments.item(this.index).matches("Z*")) {
                result.addSegment(this.segments.item(this.index));
                ++this.index;
            }
        }
        if (definition.getGroupType() != 2 || found || definition.isOptional()) return result;
        throw new HL7V2Exception("No segments found in the The choice Group " + definition.getName(), 1);
    }

    private SegmentGroup makeGroupExist(SegmentGroupDefn definition, SegmentGroup existing) {
        if (existing != null) {
            return existing;
        }
        return new SegmentGroup(definition.getGroupType() != 0, definition.getName());
    }

    public SegmentGroup build() throws HL7V2Exception {
        this.index = 0;
        this.segments = this.message.getSegments();
        if (this.message.getStructure() == null || this.message.getStructure().getMap() == null) {
            return null;
        }
        SegmentGroup map = this.buildMap(this.message.getStructure().getMap(), false);
        if (this.index < this.segments.size()) {
            throw new HL7V2Exception("The message '" + this.message.getMessageId() + "' contained some segments not included " + "in the message segment list. The First CPSegment is '" + this.segments.item(this.index).getCode() + "' (#" + Integer.toString(this.index) + ")", 1);
        }
        return map;
    }
}

