/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class Statistics {
    private VersionDefnList definitions;
    private VersionDefn defn;

    public int getNodeCount(String version, String messageStructure) throws HL7V2Exception {
        this.defn = this.definitions.itemByVersion(version);
        return this.getNodeCount(this.defn.getMessageStructures().itemByName(messageStructure));
    }

    private int getNodeCount(MessageStructureDefn defn) {
        return this.getNodeCount(defn.getMap());
    }

    private int getNodeCount(SegmentGroupDefn map) {
        if (map.getGroupType() == 0) {
            return this.getNodeCount(this.defn.getSegments().itemByName(map.getName()));
        }
        int result = 1;
        int i = 0;
        while (i < map.getChildren().size()) {
            result += this.getNodeCount(map.getChildren().item(i));
            ++i;
        }
        return result;
    }

    private int getNodeCount(SegmentDefn defn) {
        int result = defn.getFields().size();
        int i = 0;
        while (i < defn.getFields().size()) {
            result += this.getNodeCount(defn.getFields().item(i));
            ++i;
        }
        return result;
    }

    private int getNodeCount(FieldDefn defn) {
        int factor = defn.getRepeatCount() > 1 ? defn.getRepeatCount() : 1;
        int complexity = 0;
        if (!defn.isRequired()) {
            ++complexity;
        }
        return factor * (complexity + this.getNodeCount(defn.getDataElement()));
    }

    private int getNodeCount(DataElementDefn dataElement) {
        return 1 + this.getNodeCount(dataElement.getStructure());
    }

    private int getNodeCount(StructureDefn structure) {
        if (structure.getComponents().size() <= 1) {
            return 1;
        }
        int result = structure.getComponents().size();
        int i = 0;
        while (i < structure.getComponents().size()) {
            result += this.getNodeCount(structure.getComponents().item(i));
            ++i;
        }
        return result;
    }

    private int getNodeCount(ComponentDefn defn) {
        if (defn.hasStructure()) {
            return this.getNodeCount(defn.getStructure());
        }
        return 1;
    }

    public VersionDefnList getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(VersionDefnList definitions) {
        this.definitions = definitions;
    }
}

