/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.validators;

import org.eclipse.ohf.hl7v2.core.message.ComposingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2DateUtilities;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.validators.DefinitionValidatorOptions;
import org.eclipse.ohf.hl7v2.core.validators.Validator;

public class DefinitionValidator
extends Validator {
    private DefinitionValidatorOptions options = new DefinitionValidatorOptions();

    public DefinitionValidatorOptions getOptions() {
        return this.options;
    }

    public void setOptions(DefinitionValidatorOptions options) {
        this.options = options;
    }

    public void validate(Message message) throws HL7V2Exception {
        if (this.options.isSegmentOrder()) {
            try {
                message.getSegments().buildSegmentMap(new ComposingOptions());
                if (message.getSegments().getMap() == null && message.getVersion() > 6) {
                    this.event(message, 3, 1, "Segment order could not be validated as structure was not recognised");
                }
            }
            catch (Exception e) {
                this.event(message, 3, 1, e.getMessage());
            }
        }
        int i = 0;
        while (i < message.getSegments().size()) {
            this.validateSegment(message.getSegments().item(i));
            ++i;
        }
    }

    private void validateSegment(Segment segment) throws HL7V2Exception {
        if (segment.getDefinition() != null) {
            int start = 0;
            if (segment.getCode().equals("MSH") || segment.getCode().equals("FHS") || segment.getCode().equals("BHS")) {
                start = 2;
            }
            int i = start;
            while (i < segment.getFields().size()) {
                this.validateDataElement(segment.getFields().item(i));
                ++i;
            }
        } else if (!segment.matches("Z*")) {
            this.event(segment, 3, 16, "Segment '" + segment.getCode() + "' not known");
        }
    }

    private void validateDataElement(Field field) throws HL7V2Exception {
        this.validateField(field);
        if (field.hasRepeats()) {
            if (field.getDefinition() != null && !field.getDefinition().isRepeatable()) {
                this.event(field, 3, 20, "Found repeats when non were expected");
            } else {
                int i = 0;
                while (i < field.getRepeats().size()) {
                    this.validateField(field.getRepeats().item(i));
                    ++i;
                }
            }
        }
    }

    private void validateField(Field field) throws HL7V2Exception {
        if (field.getDefinition() != null) {
            String dataType = null;
            if (field.getDefinition().getDataElement() != null && field.getDefinition().getDataElement().getStructure() != null) {
                dataType = field.getDefinition().getDataElement().getStructure().getDataTypeCode();
            }
            this.validateCell(field, field.getDefinition().isRequired(), dataType);
        }
    }

    private void validateComponent(Component component) throws HL7V2Exception {
        if (component.getDefinition() != null) {
            this.validateCell(component, false, component.getDefinition().getDataTypeCode());
        } else {
            this.validateCell(component, false, null);
        }
    }

    private void validateCell(Cell cell, boolean required, String dataType) throws HL7V2Exception {
        String error;
        if (this.options.isRequired() && required && !cell.hasContent()) {
            this.event(cell, 3, 20, "Required Element not provided");
        }
        if (dataType != null && dataType.equals("ID") && cell.hasTable() && cell.hasContent() && !cell.isValidTableCode()) {
            this.event(cell, 3, 20, "Table value '" + cell.getRawContent() + "' is not valid in table " + cell.getTable().getName());
        }
        if (this.options.isDateFormat() && cell.hasContent() && (error = new HL7V2DateUtilities().checkDateByType(cell.getAsString(), dataType, cell.getVersionDefinition().getVersion())) != null) {
            this.event(cell, 3, 3, error);
        }
        if (cell.hasComponents()) {
            int i = 0;
            while (i < cell.getComponents().size()) {
                this.validateComponent((Component)cell.getComponents().itemCell(i));
                ++i;
            }
        }
    }
}

