/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.type.DateTimeRangeType;
import org.eclipse.ohf.bridge.type.GenericAdtValue;

public abstract class Utils {
    static final Logger mLogger = Logger.getLogger(Utils.class);

    public static String trimNull(String pString) {
        if (pString == null) {
            return null;
        }
        if ((pString = pString.trim()).length() == 0 || "".equals(pString)) {
            return null;
        }
        return pString;
    }

    public static boolean isEmpty(String pString) {
        return (pString = pString.trim()).length() == 0 || "".equals(pString);
    }

    public static boolean isEmptyOrNull(String pString) {
        if (pString == null) {
            return true;
        }
        return Utils.isEmpty(pString);
    }

    public static boolean notEmpty(String pString) {
        return !Utils.isEmptyOrNull(pString);
    }

    public static void addLineToLogList(List pList, String pLine) {
        if (Utils.isEmpty(pLine = pLine.trim())) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < pLine.length()) {
            char c = pLine.charAt(i);
            if (Character.isDefined(c) && !Character.isIdentifierIgnorable(c) && !Character.isISOControl(c) && c > '\u001f') {
                sb.append(pLine.charAt(i));
            }
            ++i;
        }
        String newLine = sb.toString();
        pList.add(newLine);
    }

    public static String stringArrayAsString(String[] pArray) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = pArray;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = stringArray[n];
            sb.append(string);
            sb.append("    ");
            ++n;
        }
        return sb.toString();
    }

    public static String dateTimeRangesArrayAsString(DateTimeRangeType[] pDateTimeRanges) {
        StringBuilder sb = new StringBuilder();
        DateTimeRangeType[] dateTimeRangeTypeArray = pDateTimeRanges;
        int n = 0;
        int n2 = dateTimeRangeTypeArray.length;
        while (n < n2) {
            DateTimeRangeType range = dateTimeRangeTypeArray[n];
            sb.append(range);
            sb.append("    ");
            ++n;
        }
        return sb.toString();
    }

    public static void panic(String pString, Throwable t) {
        t.printStackTrace();
        mLogger.fatal((Object)pString, t);
        Utils.panic(pString);
    }

    public static void panic(String pString) {
        mLogger.fatal((Object)pString);
        System.err.println(pString);
        System.err.println("bye :-(");
        System.err.flush();
        System.out.flush();
        System.exit(1);
    }

    public static String genericAdtValuesArrayAsString(GenericAdtValue[] pGenericAdtValues) {
        StringBuilder sb = new StringBuilder();
        GenericAdtValue[] genericAdtValueArray = pGenericAdtValues;
        int n = 0;
        int n2 = genericAdtValueArray.length;
        while (n < n2) {
            GenericAdtValue range = genericAdtValueArray[n];
            sb.append(range);
            sb.append("    ");
            ++n;
        }
        return sb.toString();
    }
}

