/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.type;

import java.io.Serializable;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.type.AddressType;
import org.eclipse.ohf.bridge.type.GenericAdtValue;
import org.eclipse.ohf.bridge.type.PatientIdType;
import org.eclipse.ohf.bridge.type.PatientNameType;
import org.eclipse.ohf.bridge.type.PhoneType;

public class PatientInfoType
implements Serializable {
    private static final String SEX_MALE = "M";
    private static final String SEX_FEMALE = "F";
    private static final String SEX_OTHER = "O";
    private static final String SEX_UNKNOWN = "U";
    private static final String SEX_AMBIGUOUS = "A";
    private static final String SEX_NOT_APPLICABLE = "N";
    private static final String[] OPTIONAL_SEX_STRINGS = new String[]{"A", "F", "M", "N", "O", "U"};
    private static final long serialVersionUID = 314L;
    private PatientIdType patientIdentifier = new PatientIdType();
    private PatientNameType patientName = new PatientNameType();
    private String patientDateOfBirth = "";
    private String patientSex = "";
    private AddressType patientAddress = new AddressType();
    private PhoneType patientPhoneHome = new PhoneType();
    private PhoneType patientPhoneBusiness = new PhoneType();
    private GenericAdtValue[] genericAdtValues = GenericAdtValue.EMPTY_ARRAY;

    public String getPatientDateOfBirth() {
        return this.patientDateOfBirth;
    }

    public void setPatientDateOfBirth(String patientDOB) {
        this.patientDateOfBirth = patientDOB;
    }

    public PatientIdType getPatientIdentifier() {
        return this.patientIdentifier;
    }

    public void setPatientIdentifier(PatientIdType patientId) {
        this.patientIdentifier = patientId;
    }

    public String getPatientSex() {
        return this.patientSex;
    }

    public void setPatientSex(String patientSex) {
        if (Utils.isEmptyOrNull(patientSex)) {
            return;
        }
        String[] stringArray = OPTIONAL_SEX_STRINGS;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String option = stringArray[n];
            if (option.equalsIgnoreCase(option)) {
                this.patientSex = patientSex;
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("sex not valid:" + patientSex + " should be one of " + Utils.stringArrayAsString(OPTIONAL_SEX_STRINGS));
    }

    public void setPatientSuffixName(String patientSuffixName) {
        this.patientName.setSuffix(patientSuffixName);
    }

    public AddressType getPatientAddress() {
        return this.patientAddress;
    }

    public void setPatientAddress(AddressType patientAddress) {
        this.patientAddress = patientAddress;
    }

    public PatientNameType getPatientName() {
        return this.patientName;
    }

    public void setPatientName(PatientNameType patientName) {
        this.patientName = patientName;
    }

    public void setPatientPhoneBusiness(PhoneType businessPhone) {
        this.patientPhoneBusiness = businessPhone;
    }

    public void setPatientPhoneHome(PhoneType homePhone) {
        this.patientPhoneHome = homePhone;
    }

    public PhoneType getPatientPhoneBusiness() {
        return this.patientPhoneBusiness;
    }

    public PhoneType getPatientPhoneHome() {
        return this.patientPhoneHome;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.patientAddress == null ? 0 : this.patientAddress.hashCode());
        result = 31 * result + (this.patientDateOfBirth == null ? 0 : this.patientDateOfBirth.hashCode());
        result = 31 * result + (this.patientIdentifier == null ? 0 : this.patientIdentifier.hashCode());
        result = 31 * result + (this.patientName == null ? 0 : this.patientName.hashCode());
        result = 31 * result + (this.patientPhoneBusiness == null ? 0 : this.patientPhoneBusiness.hashCode());
        result = 31 * result + (this.patientPhoneHome == null ? 0 : this.patientPhoneHome.hashCode());
        result = 31 * result + (this.patientSex == null ? 0 : this.patientSex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatientInfoType other = (PatientInfoType)obj;
        if (this.patientAddress == null ? other.patientAddress != null : !this.patientAddress.equals(other.patientAddress)) {
            return false;
        }
        if (this.patientDateOfBirth == null ? other.patientDateOfBirth != null : !this.patientDateOfBirth.equals(other.patientDateOfBirth)) {
            return false;
        }
        if (this.patientIdentifier == null ? other.patientIdentifier != null : !this.patientIdentifier.equals(other.patientIdentifier)) {
            return false;
        }
        if (this.patientName == null ? other.patientName != null : !this.patientName.equals(other.patientName)) {
            return false;
        }
        if (this.patientPhoneBusiness == null ? other.patientPhoneBusiness != null : !this.patientPhoneBusiness.equals(other.patientPhoneBusiness)) {
            return false;
        }
        if (this.patientPhoneHome == null ? other.patientPhoneHome != null : !this.patientPhoneHome.equals(other.patientPhoneHome)) {
            return false;
        }
        return !(this.patientSex == null ? other.patientSex != null : !this.patientSex.equals(other.patientSex));
    }

    public GenericAdtValue[] getGenericAdtValues() {
        return this.genericAdtValues;
    }

    public void setGenericAdtValues(GenericAdtValue[] pGenericAdtValues) {
        this.genericAdtValues = pGenericAdtValues;
    }

    public String toString() {
        StringBuffer retValue = new StringBuffer();
        retValue.append("PatientInfoType ( ").append("patientIdentifier=[").append(this.patientIdentifier).append("]").append("    ").append("patientName=[").append(this.patientName).append("]").append("    ").append("patientDateOfBirth=[").append(this.patientDateOfBirth).append("]").append("    ").append("patientSex=[").append(this.patientSex).append("]").append("    ").append("patientAddress=[").append(this.patientAddress).append("]").append("    ").append("patientPhoneHome=[").append(this.patientPhoneHome).append("]").append("    ").append("patientPhoneBusiness=[").append(this.patientPhoneBusiness).append("]").append("    ").append("genericAdtValues=[").append(Utils.genericAdtValuesArrayAsString(this.genericAdtValues)).append("]").append("    ").append(" )");
        return retValue.toString();
    }
}

