/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.xds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.BridgeException;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.type.DocumentQueryPreferencesType;
import org.eclipse.ohf.bridge.type.FindDocumentQueryType;
import org.eclipse.ohf.bridge.type.GetDocumentQueryType;
import org.eclipse.ohf.bridge.type.PatientIdType;
import org.eclipse.ohf.bridge.type.QueryDocumentsResponseType;
import org.eclipse.ohf.bridge.type.RetrieveDocumentResponseType;
import org.eclipse.ohf.bridge.type.SubmitDocumentResponseType;
import org.eclipse.ohf.bridge.type.XDSDocType;
import org.eclipse.ohf.bridge.xds.CDAExtractor;
import org.eclipse.ohf.bridge.xds.XDSDocTypeToCDA;
import org.eclipse.ohf.bridge.xds.XdsBridge;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientException;

public abstract class AbstractXdsBridge
implements XdsBridge {
    static final Logger mLogger = Logger.getLogger(AbstractXdsBridge.class);

    public QueryDocumentsResponseType queryDocumentsByPatientId(PatientIdType patientId, DocumentQueryPreferencesType searchPreferences) throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting QueryDocumentsResponseType queryDocumentsByPatientId(" + patientId + ", " + searchPreferences + ") " + " in  " + TransactionContext.instant().getSessionContext()));
        }
        QueryDocumentsResponseType responce = this.goQueryDocumentsByPatientId(patientId, searchPreferences);
        responce.setSuccess(true);
        return responce;
    }

    protected abstract QueryDocumentsResponseType goQueryDocumentsByPatientId(PatientIdType var1, DocumentQueryPreferencesType var2) throws Exception;

    public RetrieveDocumentResponseType retrieveDocument(String uniqueId, String uuid) throws Exception {
        String searchId;
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting XDSDocType getDocument(" + uniqueId + ", " + uuid + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        boolean isUUID = false;
        if (uniqueId == null) {
            searchId = uuid;
            isUUID = true;
        } else {
            searchId = uniqueId;
        }
        XDSDocType xdsDocument = this.goRetrieveDocument(searchId, isUUID);
        return this.getResponceOfDocument(xdsDocument);
    }

    protected abstract XDSDocType goRetrieveDocument(String var1, boolean var2) throws Exception;

    public SubmitDocumentResponseType addCDADocumentUsingTemplateMetadataNoExtraction(String cdaXml) throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String addCDADocument:/n" + cdaXml + "/n " + " in " + TransactionContext.instant().getSessionContext()));
        }
        CDAExtractor cdaExtractor = new CDAExtractor(cdaXml);
        String docEntryXml = cdaExtractor.getDocEntry();
        String submissionSetXml = cdaExtractor.getSubmissionSet();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"============ CDA ============");
            mLogger.debug((Object)cdaXml);
            mLogger.debug((Object)"============ /CDA ============");
            mLogger.debug((Object)"============ DocEntry ============");
            mLogger.debug((Object)docEntryXml);
            mLogger.debug((Object)"============ /DocEntry ============");
            mLogger.debug((Object)"============ SubmissionSet ============");
            mLogger.debug((Object)submissionSetXml);
            mLogger.debug((Object)"============ /SubmissionSet ============");
        }
        ByteArrayInputStream docEntryStream = new ByteArrayInputStream(docEntryXml.getBytes());
        ByteArrayInputStream submitSetStream = new ByteArrayInputStream(submissionSetXml.getBytes());
        return this.doAddCDADocumentWithoutExtractingMetadata(cdaXml, docEntryStream, submitSetStream);
    }

    protected abstract SubmitDocumentResponseType doAddCDADocumentWithoutExtractingMetadata(String var1, InputStream var2, InputStream var3) throws Exception;

    public SubmitDocumentResponseType embedInCdaAndSendDocument(XDSDocType doc) throws Exception {
        XDSDocTypeToCDA cdaConverter = new XDSDocTypeToCDA();
        return this.addCDADocumentUsingTemplateMetadataNoExtraction(cdaConverter.convert(doc));
    }

    public QueryDocumentsResponseType queryDocuments(FindDocumentQueryType pFindDocumentQueryType, DocumentQueryPreferencesType searchPreferences) throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting QueryDocumentsResponseType queryDocuments()  in  " + TransactionContext.instant().getSessionContext()));
        }
        pFindDocumentQueryType.setPatientID(pFindDocumentQueryType.getPatientID());
        QueryDocumentsResponseType responce = this.goQueryDocuments(pFindDocumentQueryType, searchPreferences);
        return responce;
    }

    public QueryDocumentsResponseType queryDocuments(GetDocumentQueryType pGetDocumentQueryType, DocumentQueryPreferencesType searchPreferences) throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting QueryDocumentsResponseType queryDocuments()  in  " + TransactionContext.instant().getSessionContext()));
        }
        QueryDocumentsResponseType responce = this.goQueryDocuments(pGetDocumentQueryType, searchPreferences);
        return responce;
    }

    protected abstract QueryDocumentsResponseType goQueryDocuments(GetDocumentQueryType var1, DocumentQueryPreferencesType var2) throws Exception;

    protected abstract QueryDocumentsResponseType goQueryDocuments(FindDocumentQueryType var1, DocumentQueryPreferencesType var2) throws Exception;

    public RetrieveDocumentResponseType retrieveDocumentByUrl(String pUrl) throws IOException, ATNAAuditClientException, GeneralSecurityException, BridgeException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting XDSDocType retrieveDocumentByUrl(" + pUrl + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        this.validateUrl(pUrl);
        XDSDocType xdsDocument = this.goRetrieveDocumentByUrl(pUrl);
        return this.getResponceOfDocument(xdsDocument);
    }

    private void validateUrl(String pUrl) throws BridgeException {
        try {
            new URL(pUrl);
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Document URL is not valid: " + pUrl, e);
        }
    }

    protected abstract XDSDocType goRetrieveDocumentByUrl(String var1) throws IOException, ATNAAuditClientException, GeneralSecurityException, UnavailableResourcesException, BridgeException;

    private RetrieveDocumentResponseType getResponceOfDocument(XDSDocType xdsDocument) {
        RetrieveDocumentResponseType response = new RetrieveDocumentResponseType();
        response.setDocument(xdsDocument);
        response.setSuccess(true);
        return response;
    }
}

