/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventTypeCode;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.util.TimeStamp;

public class UserAuthenticationMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public UserAuthenticationMessage(String eventDateTime, int eventOutcomeIndicator, boolean login, String userID, String userName, short networkAccessPointTypeCode, String networkAccessPointID, String userIDofNodePerformingAuthentication) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        EventIdentificationType eventId = new EventIdentificationType(0);
        eventId.setEventActionCode("E");
        eventId.setEventID(new AuditEventID.UserAuthentication());
        eventId.setEventDateTime(eventDateTime);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        if (login) {
            eventId.setEventTypeCode(new AuditEventTypeCode.Login());
        } else {
            eventId.setEventTypeCode(new AuditEventTypeCode.Logout());
        }
        this.setEventIdentification(eventId);
        ActiveParticipantType user = null;
        user = new ActiveParticipantType();
        user.setUserID(userID);
        if (userName != null) {
            user.setUserName(userName);
        }
        user.setUserIsRequestor(true);
        user.setNetworkAccessPointTypeCode(networkAccessPointTypeCode);
        user.setNetworkAccessPointID(networkAccessPointID);
        this.setActiveParticipant(user);
        ActiveParticipantType node = new ActiveParticipantType();
        node.setUserID(userIDofNodePerformingAuthentication);
        node.setUserIsRequestor(false);
        this.setActiveParticipant(node);
    }

    public UserAuthenticationMessage(int eventOutcomIndicator, boolean login, String userID, String userName) throws ParserConfigurationException, FactoryConfigurationError, ATNAException, UnknownHostException {
        this(TimeStamp.generateUTCDateTime(), eventOutcomIndicator, login, userID, userName, 2, InetAddress.getLocalHost().getHostAddress(), InetAddress.getLocalHost().getHostAddress());
    }
}

