/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.cdar2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class AudioMediaType
extends AbstractEnumerator {
    public static final int AUDIO_BASIC = 0;
    public static final int AUDIO_K3_2ADPCM = 1;
    public static final int AUDIO_MPEG = 2;
    public static final AudioMediaType AUDIO_BASIC_LITERAL = new AudioMediaType(0, "audioBasic", "audio/basic");
    public static final AudioMediaType AUDIO_K3_2ADPCM_LITERAL = new AudioMediaType(1, "audioK32adpcm", "audio/k32adpcm");
    public static final AudioMediaType AUDIO_MPEG_LITERAL = new AudioMediaType(2, "audioMpeg", "audio/mpeg");
    private static final AudioMediaType[] VALUES_ARRAY = new AudioMediaType[]{AUDIO_BASIC_LITERAL, AUDIO_K3_2ADPCM_LITERAL, AUDIO_MPEG_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static AudioMediaType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AudioMediaType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AudioMediaType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AudioMediaType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AudioMediaType get(int value) {
        switch (value) {
            case 0: {
                return AUDIO_BASIC_LITERAL;
            }
            case 1: {
                return AUDIO_K3_2ADPCM_LITERAL;
            }
            case 2: {
                return AUDIO_MPEG_LITERAL;
            }
        }
        return null;
    }

    private AudioMediaType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

