/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.operations;

import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentGroup;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTable;
import org.eclipse.ohf.hl7v2.core.conformance.operations.CPError;
import org.eclipse.ohf.hl7v2.core.conformance.operations.CPErrors;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public class CPInternalValidator
extends Worker {
    private CPDocument document;
    private CPErrors errors;

    public CPDocument getDocument() {
        return this.document;
    }

    public void setDocument(CPDocument document) {
        this.document = document;
    }

    public CPErrors getErrors() {
        return this.errors;
    }

    public void setErrors(CPErrors errors) {
        this.errors = errors;
    }

    public void validate() {
        try {
            switch (this.document.getDocumentType()) {
                case 1: {
                    this.validateProfile(this.document.getProfile());
                    break;
                }
                case 2: {
                    this.validateMessage(this.document.getMessage());
                    break;
                }
                case 3: {
                    this.validateSegmentGroup(this.document.getSegmentGroup());
                    break;
                }
                case 4: {
                    this.validateSegment(this.document.getSegment());
                    break;
                }
                case 5: {
                    this.validateField(this.document.getField());
                    break;
                }
                case 6: {
                    this.validateComponent(this.document.getComponent());
                    break;
                }
                case 7: {
                    this.validateTable(this.document.getTable());
                    break;
                }
                case 0: {
                    throw new HL7V2Exception("unknown document type", 18);
                }
            }
        }
        catch (HL7V2Exception e) {
            this.errors.add(new CPError(this.document, 0, e.getMessage()));
        }
    }

    private void validateTable(CPTable table) {
    }

    private void validateComponent(CPComponent component) {
    }

    private void validateField(CPField field) {
    }

    private void validateSegment(CPSegment segment) {
    }

    private void validateSegmentGroup(CPSegmentGroup segmentGroup) {
    }

    private void validateMessage(CPStaticDefinition message) {
    }

    private void validateProfile(CPConformanceProfile profile) {
    }
}

