/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.formats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.ohf.hl7v2.core.definitions.formats.Loader;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.NamedDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.xml.XMLWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PrivateFormat
extends Loader {
    boolean closeStream;
    private InputStream stream;

    public PrivateFormat() {
    }

    public PrivateFormat(String filename) throws HL7V2Exception {
        try {
            this.stream = new FileInputStream(new File(filename));
            this.closeStream = true;
        }
        catch (FileNotFoundException e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    public PrivateFormat(InputStream stream, boolean close) throws HL7V2Exception {
        this.closeStream = close;
        this.stream = stream;
    }

    public PrivateFormat(File file) throws HL7V2Exception {
        try {
            this.stream = new FileInputStream(file);
            this.closeStream = true;
        }
        catch (FileNotFoundException e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    public VersionDefnList load() throws HL7V2Exception {
        try {
            XmlPullParser xpp = this.makeParser();
            VersionDefnList versions = new VersionDefnList();
            int eventType = xpp.next();
            while (eventType == 2) {
                if (!xpp.getName().equals("defn")) {
                    throw new HL7V2Exception("unexpected element name " + xpp.getName() + " in document", 18);
                }
                versions.add(this.readVersion(xpp, versions));
                eventType = xpp.next();
            }
            if (this.closeStream) {
                this.stream.close();
            }
            return versions;
        }
        catch (Exception e) {
            try {
                if (this.closeStream) {
                    this.stream.close();
                }
            }
            catch (IOException iOException) {}
            throw new HL7V2Exception(e, 19);
        }
    }

    private XmlPullParser makeParser() throws IOException, HL7V2Exception, XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput((InputStream)new GZIPInputStream(this.stream), null);
        int eventType = xpp.next();
        if (eventType != 2) {
            throw new HL7V2Exception("Unable to process XML document", 19);
        }
        if (!xpp.getName().equals("HL7V2Definitions")) {
            throw new HL7V2Exception("XML Document Root element is wrong", 19);
        }
        return xpp;
    }

    public void save(VersionDefnList versions, String filename) throws HL7V2Exception {
        try {
            this.save(versions, new FileOutputStream(new File(filename)));
        }
        catch (FileNotFoundException e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    private void save(VersionDefnList versions, OutputStream stream) throws HL7V2Exception {
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new GZIPOutputStream(stream), "UTF-8");
            writer.start();
            writer.open("HL7V2Definitions");
            int i = 0;
            while (i < versions.count()) {
                this.saveVersion(writer, versions.item(i));
                ++i;
            }
            writer.close();
            writer.close();
        }
        catch (Exception e) {
            throw new HL7V2Exception(e, 14);
        }
    }

    private void saveVersion(XMLWriter writer, VersionDefn defn) throws OHFException, IOException {
        writer.attribute("v", VersionDefnList.display(defn.getVersion()));
        writer.open("defn");
        int i = 0;
        while (i < defn.getTables().size()) {
            this.saveTable(writer, defn.getTables().item(i));
            ++i;
        }
        i = 0;
        while (i < defn.getDataTypes().size()) {
            this.saveDataType(writer, defn.getDataTypes().item(i));
            ++i;
        }
        i = 0;
        while (i < defn.getComponents().size()) {
            this.saveComponent(writer, defn.getComponents().item(i), true);
            ++i;
        }
        i = 0;
        while (i < defn.getStructures().size()) {
            this.saveStructure(writer, defn.getStructures().item(i));
            ++i;
        }
        i = 0;
        while (i < defn.getDataElements().size()) {
            this.saveDataElement(writer, defn.getDataElements().item(i));
            ++i;
        }
        i = 0;
        while (i < defn.getSegments().size()) {
            this.saveSegment(writer, defn.getSegments().item(i));
            ++i;
        }
        i = 0;
        while (i < defn.getMessageStructures().size()) {
            this.saveMessageStructure(writer, defn.getMessageStructures().item(i));
            ++i;
        }
        i = 0;
        while (i < defn.getEvents().size()) {
            this.saveEvent(writer, defn.getEvents().item(i));
            ++i;
        }
        i = 0;
        while (i < defn.getMessageTypes().size()) {
            this.saveMessageType(writer, defn.getMessageTypes().item(i));
            ++i;
        }
        writer.close();
    }

    private VersionDefn readVersion(XmlPullParser xpp, VersionDefnList defns) throws HL7V2Exception, XmlPullParserException, IOException {
        VersionDefn version = new VersionDefn(defns);
        version.setVersion(VersionDefnList.getVersion(xpp.getAttributeValue(null, "v")));
        int eventType = xpp.next();
        while (eventType == 2) {
            String name = xpp.getName();
            if (name.equals("tbl")) {
                version.getTables().add(this.readTable(xpp, version));
            } else if (name.equals("dt")) {
                version.getDataTypes().add(this.readDataType(xpp, version));
            } else if (name.equals("cmp")) {
                version.getComponents().add(this.readComponent(xpp, version));
            } else if (name.equals("struc")) {
                version.getStructures().add(this.readStructure(xpp, version));
            } else if (name.equals("de")) {
                version.getDataElements().add(this.readDataElement(xpp, version));
            } else if (name.equals("seg")) {
                version.getSegments().add(this.readSegment(xpp, version));
            } else if (name.equals("msg")) {
                version.getMessageStructures().add(this.readMessageStructure(xpp, version));
            } else if (name.equals("ev")) {
                version.getEvents().add(this.readEvent(xpp, version));
            } else if (name.equals("mt")) {
                version.getMessageTypes().add(this.readMessageType(xpp, version));
            } else {
                throw new XmlPullParserException("unknown name " + name);
            }
            eventType = xpp.next();
        }
        version.crossLink();
        return version;
    }

    private void saveTable(XMLWriter writer, TableDefn defn) throws OHFException, IOException {
        this.namedDefnAttributes(writer, defn);
        writer.attribute("id", Integer.toString(defn.getId()));
        writer.open("tbl");
        int i = 0;
        while (i < defn.getItems().size()) {
            this.saveTableItem(writer, defn.getItems().item(i));
            ++i;
        }
        writer.close();
    }

    private TableDefn readTable(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        TableDefn defn = new TableDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        defn.setId(Integer.parseInt(xpp.getAttributeValue(null, "id")));
        int eventType = xpp.next();
        while (eventType == 2) {
            if (!xpp.getName().equals("itm")) {
                throw new XmlPullParserException("unknown name " + xpp.getName());
            }
            defn.getItems().add(this.readTableItem(xpp, version));
            eventType = xpp.next();
        }
        return defn;
    }

    private void saveTableItem(XMLWriter writer, TableItemDefn defn) throws OHFException, IOException {
        this.namedDefnAttributes(writer, defn);
        writer.attribute("id", Integer.toString(defn.getId()));
        writer.element("itm", null);
    }

    private TableItemDefn readTableItem(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        TableItemDefn defn = new TableItemDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        defn.setId(Integer.parseInt(xpp.getAttributeValue(null, "id")));
        xpp.next();
        return defn;
    }

    private void namedDefnAttributes(XMLWriter writer, NamedDefn defn) throws IOException {
        writer.attribute("n", defn.getName());
        writer.attribute("d", defn.getDescription());
    }

    private void readNamedDefnAttributes(XmlPullParser xpp, NamedDefn defn) {
        defn.setName(xpp.getAttributeValue(null, "n"));
        defn.setDescription(xpp.getAttributeValue(null, "d"));
    }

    private void saveDataType(XMLWriter writer, DataTypeDefn defn) throws OHFException, IOException {
        this.namedDefnAttributes(writer, defn);
        writer.attribute("l", Integer.toString(defn.getLength()));
        writer.element("dt", null);
    }

    private DataTypeDefn readDataType(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        DataTypeDefn defn = new DataTypeDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        defn.setLength(Integer.parseInt(xpp.getAttributeValue(null, "l")));
        xpp.next();
        return defn;
    }

    private void saveComponent(XMLWriter writer, ComponentDefn defn, boolean fullDetails) throws OHFException, IOException {
        writer.attribute("nm", Integer.toString(defn.getNumber()));
        if (fullDetails) {
            writer.attribute("n", defn.getName());
            writer.attribute("dt", defn.getDataTypeCode());
            writer.attribute("t", Integer.toString(defn.getTableId()));
        }
        writer.element("cmp", null);
    }

    private ComponentDefn readComponent(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        ComponentDefn defn = new ComponentDefn(version);
        defn.setName(xpp.getAttributeValue(null, "n"));
        defn.setDataTypeCode(xpp.getAttributeValue(null, "dt"));
        defn.setNumber(Integer.parseInt(xpp.getAttributeValue(null, "nm")));
        defn.setTableId(Integer.parseInt(xpp.getAttributeValue(null, "t")));
        xpp.next();
        return defn;
    }

    private ComponentDefn readComponentLink(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        ComponentDefn defn = version.getComponents().itemByNumber(Integer.parseInt(xpp.getAttributeValue(null, "nm")));
        xpp.next();
        return defn;
    }

    private void saveStructure(XMLWriter writer, StructureDefn defn) throws OHFException, IOException {
        this.namedDefnAttributes(writer, defn);
        writer.attribute("dt", defn.getDataTypeCode());
        writer.attribute("id", Integer.toString(defn.getId()));
        writer.open("struc");
        int i = 0;
        while (i < defn.getComponents().size()) {
            this.saveComponent(writer, defn.getComponents().item(i), false);
            ++i;
        }
        writer.close();
    }

    private StructureDefn readStructure(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        StructureDefn defn = new StructureDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        defn.setDataTypeCode(xpp.getAttributeValue(null, "dt"));
        defn.setId(Integer.parseInt(xpp.getAttributeValue(null, "id")));
        int eventType = xpp.next();
        while (eventType == 2) {
            if (!xpp.getName().equals("cmp")) {
                throw new XmlPullParserException("unknown name " + xpp.getName());
            }
            defn.getComponents().add(this.readComponentLink(xpp, version));
            eventType = xpp.next();
        }
        return defn;
    }

    private void saveDataElement(XMLWriter writer, DataElementDefn defn) throws OHFException, IOException {
        writer.attribute("d", defn.getDescription());
        writer.attribute("id", Integer.toString(defn.getId()));
        writer.attribute("sc", defn.getStructureCode());
        writer.attribute("l", Integer.toString(defn.getLength()));
        writer.attribute("t", Integer.toString(defn.getTableId()));
        writer.element("de", null);
    }

    private DataElementDefn readDataElement(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        DataElementDefn defn = new DataElementDefn(version);
        defn.setDescription(xpp.getAttributeValue(null, "d"));
        defn.setId(Integer.parseInt(xpp.getAttributeValue(null, "id")));
        defn.setStructureCode(xpp.getAttributeValue(null, "sc"));
        defn.setLength(Integer.parseInt(xpp.getAttributeValue(null, "l")));
        defn.setTableId(Integer.parseInt(xpp.getAttributeValue(null, "t")));
        xpp.next();
        return defn;
    }

    private void saveSegment(XMLWriter writer, SegmentDefn defn) throws IOException, OHFException {
        this.namedDefnAttributes(writer, defn);
        writer.open("seg");
        int i = 0;
        while (i < defn.getFields().size()) {
            this.saveField(writer, defn.getFields().item(i));
            ++i;
        }
        writer.close();
    }

    private SegmentDefn readSegment(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        SegmentDefn defn = new SegmentDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        int eventType = xpp.next();
        while (eventType == 2) {
            if (!xpp.getName().equals("f")) {
                throw new XmlPullParserException("unknown name " + xpp.getName());
            }
            defn.getFields().add(this.readField(xpp, version));
            eventType = xpp.next();
        }
        return defn;
    }

    private void saveField(XMLWriter writer, FieldDefn defn) throws OHFException, IOException {
        writer.attribute("id", Integer.toString(defn.getDataElementId()));
        writer.attribute("r", Boolean.toString(defn.isRepeatable()));
        writer.attribute("c", Integer.toString(defn.getRepeatCount()));
        writer.attribute("m", Boolean.toString(defn.isRequired()));
        writer.attribute("n", Integer.toString(defn.getNumber()));
        writer.element("f", null);
    }

    private FieldDefn readField(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        FieldDefn defn = new FieldDefn(version);
        defn.setDataElementId(Integer.parseInt(xpp.getAttributeValue(null, "id")));
        defn.setRepeatable(Boolean.valueOf(xpp.getAttributeValue(null, "r")));
        defn.setRepeatCount(Integer.parseInt(xpp.getAttributeValue(null, "c")));
        defn.setRequired(Boolean.valueOf(xpp.getAttributeValue(null, "m")));
        defn.setNumber(Integer.parseInt(xpp.getAttributeValue(null, "n")));
        xpp.next();
        return defn;
    }

    private void saveMessageStructure(XMLWriter writer, MessageStructureDefn defn) throws OHFException, IOException {
        this.namedDefnAttributes(writer, defn);
        writer.attribute("xe", defn.getExampleEvent());
        writer.attribute("xmt", defn.getExampleMessageType());
        writer.attribute("a", defn.getAction());
        writer.open("msg");
        if (defn.getMap() != null) {
            this.writeSegmentGroup(writer, defn.getMap());
        }
        writer.close();
    }

    private MessageStructureDefn readMessageStructure(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        MessageStructureDefn defn = new MessageStructureDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        defn.setExampleEvent(xpp.getAttributeValue(null, "xe"));
        defn.setExampleMessageType(xpp.getAttributeValue(null, "xmt"));
        defn.setAction(xpp.getAttributeValue(null, "a"));
        int eventType = xpp.next();
        while (eventType == 2) {
            if (!xpp.getName().equals("sg")) {
                throw new XmlPullParserException("unknown name " + xpp.getName());
            }
            defn.setMap(this.readSegmentGroup(xpp, version));
            eventType = xpp.next();
        }
        return defn;
    }

    private void writeSegmentGroup(XMLWriter writer, SegmentGroupDefn defn) throws IOException, OHFException {
        this.namedDefnAttributes(writer, defn);
        writer.attribute("o", Boolean.toString(defn.isOptional()));
        writer.attribute("r", Boolean.toString(defn.isRepeating()));
        writer.attribute("t", Integer.toString(defn.getGroupType()));
        writer.open("sg");
        int i = 0;
        while (i < defn.getChildren().size()) {
            this.writeSegmentGroup(writer, defn.getChildren().item(i));
            ++i;
        }
        writer.close();
    }

    private SegmentGroupDefn readSegmentGroup(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        SegmentGroupDefn defn = new SegmentGroupDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        defn.setOptional(Boolean.valueOf(xpp.getAttributeValue(null, "o")));
        defn.setRepeating(Boolean.valueOf(xpp.getAttributeValue(null, "r")));
        defn.setGroupType(Integer.parseInt(xpp.getAttributeValue(null, "t")));
        int eventType = xpp.next();
        while (eventType == 2) {
            if (!xpp.getName().equals("sg")) {
                throw new XmlPullParserException("unknown name " + xpp.getName());
            }
            defn.getChildren().add(this.readSegmentGroup(xpp, version));
            eventType = xpp.next();
        }
        return defn;
    }

    private void saveEvent(XMLWriter writer, EventDefn defn) throws OHFException, IOException {
        this.namedDefnAttributes(writer, defn);
        writer.open("ev");
        int i = 0;
        while (i < defn.getMessages().size()) {
            this.writeMessageDefn(writer, defn.getMessages().item(i));
            ++i;
        }
        writer.close();
    }

    private EventDefn readEvent(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        EventDefn defn = new EventDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        int eventType = xpp.next();
        while (eventType == 2) {
            if (!xpp.getName().equals("msg")) {
                throw new XmlPullParserException("unknown name " + xpp.getName());
            }
            defn.getMessages().add(this.readMessageDefinition(xpp, version));
            eventType = xpp.next();
        }
        return defn;
    }

    private void writeMessageDefn(XMLWriter writer, EventMessageDefn defn) throws OHFException, IOException {
        writer.attribute("m", defn.getMessage());
        writer.attribute("sc", defn.getStructureCode());
        writer.attribute("rm", defn.getReply());
        writer.attribute("rsc", defn.getReplyStructureCode());
        writer.element("msg", null);
    }

    private EventMessageDefn readMessageDefinition(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        EventMessageDefn defn = new EventMessageDefn(version);
        defn.setMessage(xpp.getAttributeValue(null, "m"));
        defn.setStructureCode(xpp.getAttributeValue(null, "sc"));
        defn.setReply(xpp.getAttributeValue(null, "rm"));
        defn.setReplyStructureCode(xpp.getAttributeValue(null, "rsc"));
        xpp.next();
        return defn;
    }

    private void saveMessageType(XMLWriter writer, MessageTypeDefn defn) throws OHFException, IOException {
        this.namedDefnAttributes(writer, defn);
        writer.element("mt", null);
    }

    private MessageTypeDefn readMessageType(XmlPullParser xpp, VersionDefn version) throws XmlPullParserException, IOException {
        MessageTypeDefn defn = new MessageTypeDefn(version);
        this.readNamedDefnAttributes(xpp, defn);
        xpp.next();
        return defn;
    }
}

