/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.hl7v2.core.message.formats.Composer;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public abstract class StreamComposer
extends Composer {
    private OutputStream stream;
    protected OutputStreamWriter writer;

    public StreamComposer() {
    }

    public StreamComposer(OutputStream stream) throws HL7V2Exception {
        this.setStream(stream);
    }

    public abstract void compose(Message var1) throws HL7V2Exception;

    public abstract void compose(Segment var1) throws HL7V2Exception;

    public abstract void compose(Field var1) throws HL7V2Exception;

    public abstract void compose(Component var1) throws HL7V2Exception;

    public OutputStream getStream() throws HL7V2Exception, IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        return this.stream;
    }

    public void setStream(OutputStream stream) throws HL7V2Exception {
        this.stream = stream;
        this.writer = this.createWriter(stream, this.getOptions().getCharsetName());
    }

    protected OutputStreamWriter createWriter(OutputStream stream, String charset) throws HL7V2Exception {
        try {
            return new OutputStreamWriter(stream, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HL7V2Exception("Illegal encoding method", 19);
        }
    }
}

