/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;
import org.eclipse.ohf.utilities.PreviewStream;

public class VerticalBarParserReader
extends Worker {
    private PreviewStream stream;
    private String charsetName;
    private InputStreamReader reader = null;
    private boolean finished;
    private char peeked;
    private char lastValue;
    private int offset;
    private int lineNumber;

    public VerticalBarParserReader(PreviewStream stream, String charsetName) throws HL7V2Exception {
        this.setStream(stream);
        this.setCharsetName(charsetName);
        this.open();
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public PreviewStream getStream() {
        return this.stream;
    }

    public void setStream(PreviewStream stream) {
        this.stream = stream;
    }

    private void open() throws HL7V2Exception {
        try {
            this.reader = new InputStreamReader((InputStream)this.stream, this.charsetName);
            this.offset = 0;
            this.lineNumber = 0;
            this.lastValue = (char)32;
            this.next();
        }
        catch (UnsupportedEncodingException e) {
            throw new HL7V2Exception(e, 19);
        }
        catch (IOException e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    private void next() throws IOException, HL7V2Exception {
        boolean bl = this.finished = !this.reader.ready();
        if (!this.finished) {
            char[] temp = new char[1];
            this.condition(this.reader.read(temp, 0, 1) == 1, "unable to read 1 character from the stream", 19);
            this.peeked = temp[0];
        }
    }

    public String read(int charCount) throws HL7V2Exception {
        String value = "";
        int i = 0;
        while (i < charCount) {
            value = String.valueOf(value) + this.read();
            ++i;
        }
        return value;
    }

    public void skipEOL() throws HL7V2Exception {
        while (!(this.finished || this.peek() != '\r' && this.peek() != '\n')) {
            this.read();
        }
    }

    public char read() throws HL7V2Exception {
        this.condition(!this.finished, "No more content to read", 18);
        char value = this.peek();
        ++this.offset;
        if (!(value != '\r' && value != '\n' || this.lastValue == '\r' && value == '\n')) {
            ++this.lineNumber;
        }
        this.lastValue = value;
        try {
            this.next();
        }
        catch (IOException e) {
            throw new HL7V2Exception(e, 19);
        }
        return value;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public char peek() throws HL7V2Exception {
        this.condition(!this.finished, "Cannot peek", 18);
        return this.peeked;
    }

    public void reset(boolean finished) throws HL7V2Exception {
        this.stream.reset(finished);
        this.open();
    }

    public boolean IsEOL() throws HL7V2Exception {
        return this.peek() == '\r' || this.peek() == '\n';
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getOffset() {
        return this.offset;
    }
}

