/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.NamedDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.ComponentList;
import org.eclipse.ohf.hl7v2.core.message.model.ContentList;
import org.eclipse.ohf.hl7v2.core.message.model.ContentNull;
import org.eclipse.ohf.hl7v2.core.message.model.ContentText;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.Iso8601DateUtilities;
import org.eclipse.ohf.utilities.OHFException;

public abstract class Cell
extends Item {
    protected int index;
    protected ContentList contents = null;
    private ComponentList components;

    protected Cell(int index) throws HL7V2Exception {
        this.index = index;
    }

    public boolean matches(Item obj, boolean path) throws HL7V2Exception {
        boolean result;
        boolean bl = result = super.matches(obj, path) && obj instanceof Cell;
        if (result) {
            Cell other = (Cell)obj;
            result = other.nodeType == this.nodeType && this.equals(other.index, this.index) && this.matches(other.contents, this.contents, false) && this.matches(other.components, this.components, false);
        }
        return result;
    }

    public String elementName() throws HL7V2Exception {
        return String.valueOf(this.getOwner().elementName()) + "-" + Integer.toString(this.index);
    }

    public Cell getElement(String path) throws HL7V2Exception {
        String[] parts = path.split("-");
        if (StringUtils.isNumeric((String)parts[0])) {
            int index = Integer.parseInt(parts[0]) - 1;
            if (index >= this.getComponentCount()) {
                if (index == 0) {
                    return this;
                }
                return null;
            }
            Component component = this.getComponent(index);
            if (parts.length == 1) {
                return component;
            }
            return component.getElement(parts[1]);
        }
        throw new HL7V2Exception("Illegal Path " + path, 19);
    }

    public Cell forceElement(String path) throws HL7V2Exception {
        String[] parts = StringUtils.split((String)path, (String)"-", (int)2);
        if (StringUtils.isNumeric((String)parts[0])) {
            int index = Integer.parseInt(parts[0]) - 1;
            while (index >= this.getComponentCount()) {
                this.addComponent();
            }
            Component component = this.getComponent(index);
            if (parts.length == 1) {
                return component;
            }
            return component.getElement(parts[1]);
        }
        return null;
    }

    public abstract DataTypeDefn getDataType() throws HL7V2Exception;

    public boolean escapable() throws HL7V2Exception {
        DataTypeDefn dt = this.getDataType();
        return dt != null && dt.escapable();
    }

    protected abstract int getSubComponentType();

    private ComponentList forceComponents() throws HL7V2Exception {
        if (this.components == null) {
            this.components = new ComponentList(this);
        }
        return this.components;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCellType() {
        return this.nodeType;
    }

    public boolean hasComponents() throws HL7V2Exception {
        return this.getComponentCount() > 0;
    }

    public final ComponentList getComponents() throws HL7V2Exception {
        return this.components;
    }

    public final Component addComponent() throws HL7V2Exception {
        Component component = new Component(this.getSubComponentType(), this.getComponentCount() + 1);
        this.forceComponents().add(component);
        if (this.components.size() == 1) {
            component.setContents(this.contents);
            this.setContents(null);
        }
        this.assignDefinition(component);
        return component;
    }

    protected abstract void assignDefinition(Component var1);

    public final void removeComponent() throws HL7V2Exception {
        if (this.forceComponents().size() == 0) {
            throw new HL7V2Exception("Unable to remove components - none exist", 19);
        }
        if (this.components.size() == 1) {
            Component comp = this.components.item(0);
            this.clear();
            this.copy(comp);
        } else {
            this.components.remove(this.components.size() - 1);
        }
    }

    public Component forceComponent(int index) throws HL7V2Exception {
        while (this.forceComponents().size() < index + 1) {
            this.addComponent();
        }
        return this.getComponent(index);
    }

    public Component getComponent(int index) throws HL7V2Exception {
        if (this.getComponents() != null) {
            return (Component)this.getComponents().itemCell(index);
        }
        throw new HL7V2Exception("This Cell has no components", 15);
    }

    public boolean hasOnlyFirstComponent() throws HL7V2Exception {
        if (this.getComponentCount() == 0) {
            return true;
        }
        boolean result = this.getComponent(0).hasOnlyFirstComponent();
        int i = 1;
        while (i < this.getComponentCount()) {
            result = result && !this.getComponent(i).hasContent();
            ++i;
        }
        return result;
    }

    public int getComponentCount() throws HL7V2Exception {
        if (this.getComponents() != null) {
            return this.getComponents().size();
        }
        return 0;
    }

    public int getConformanceLength() throws HL7V2Exception {
        if (!this.hasComponents()) {
            return this.getRawContent().length();
        }
        int result = -1;
        int i = 0;
        while (i < this.getComponents().size()) {
            result = result + this.getComponents().itemCell(i).getConformanceLength() + 1;
            ++i;
        }
        return result;
    }

    public void clear() throws HL7V2Exception {
        this.contents = null;
        this.components = null;
    }

    public void clearContent() throws HL7V2Exception {
        this.contents = null;
        if (this.components != null) {
            int i = 0;
            while (i < this.components.size()) {
                this.components.item(i).clearContent();
                ++i;
            }
        }
    }

    public ContentList getContents() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getContents();
        }
        if (this.contents == null) {
            this.createContents();
        }
        return this.contents;
    }

    public void setContents(ContentList contents) {
        this.contents = contents;
    }

    private void createContents() throws HL7V2Exception {
        this.contents = new ContentList(this, this.escapable());
    }

    public String getRawContent() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getRawContent();
        }
        if (this.contents == null || this.contents.size() == 0) {
            return "";
        }
        this.condition(this.isSimple(), "Attempt to access rawContent when complex content exists", 19);
        return this.contents.itemContent(0).getText();
    }

    public boolean isSimple() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).isSimple();
        }
        return this.contents == null || this.contents.size() == 0 || this.contents.size() == 1 && (this.contents.itemContent(0).getContentType() == 0 || this.contents.itemContent(0).getContentType() == 1);
    }

    public void setRawContent(char value) throws HL7V2Exception {
        String string = "";
        string = String.valueOf(string) + value;
        this.setRawContent(string);
    }

    public void setRawContent(String value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setRawContent(value);
        } else {
            if (value == null) {
                value = "";
            }
            if (value.equals("\"\"")) {
                this.createContents();
                this.contents.add(new ContentNull(0));
            } else if (value.equals("")) {
                this.contents = null;
            } else {
                this.createContents();
                this.contents.add(new ContentText(0, value));
            }
        }
    }

    public boolean getNullify() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getNullify();
        }
        return this.contents != null && this.contents.size() == 1 && this.contents.itemContent(0).getContentType() == 1;
    }

    public void setNullify(boolean value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setDefined(value);
        } else if (value) {
            this.createContents();
            this.contents.add(new ContentNull(0));
        } else if (this.getNullify()) {
            this.contents = null;
        }
    }

    public boolean isNull() throws HL7V2Exception {
        return !this.getDefined();
    }

    public boolean getDefined() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getDefined();
        }
        return this.contents != null && this.contents.size() > 0;
    }

    public void setDefined(boolean value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setDefined(value);
        } else if (value) {
            if (this.contents == null) {
                this.createContents();
            }
            if (this.contents.size() == 0) {
                this.contents.add(new ContentNull(0));
            }
        } else {
            this.contents = null;
        }
    }

    public boolean hasContent() throws HL7V2Exception {
        if (this.getComponentCount() == 0) {
            return this.getDefined();
        }
        boolean result = false;
        int i = 0;
        while (i < this.getComponentCount()) {
            result = result || this.getComponent(i).hasContent();
            ++i;
        }
        return result;
    }

    public double getAsFloat() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getAsFloat();
        }
        if (!this.getDefined() || this.getNullify()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.getRawContent());
        }
        catch (NumberFormatException numberFormatException) {
            throw new HL7V2Exception("Value in " + this.elementName() + " is not a proper floating point number [" + this.getRawContent() + "]", 3);
        }
    }

    public void setAsFloat(double value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setAsFloat(value);
        } else {
            this.setRawContent(Double.toString(value));
        }
    }

    public int getAsInteger() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getAsInteger();
        }
        if (!this.getDefined() || this.getNullify()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getRawContent());
        }
        catch (NumberFormatException numberFormatException) {
            throw new HL7V2Exception("Value in " + this.elementName() + " is not a proper integer [" + this.getRawContent() + "]", 3);
        }
    }

    public void setAsInteger(int value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setAsInteger(value);
        } else {
            this.setRawContent(Integer.toString(value));
        }
    }

    public String getAsString() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getAsString();
        }
        return this.getRawContent();
    }

    public void setAsString(String value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setAsString(value);
        } else {
            this.setRawContent(value);
        }
    }

    public boolean hasDate() throws HL7V2Exception {
        boolean result;
        DataTypeDefn dt = this.getDataType();
        boolean bl = result = dt != null && (dt.getName().equals("DT") || dt.getName().equals("TM") || dt.getName().equals("TS"));
        if (result || this.getComponentCount() == 0) {
            return result;
        }
        return this.getComponent(0).hasDate();
    }

    public Date getAsDate() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getAsDate();
        }
        if (!this.getDefined() || this.getNullify()) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyymmdd");
        try {
            return df.parse(this.getRawContent());
        }
        catch (ParseException parseException) {
            throw new HL7V2Exception("Value in " + this.elementName() + " is not a proper date [" + this.getRawContent() + "]", 3);
        }
    }

    public Date getAsDateTime() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getAsDateTime();
        }
        if (!this.getDefined() || this.getNullify()) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyymmddhhnnss.zzz");
        try {
            return df.parse(this.getRawContent());
        }
        catch (ParseException parseException) {
            throw new HL7V2Exception("Value in " + this.elementName() + " is not a proper date [" + this.getRawContent() + "]", 3);
        }
    }

    public Date getAsDateTimeNoTZ() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).getAsDateTimeNoTZ();
        }
        if (!this.getDefined() || this.getNullify()) {
            return null;
        }
        try {
            return new Iso8601DateUtilities().parse(this.getRawContent(), "yyyymmddhhnnss.zzz", this.elementName());
        }
        catch (OHFException e) {
            throw new HL7V2Exception(e, 3);
        }
    }

    public void setAsDate(Date value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setAsDate(value);
        } else {
            this.setRawContent(Iso8601DateUtilities.format((Date)value, (String)"yyyymmdd"));
        }
    }

    public void setAsDateTime(Date value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setAsDateTime(value);
        } else {
            this.setRawContent(Iso8601DateUtilities.format((Date)value, (String)"yyyymmddhhnnss.zzz"));
        }
    }

    public void setAsDateTimeNoTZ(Date value) throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).setAsDateTime(value);
        } else {
            this.setRawContent(Iso8601DateUtilities.format((Date)value, (String)"yyyymmddhhnnss.zzz"));
        }
    }

    public String dateErrorMessage() throws HL7V2Exception {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0).dateErrorMessage();
        }
        if (!this.getDefined() || this.getNullify()) {
            return "No Content provided";
        }
        return new Iso8601DateUtilities().checkDateByMask(this.getRawContent(), "yyyymmddhhnnss.zzz", 2);
    }

    public abstract TableDefn getTable() throws HL7V2Exception;

    public boolean hasTable() throws HL7V2Exception {
        return this.getTable() != null;
    }

    public boolean isValidTableCode() throws HL7V2Exception {
        if (this.getComponentCount() > 1 || this.getComponentCount() == 1 && !this.hasTable()) {
            return this.getComponent(0).isValidTableCode();
        }
        TableDefn table = this.getTable();
        return table != null && table.isValidTableCode(this.getRawContent());
    }

    public void setAsTableCode(String code) throws HL7V2Exception {
        TableDefn table = this.getTable();
        this.condition(table != null, "Table is not assigned", 4);
        TableItemDefn item = table.getItems().itemByNameNoCase(code);
        this.condition(item != null, "Table value " + code + "is not valid", 4);
        this.setRawContent(item.getName());
    }

    public String getAsTableDescription() throws HL7V2Exception {
        if (this.getComponentCount() > 1 || this.getComponentCount() == 1 && !this.hasTable()) {
            return this.getComponent(0).getAsTableCode();
        }
        NamedDefn item = null;
        TableDefn table = this.getTable();
        if (table != null) {
            item = table.getItems().itemByNameNoCase(this.getRawContent());
        }
        if (item == null) {
            return null;
        }
        return item.getDescription();
    }

    public String getAsTableCode() throws HL7V2Exception {
        if (this.getComponentCount() > 1 || this.getComponentCount() == 1 && !this.hasTable()) {
            return this.getComponent(0).getAsTableCode();
        }
        TableDefn table = this.getTable();
        this.condition(table != null, "Table is not assigned", 4);
        TableItemDefn item = table.getItems().itemByNameNoCase(this.getRawContent());
        this.condition(item != null, "Table value " + this.getRawContent() + "is not valid", 4);
        return item.getName();
    }

    public Segment getSegment() {
        Item owner = this.getOwner();
        while (owner != null) {
            if (owner instanceof Segment) {
                return (Segment)owner;
            }
            owner = owner.getOwner();
        }
        return null;
    }

    public void copy(Cell cell) throws HL7V2Exception {
        block3: {
            block2: {
                this.clear();
                if (!cell.hasComponents()) break block2;
                int i = 1;
                while (i <= cell.getComponentCount()) {
                    this.forceComponent(i).copy(cell.getComponent(i));
                    ++i;
                }
                break block3;
            }
            if (!cell.hasContent()) break block3;
            this.createContents();
            int i = 0;
            while (i < cell.getContents().size()) {
                this.contents.add(cell.getContents().itemContent(i).cloneContent());
                ++i;
            }
        }
    }
}

