/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import java.util.Date;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponentIterator;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElementIterator;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElements;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentGroup;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentGroup;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public class CPMessageBuilder
extends Worker {
    private CPStaticDefinition definition;
    private int hl7Version;
    private boolean optionalSegments;
    private Message message;
    private Date date;

    public CPMessageBuilder() {
    }

    public CPMessageBuilder(int hl7Version, boolean optionalSegments, Message message, Date date) {
        this.init(hl7Version, optionalSegments, message, date);
    }

    private void init(int hl7Version, boolean optionalSegments, Message message, Date date) {
        this.hl7Version = hl7Version;
        this.optionalSegments = optionalSegments;
        this.message = message;
        this.date = date;
        if (this.date == null) {
            date = new Date();
        }
    }

    public void build(int hl7Version, CPStaticDefinition definition, boolean optionalSegments, Message message) throws HL7V2Exception {
        this.build(hl7Version, definition, optionalSegments, message, new Date());
    }

    public void build(int hl7Version, CPStaticDefinition definition, boolean optionalSegments, Message message, Date date) throws HL7V2Exception {
        this.definition = definition;
        this.init(hl7Version, optionalSegments, message, date);
        this.build();
    }

    public void build() throws HL7V2Exception {
        this.message.clear();
        this.message.setVersion(this.hl7Version);
        this.message.setEvent(this.definition.getEventType());
        this.message.setMessageType(this.definition.getMsgType());
        if (this.definition.hasMsgStructId()) {
            this.message.setStructId(this.definition.getMsgStructId());
        }
        this.message.addMSHFromFields(this.date);
        this.buildSegments(this.definition.getElements());
    }

    public SegmentGroup buildGroup(CPSegmentGroup segGroup) throws HL7V2Exception {
        SegmentGroup result = new SegmentGroup(true, segGroup.getName());
        int i = 0;
        while (i < segGroup.getElements().size()) {
            CPSegmentElement elem = segGroup.getElements().itemSegmentElement(i);
            if (elem instanceof CPSegmentGroup) {
                result.addGroup(this.buildGroup((CPSegmentGroup)elem));
            } else if (elem instanceof CPSegment) {
                result.addSegment(this.buildSegment((CPSegment)elem));
            }
            ++i;
        }
        return result;
    }

    private void buildSegments(CPSegmentElements segments) throws HL7V2Exception {
        CPSegmentElementIterator iter = segments.iteratorSegmentElement();
        iter.first();
        while (iter.more()) {
            if (this.optionalSegments || iter.currentSegmentBase().isRequired()) {
                if (iter.isSegment()) {
                    this.buildSegment(iter.currentSegment());
                } else if (iter.isSegmentGroup()) {
                    this.buildSegments(iter.currentSegmentGroup().getElements());
                } else {
                    throw new HL7V2Exception("unexpected type " + iter.currentSegmentBase().getClass().getName(), 25);
                }
            }
            iter.next();
        }
    }

    public Segment buildSegment(CPSegment definition) throws HL7V2Exception {
        return this.buildSegment(definition, -1);
    }

    public Segment buildSegment(CPSegment definition, int index) throws HL7V2Exception {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public void buildField(CPField definition, Field field) throws HL7V2Exception {
        if (definition.hasFixedValue()) {
            field.setAsString(definition.getFixedValue());
        }
        CPComponentIterator iter = definition.getComponents().iteratorComponent();
        iter.first();
        while (iter.more()) {
            this.buildComponent(iter.currentComponent(), field.forceComponent(iter.getCurrentIndex()));
            iter.next();
        }
    }

    public void buildComponent(CPComponent definition, Component component) throws HL7V2Exception {
        if (definition.hasFixedValue()) {
            component.setAsString(definition.getFixedValue());
        }
        CPComponentIterator iter = definition.getComponents().iteratorComponent();
        iter.first();
        while (iter.more()) {
            this.buildComponent(iter.currentComponent(), component.forceComponent(iter.getCurrentIndex()));
            iter.next();
        }
    }
}

