/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElements;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentGroup;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;

public class CPProfileBuilder {
    private VersionDefn version;

    public CPProfileBuilder() {
    }

    public CPProfileBuilder(VersionDefn version) {
        this.setVersion(version);
    }

    public VersionDefn getVersion() {
        return this.version;
    }

    public void setVersion(VersionDefn version) {
        this.version = version;
    }

    public void buildMessage(CPStaticDefinition confMessage, String event, String messageType) {
        confMessage.setMsgType(messageType);
        confMessage.setEventType(event);
        EventDefn eventDefn = this.version.getEvents().itemByName(event);
        if (eventDefn != null) {
            confMessage.setEventDesc(eventDefn.getDescription());
        }
        this.buildSegmentGroupList(confMessage, confMessage.getElements(), this.version.getEvents().itemByName(event).getMessages().itemByMessage(messageType).getStructure().getMap());
    }

    public void buildSegmentGroup(CPSegmentGroup confGroup, SegmentGroupDefn groupDefn) {
        if (groupDefn.isOptional()) {
            confGroup.setMin(0);
        } else {
            confGroup.setMin(1);
        }
        if (groupDefn.isRepeating()) {
            confGroup.setMax(-1);
        } else {
            confGroup.setMax(1);
        }
        confGroup.setName(groupDefn.getName());
        this.buildSegmentGroupList(confGroup, confGroup.getElements(), groupDefn);
    }

    private void buildSegmentGroupList(CPElement owner, CPSegmentElements elements, SegmentGroupDefn groupDefn) {
        int i = 0;
        while (i < groupDefn.getChildren().size()) {
            CPSegment seg;
            SegmentGroupDefn child = groupDefn.getChildren().item(i);
            if (child.getGroupType() == 0) {
                seg = new CPSegment(owner);
                if (child.isOptional()) {
                    seg.setMin(0);
                } else {
                    seg.setMin(1);
                }
                if (child.isRepeating()) {
                    seg.setMax(-1);
                } else {
                    seg.setMax(1);
                }
                this.buildSegment(seg, child.getName());
                elements.add(seg);
            } else if (child.getGroupType() == 1) {
                CPSegmentGroup grp = new CPSegmentGroup(owner);
                this.buildSegmentGroup(grp, child);
                elements.add(grp);
            } else {
                seg = new CPSegment(owner);
                if (child.isOptional()) {
                    seg.setMin(0);
                } else {
                    seg.setMin(1);
                }
                if (child.isRepeating()) {
                    seg.setMax(-1);
                } else {
                    seg.setMax(1);
                }
                this.buildSegment(seg, child.getChildren().item(0).getName());
                elements.add(seg);
            }
            ++i;
        }
    }

    public void buildSegment(CPSegment confSegment, String code) {
        this.buildSegment(confSegment, this.version.getSegments().itemByName(code));
    }

    public void buildSegment(CPSegment confSegment, SegmentDefn segmentDefn) {
        confSegment.clear();
        confSegment.setName(segmentDefn.getName());
        confSegment.setDescription(segmentDefn.getDescription());
        int i = 0;
        while (i < segmentDefn.getFields().size()) {
            CPField confField = confSegment.getFields().addField();
            this.buildField(confField, segmentDefn.getFields().item(i));
            ++i;
        }
    }

    public void buildField(CPField confField, FieldDefn fieldDefn) {
        confField.setItemNo(Integer.toString(fieldDefn.getDataElementId()));
        if (fieldDefn.isRequired()) {
            confField.setMin(1);
        } else {
            confField.setMin(0);
        }
        if (fieldDefn.isRepeatable()) {
            if (fieldDefn.getRepeatCount() > 0) {
                confField.setMax(fieldDefn.getRepeatCount());
            } else {
                confField.setMax(-1);
            }
        } else {
            confField.setMax(1);
        }
        DataElementDefn defn = fieldDefn.getDataElement();
        if (defn != null) {
            confField.setName(defn.getDescription());
            confField.setDataType(defn.getStructureCode());
            confField.setLength(defn.getLength());
            confField.setTable(Integer.toString(defn.getTableId()));
            confField.setUsage(3);
            confField.setDescription(defn.getDescription());
            StructureDefn struc = defn.getStructure();
            if (struc != null) {
                confField.setDescription(struc.getDescription());
                int i = 0;
                while (i < struc.getComponents().size()) {
                    CPComponent confComp = confField.getComponents().addComponent();
                    this.buildComponent(confComp, struc.getComponents().item(i), true);
                    ++i;
                }
            }
        }
    }

    public void buildComponent(CPComponent confComp, ComponentDefn compDefn, boolean subComponents) {
        confComp.setName(compDefn.getName());
        confComp.setDataType(compDefn.getDataTypeCode());
        confComp.setTable(Integer.toString(compDefn.getTableId()));
        confComp.setUsage(3);
        confComp.setDescription(compDefn.getName());
        StructureDefn struc = compDefn.getStructure();
        if (struc != null) {
            confComp.setDescription(struc.getDescription());
            if (subComponents) {
                int i = 0;
                while (i < struc.getComponents().size()) {
                    CPComponent confSubComp = confComp.getComponents().addComponent();
                    this.buildComponent(confSubComp, struc.getComponents().item(i), true);
                    ++i;
                }
            }
        }
    }
}

