/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.xml;

import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.eclipse.ohf.utilities.xml.XMLObjectParsers;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLReader
extends DefaultHandler {
    private XMLObjectParsers stack = new XMLObjectParsers();
    private XMLObjectParser root;

    public XMLReader(XMLObjectParser handler) throws SAXException {
        this.root = handler;
    }

    private XMLObjectParser current() throws SAXException {
        return this.stack.current();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String name;
        String namespace;
        if (uri == null || uri.equals("")) {
            namespace = "";
            name = qName;
        } else {
            namespace = uri;
            name = localName;
        }
        if (!this.stack.hasCurrent()) {
            if (this.root == null) throw new SAXException("no handler available");
            this.stack.push(this.root);
            this.root.setPath(name);
            this.root.start(namespace, name, "", atts);
            this.root = null;
            this.current().use();
            return;
        } else {
            XMLObjectParser handler = this.current().startElement(namespace, name, "", atts);
            if (handler == null) {
                this.current().use();
                return;
            } else {
                handler.use();
                handler.setPath(String.valueOf(this.current().getPath()) + "\\" + name);
                handler.setNamespace(namespace);
                handler.setName(name);
                this.stack.push(handler);
                this.current().start(namespace, name, "", atts);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name;
        String namespace;
        if (uri == null || uri.equals("")) {
            namespace = "";
            name = qName;
        } else {
            namespace = uri;
            name = localName;
        }
        if (this.current().unUse()) {
            XMLObjectParser old = this.current();
            old.end();
            this.stack.pop();
            if (this.stack.hasCurrent()) {
                this.current().endChild(old);
            }
        } else {
            this.current().endElement(namespace, name);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.current().findText(ch, start, length, StringUtils.isWhitespace((String)new String(ch, start, length)));
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.current().hasText()) {
            this.current().findText(ch, start, length, true);
        }
    }

    public void parse(InputStream stream) throws SAXException {
        try {
            org.xml.sax.XMLReader xml = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xml.setFeature("http://xml.org/sax/features/namespaces", true);
            xml.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            xml.setContentHandler(this);
            xml.parse(new InputSource(stream));
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }
}

